//-*-Mode: C++;-*-
#ifndef _SMMLParser_h_
#define _SMMLParser_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

#include "ExprBuilder.h"

extern "C" {
#ifdef XML2
#include <libxml/parser.h>
#include <libxml/xmlerror.h>
#include <libxml/parserInternals.h>
#include <libxml/xmlmemory.h>
#else
#include <parser.h>
#include <xml-error.h>
#include <parserInternals.h>
#include <xmlmemory.h>
#endif
}

typedef xmlSAXHandler smmlSAXHandler;
typedef xmlSAXHandlerPtr smmlSAXHandlerPtr;

class smmlParseData {

public:

     TCommandNode* _root;
     TCommandNode* _current;
     CString _char_buffer;
     CString _doc_name;
	 CString _input_path;
	 byte _first_element;

	smmlParseData( TCommandNode* root, const char* doc_name ) : _char_buffer(), _doc_name(doc_name) {
		_root = root;
		_current = root;
		_first_element = 1;
	}

};

typedef smmlParseData *smmlParseDataPtr;

//---- SMMLParser -----------------------------------------------------------

class SMMLParser  {
	
	smmlSAXHandlerPtr _smml_handler;
	smmlParseDataPtr _smml_parse_data;
	
	void InitHandler();
    		
public:
    
	 SMMLParser( TCommandNode* root, const char* doc_name, int debug = 0 );
	 ~SMMLParser();
	 
	 int parseFile ( const CString& path, const CString& file,  int recovery=0 );
 
	 int parseMemory (char *buffer, int size, int recovery=0 );
	 
	 inline TNode* rootNode() { return (_smml_parse_data == NULL) ? NULL : _smml_parse_data->_root; }
	 

};

#endif
