#include "ExprBuilder.h"
#include <sys/types.h>
#include <sys/stat.h>

#ifdef POSTGRESS

#include "sme_postgres.h"

extern "C" {
#include <ctype.h>
#include <libpq-fe.h>
}
#include <libpq/libpq-fs.h>

#define PG_DEFHOST "localhost"
#define PG_DEFPORT "5432"

#ifndef BUFSIZE
#define BUFSIZE 2048
#endif

#undef DBG

TNamedObjectList pgObjRec::fObjRecList;

pgObjRec::pgObjRec( const CString& classPath, const CString& objPath)	 {  
	_classPath = classPath; 
	_objPath = objPath;
	_curDate=0; 
	_status = kInActive; 
}

pgObjRec::pgObjRec( const CString& name )	: TNamedObject(name) {
	_curDate = 0; 
	_status = kInActive; 
}

pgObjRec* pgObjRec::New(const CString& name) {
	pgObjRec* pgrec = new pgObjRec(name);
	fObjRecList.append(*pgrec);
	return pgrec;
}

pgObjRec* pgObjRec::FindRec(const CString& classPath, const CString& objPath, const CString& fileName) {
	for( Pix p = fObjRecList.first(); p; fObjRecList.next(p) ){
		pgObjRec& pgr = (pgObjRec&)	fObjRecList(p);
		if( (pgr._classPath == classPath) &&  (pgr._objPath == objPath) &&  (pgr._fileName == fileName) ) return &pgr;
	}
	return (pgObjRec*) NULL;
}

int pgObjRec::AddDBaseObject(const CString& classPath, const CString& objPath, const CString& fileName, EMode mode ) {
	pgObjRec* pgr = FindRec( classPath, objPath, fileName );
	int ri = fObjRecList.length();
	if(pgr == NULL) {
		CString name("rec"); name.appendIndex(ri);
		pgr = New(name);
		pgr->_classPath = classPath; 
		pgr->_objPath = objPath;
		pgr->_fileName = fileName;
	} 
	pgr->Activate();
	pgr->_Mode = mode;
	return ri;
}

int pgObjRec::ProcessAttribute(const TAttributeNode* an) {
	const TDeclarationNode* dn = an->Declaration();
	const TNode* vn = an->Value();
	const CString& cmd = dn->Command();
	const ArgArray&  ql = dn->QualifierList()->List();
	if( vn == NULL ) return 0;
	
  int iarg; float farg;
  if( cmd == "ClassPath" ) {
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) { _classPath = *s; }
		}
	}
  if( cmd == "ObjPath" ) {
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) { _objPath = *s; }
		}
	}
  if( cmd == "FileName" ) {
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) { _fileName = *s; }
		}
	}
  if( cmd == "Date" ) {
		if( GetAttrValue( vn, kAVInt ) ) {
			_curDate = (long)fAttrValue;
		}
  }
}

void pgObjRec::WriteMML( FILE* oFile, EWriteMode mode )  {
	fprintf( oFile, "DBaseObject %s { \n\tClassPath = %s;\n\tObjPath =  %s;",
		Name(), (const char*)_classPath, (const char*)_objPath ); 
	fprintf( oFile, "\n\tFileName = %s;\n\tDate =  %li;", (const char*)_fileName, _DBdate[0] ); 
	fprintf( oFile, "\n}");
}

TNamedObjectList  pgSQLRec::fSQLRecList;

pgSQLRec::pgSQLRec( const CString& name )	: TNamedObject(name) {
	_status = kInActive; 
	fValueColIndex = 1;
	fMapColIndex[0] = 0;
	fNMaps = -1;
}
  
pgSQLRec* pgSQLRec::New(const CString& name) {
	pgSQLRec* pgrec = (pgSQLRec*) fSQLRecList.GetObjectByName(name);
	if( pgrec != NULL ) { sprintf(gMsgStr,"SQLRec defined twice: %s",pgrec->Name() ); gPrintErr(); return pgrec; }
	pgrec = new pgSQLRec(name);
	fSQLRecList.append(*pgrec);
	return pgrec;
}

const CString& pgSQLRec::SQLCode() const { 
	if(_status == kInActive) { sprintf( gMsgStr, "Attempt to access Unallocated  SQLRec %s",Name()); gPrintErr(); }
	return fSQL; 
}

pgSQLRec* pgSQLRec::GetSQLRec( const CString& name ) {
	pgSQLRec* pgrec = (pgSQLRec*) fSQLRecList.GetObjectByName(name);
	if(pgrec==NULL) { sprintf(gMsgStr,"Invoking an undefined SQL Function: %s",name.chars()); gPrintErr(); }
	return pgrec;	
}

int pgSQLRec::ProcessAttribute(const TAttributeNode* an) {
	const TDeclarationNode* dn = an->Declaration();
	const TNode* vn = an->Value();
	const CString& cmd = dn->Command();
	const ArgArray&  ql = dn->QualifierList()->List();
	if( vn == NULL ) return 0;
	
  int iarg; float farg;
  if( cmd == "Arg" ) {
		const CString& name = dn->Name()->Top();
		fArgs.Add(name);
		int narg = fArgs.NArgs();
		fDefaultArgs.elem(narg) = "NULL";
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) { fDefaultArgs.elem(narg) = *s; }
		}
	} else if( cmd == "ValueFieldIndex" ) {
			if( GetAttrValue( vn, kAVInt ) ) {
				fValueColIndex = fAttrValue;
			}
	} else if( cmd == "MapFieldIndex" ) {
			if( GetAttrValue( vn, kAVInt ) ) {
				if( fNMaps == -1 ) fNMaps = 0;
				if (fNMaps==4) { Env::error("Too many map indices for parameter %s (max=4)",Name()); }
				else { fMapColIndex[fNMaps++] = fAttrValue; }
			}
	} else if( cmd == "Code" ) {
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) { fSQL = *s; 	_status = kActive; }
		}
	}
} 

void pgSQLRec::WriteMML( FILE* oFile, EWriteMode mode )  {
	fprintf( oFile, "DBaseFunction %s { \n\t", Name() ); 
	for( int i=0; i<fArgs.NArgs(); i++ ) {
		fprintf( oFile, "\tArg %s = %s\n\t", (const char*)fArgs[i], (const char*)fDefaultArgs[i]);
	}
	fprintf( oFile, "\tCode = !{ %s }!\n}\n", (const char*)fSQL );
}

const ArgArray& pgSQLRec::Args() const { return fArgs; } 

const ArgArray& pgSQLRec::DefaultArgs() const { return fDefaultArgs; }
 
int sme_pg95::import_object(const char* file)
{
#ifdef POSTGRESS
  char buf[BUFSIZE];
  int fd = open(file, O_RDONLY, 0666);
  if (fd < 0)
      return 0;

  int lobj = lo_creat((PGconn*)_conn, INV_READ|INV_WRITE|INV_ARCHIVE);

  if (lobj != 0)
    {
      int nb;
      int lfd = lo_open((PGconn*)_conn, lobj, INV_WRITE);
      while ((nb = ::read(fd, buf, BUFSIZE)) > 0)
	{
	  int tmp = lo_write((PGconn*)_conn, lfd, buf, nb);
	  if (tmp < nb) 
	    {
	      gPrintErr("PG error writing large object");
	      break;
	    }
	}
      (void)lo_close((PGconn*)_conn, lfd);
    }
  (void)close(fd);

  return lobj;
#else
	return 0;
#endif
}

int sme_pg95::get_object_data(pgObjRec & or) {
#ifdef POSTGRESS
	CString sqlCode("SELECT classpath, objpath, d_update, data FROM object WHERE classpath = ");
	sqlCode += "'"; sqlCode += or._classPath; sqlCode += "'"; 
	sqlCode += " AND objpath = ";
	sqlCode += "'"; sqlCode += or._objPath; sqlCode += "'"; 
	sqlCode += " ORDER BY d_update;";
#ifdef DBG
  printf ("DBG: submitting query: %s\n", sqlCode.chars() );
#endif
  PGresult* qr = PQexec((PGconn*)_conn, (const char*)sqlCode);
  
	int ntup = 0, nrec=0, nf, index;
  if (qr && PQresultStatus(qr) == PGRES_TUPLES_OK) {
     ntup = PQntuples(qr);
     nrec = (ntup < kSMEMaxTuples) ? ntup : kSMEMaxTuples;
     for( int i=0; i<nrec; i++ )  {
       nf = PQnfields(qr);
       index = nrec-1-i;
       if( nf >= 4 ) {
         or._DBdate[index] = atol( PQgetvalue(qr, i, 2) );
         or._oid[index] = atol( PQgetvalue(qr, i, 3) );
       } else { or._DBdate[index] = 0; or._oid[index] = 0; }
    }
  } else { sprintf(gMsgStr,"DBase Read Error on (%s,%s) : (%s)",
								or._classPath.chars(), or._objPath.chars(), sqlCode.chars() ); 
					 gPrintErr();
	}
  or.fNRec = nrec;
  if (qr) PQclear(qr);
  return ntup;
#else
	return 0;
#endif	
}

int sme_pg95::set_object_data(pgObjRec & or) { return 0;}

int sme_pg95::export_object(long int oid, const char* file)
{
#ifdef POSTGRESS
  char buf[BUFSIZE];

  int lfd = lo_open((PGconn*)_conn, oid, INV_READ);
  if (lfd < 0) return 0;

  int fd = open(file, O_CREAT|O_WRONLY, 0666);
  
  if (fd < 0)  return 0;
  
  int nb; int ret = 1;
  while ((nb = lo_read((PGconn*)_conn, lfd, buf, BUFSIZE)) > 0) 
    {
      int tmp = ::write(fd, buf, nb);
      if (tmp < nb) ret = 0;
    }
  (void)lo_close((PGconn*)_conn, lfd);
  (void)close(fd);	      
  return ret;
#else
	return 0;
#endif	
}

void sme_pg95::submit_sql(const char* c)
{
#ifdef POSTGRESS
#ifdef DBG
  printf ("DBG: submitting command: %s\n", c);
#endif
  PGresult* res = PQexec((PGconn*)_conn, (char*)c);
  if (res)
  { 
    PQclear(res);     
    _status = PQresultStatus(res) == PGRES_COMMAND_OK;
  }
  else _status = 0;
#endif	
}

int sme_pg95::import_file(const char* filename)
{
#ifdef POSTGRESS
		PGresult* res = PQexec((PGconn*)_conn, "begin");
		PQclear(res);
		int i = import_object(filename);
		res = PQexec((PGconn*)_conn, "end");
		PQclear(res);
		return i;
#else
	return 0;
#endif	
}

int sme_pg95::export_file( long int oid, const char* filename )
{
#ifdef POSTGRESS
		PGresult* res = PQexec((PGconn*)_conn, "begin");
		PQclear(res);
		int i = export_object(oid,filename);
		res = PQexec((PGconn*)_conn, "end");
		PQclear(res);
		return i;
#else
	return 0;
#endif	
}

int sme_pg95::CacheObject(pgObjRec& pgr) {
  CPathString path(Env::DataPath());
  path.Add("cache.in");  
  path.Add(pgr._fileName);  
	int i = export_file( pgr._oid[0], path );
	if(i) { 
		pgr.UpdateCurrentDate(); 
		sprintf(gMsgStr,"Updating cached object %s from dataBase",pgr._fileName.chars());
		gPrintScreen();
	}
	return i;
}

int sme_pg95::ImportObject(pgObjRec& pgr) {
  CPathString path(Env::DataPath());
  path.Add("cache.in");  
  path.Add(pgr._fileName);  
		int i = (pgr._oid[0] = import_file( path ));
//		if(i) { pgr.UpdateCurrentDate(); }
		return i;
}

void sme_pg95::exec_file(const char* filename)
{
#ifdef POSTGRESS
  CString cmd(NULL,512);
    
  FILE* fp = fopen(filename, "r");
  if (fp == NULL) {
    sprintf (gMsgStr,"pg95db: exec_file: file %s read error",filename); gPrintErr();
    _status = 0;
    return;
  }
  static char buf[128];
  while (!feof(fp)) {
    if (fgets(buf, 128, fp) == NULL)
      break;
    // chop newline
    buf[strlen(buf)-1] = '\0';
    // trim leading whitespace
    int i = 0;    
    while (isspace(buf[i]) && buf[i]) i++;
    // ignore comments and white lines
    if (buf[i] == '-' && buf[i+1] == '-')
      continue;
    if (buf[i] == '\0') continue;    
    cmd += buf;
    cmd.trim();
    if (cmd[cmd.length() - 1] == ';')
    {
      submit_sql((const char*)cmd);
      cmd = "";
      if (_status == 0)
        break;
    } 
  }
  fclose(fp);
#endif	
}


void sme_pg95::exec_sql(const char* code)
{
	const char* p = code;
	while (isspace(*p)) p++;
	if (strncmp(p,"SELECT",6) == 0)
		submit_query_alltup(code);
	else  
		submit_sql(code); 
}

void sme_pg95::exec_sql   ( const pgSQLRec& sqlRec, const ArgArray& new_args ) {
	CString code( sqlRec.SQLCode() );
  const ArgArray& args = sqlRec.Args();
  const ArgArray& dargs = sqlRec.DefaultArgs();
	for( int i=0; i < args.NArgs(); i++ ) {
		if( i < new_args.NArgs() ) {
			code.gsub(args[i],new_args[i]);
		} else {
			if( dargs[i] == "NULL" ) { sprintf( gMsgStr, "Missing Argument in SQL record %s\n",sqlRec.Name()); gPrintErr(); }
			else { code.gsub(args[i],dargs[i]); }		
		}
	}
	exec_sql(code);
}

int sme_pg95::submit_query_alltup(const char* c) {
#ifdef POSTGRESS
#ifdef DBG
  printf ("DBG: submitting query: %s\n", c);
#endif
	fTuples.Clear();
  PGresult* qr = PQexec((PGconn*)_conn, (char*)c);
  int nt = 0;
  
  if (qr && PQresultStatus(qr) == PGRES_TUPLES_OK)  {
     CString res;
     nt = PQntuples(qr);
     for (int i = 0; i < nt;  i++) {
       int nf = PQnfields(qr);
       res = "";
       for (int j = 0; j < nf; j++) {
         res += (const char*)PQgetvalue(qr, i, j);
         if (j < (nf - 1)) res  += ",";
       }
       fTuples.Add(res);
    }
  }
  if (qr) PQclear(qr);
  return nt;
#else
	return 0;
#endif	
}

int sme_pg95::submit_query_onetup(const char* c, int tuples_backcount ) {
#ifdef POSTGRESS
#ifdef DBG
  printf ("DBG: submitting query: %s\n", c);
#endif
	fTuples.Clear();
	int nf = 0;
  PGresult* qr = PQexec((PGconn*)_conn, (char*)c);
  
  if (qr && PQresultStatus(qr) == PGRES_TUPLES_OK)  {
     int i = ( PQntuples(qr) - 1 ) - tuples_backcount;
     if( i >= 0 )  {
       nf = PQnfields(qr);
       for (int j = 0; j < nf; j++) {
         fTuples.Add( (const char*)PQgetvalue(qr, i, j) );
       }
    }
  }
  if (qr) PQclear(qr);
  return nf;
#else
	return 0;
#endif	
}

sme_pg95::sme_pg95( const char* dbase_name, Bool cflag, const char* port, const char* host ) 
{
  if(port) _port = port; else _port = PG_DEFPORT;
  
  if(host) _host = host; 
  else {
		char* env_host = getenv("PGHOST");
		if ( env_host ) _host = env_host;
		else _host = PG_DEFHOST;
	}
  _new = 0;
#ifdef POSTGRESS
	_conn = PQsetdb(_host.empty() ? (char*)NULL : (char*)(const char*)_host,
                    _port.empty() ? (char*)NULL : (char*)(const char*)_port,
                    NULL, NULL, dbase_name);
	_status = PQstatus((PGconn*)_conn) == CONNECTION_OK;

  if (!_status && cflag)
  {
    PQfinish((PGconn*)_conn);
    _conn = PQsetdb(_host.empty() ? (char*)NULL : (char*)(const char*)_host,
                    _port.empty() ? (char*)NULL : (char*)(const char*)_port,
                    NULL, NULL, "template1");
    if ((_status = PQstatus((PGconn*)_conn)) == CONNECTION_OK)
    {
      printf("Creating DB %s\n", dbase_name);
      CString stmp("CREATE DATABASE "); stmp += dbase_name; stmp += ";";
      PGresult* res =   PQexec((PGconn*)_conn, stmp);
      _status = (res && PQresultStatus(res) == PGRES_COMMAND_OK);
      if (res) PQclear(res);
      PQfinish((PGconn*)_conn);
      if (_status)
      {
        _conn = PQsetdb(_host.empty() ? (char*)NULL : (char*)(const char*)_host,
                        _port.empty() ? (char*)NULL : (char*)(const char*)_port,
                       NULL, NULL, dbase_name);
        _status = PQstatus((PGconn*)_conn) == CONNECTION_OK;
        _new = 1;
      }
    } 
	} 
	if (!_status) {
		sprintf(gMsgStr,"Can't connect to dbase: %s ( host = %s, port = %s )", dbase_name, (const char*)_host, (const char*)_port ); gPrintErr(); 
	}
#endif	
}

sme_pg95::~sme_pg95() 
{
#ifdef POSTGRESS
  if ((PGconn*)_conn) PQfinish((PGconn*)_conn);
#endif	
}


#endif	
