#ifndef __sme_postgres_H
#define __sme_postgres_H

#include "MML.h"

#define kSMEMaxTuples 64

#ifdef POSTGRESS

class pgObjRec : public MMLObject, public TNamedObject
{
	friend class sme_pg95;
	
public:
	enum EStatus { kInActive, kActive };
	enum EMode { kSMEInput, kSMEOutput };

protected:	
  long int _DBdate[kSMEMaxTuples];
  long int _curDate;
  long int _oid[kSMEMaxTuples];
  int fNRec;
  EMode _Mode;
  EStatus _status;
  CString _classPath;
	CString _objPath;
	CString _fileName;
  static TNamedObjectList  fObjRecList;

public:

	pgObjRec( const CString& classPath, const CString& objPath)	;
	pgObjRec( const CString& name );
	static pgObjRec* New(const CString& name);
	static pgObjRec* FindRec(const CString& classPath, const CString& objPath, const CString& fileName);
	static int AddDBaseObject(const CString& classPath, const CString& objPath, const CString& fileName, EMode mode = kSMEInput );
	static TNamedObjectList&  ObjRecList() { return fObjRecList; }
	void Activate() { _status = kActive; }
	Bool Active() { return (_status == kActive); }
	EMode Mode() { return _Mode; } 
	inline void UpdateCurrentDate() { _curDate = _DBdate[0]; }
	const CString& FileName() { return  _fileName; }
	
	inline long DBDate(int index=0) { return _DBdate[index]; }
	inline long CurDate() { return _curDate; }
  inline long OID(int index=0) { return _oid[index]; }
  inline int NRec() { return fNRec; }
	virtual int ProcessAttribute(const TAttributeNode* n);
  virtual void WriteMML( FILE* oFile, EWriteMode mode = kDefinition );
  inline int operator==( pgObjRec& pgr ) { 
		return ( (_classPath == pgr._classPath) && (_objPath == pgr._objPath)); 
	}
	inline int DateCmp() { 
		if( _curDate ==  0         ) { return  0; }
		if( _curDate >= _DBdate[0] ) { return  1; }
		if( _curDate <  _DBdate[0] ) { return -1; }
		return 0;
	}
};

class pgSQLRec : public MMLObject, public TNamedObject
{
	friend class sme_pg95;
	enum EStatus { kInActive, kActive };
  CString fSQL;
  ArgArray fArgs; 
  ArgArray fDefaultArgs;
  EStatus _status;
  int fValueColIndex; 
  int fMapColIndex[4];
  int fNMaps; 
  
  static TNamedObjectList  fSQLRecList;
   
public:
	pgSQLRec( const CString& name );
	static pgSQLRec* New(const CString& name);
	static pgSQLRec* GetSQLRec(const CString& name);
  virtual void WriteMML( FILE* oFile, EWriteMode mode = kDefinition );
	virtual int ProcessAttribute(const TAttributeNode* n);
	const CString& SQLCode() const ;
	const ArgArray& Args() const;
	const ArgArray& DefaultArgs() const;
	inline int ValueFieldIndex() const { return  fValueColIndex; }
	inline int MapFieldIndex(int index) const { return  fMapColIndex[index]; }
  inline int NMaps() { return fNMaps; }
};

class sme_pg95 
{
  void* _conn;
  CString _host;
  CString _port;
  int     _status;
  int     _new;
  ArgArray fTuples;
  
protected:

  void submit_sql(const char*);    
  int submit_query_alltup(const char*);
  int submit_query_onetup(const char* c, int tuples_backcount );                        

  int import_object(const char* file);
  int export_object(long int oid, const char* file);
                         
public:

  void exec_sql   (const char* code);
  void exec_sql   ( const pgSQLRec& sqlRec, const ArgArray& args );
  void exec_file  (const char* filename);
  int import_file(const char* filename);
  int export_file( long int oid, const char* filename );
  int get_object_data(pgObjRec & pgor);
	int set_object_data(pgObjRec & pgor) ;
  int CacheObject(pgObjRec& pgr);
  int ImportObject(pgObjRec& pgr);
  
  inline const CString& GetTuples(int iTuple) const { return fTuples[iTuple]; }
  inline int GetNTuples() { return fTuples.NArgs(); }
  inline const CString& host() { return  _host; }
  inline const CString& port() { return  _port; }

  sme_pg95(const char* dbase_name, Bool cflag=0, const char* port = NULL, const char* host=NULL);
  virtual ~sme_pg95();
};

#endif
#endif

