//-*-Mode: C++;-*-
#ifndef _ActivationLayer_
#define _ActivationLayer_

#if __GNUG__ >= 2
#  pragma interface
#endif

#include "Layer.h"
#include "PixPlex.h"
#include "IntPixHashMap.h"
#include "Ghost.h"
#include "IntGrid.h"
typedef class MultiGrid MultiGrid;

//---- CellPlex ---------------------------------------------------------

class CellPlex : public TOrderedObject {
	PixXPlex _cells;
	int32 _ncells;
	
	public:

	CellPlex( int index ) : TOrderedObject(index)  {  _ncells = 0; }
	CellPlex( int index, int l, int chunksize ) : TOrderedObject(index), _cells(l,chunksize)  {  _ncells = 0; }
	
	inline TCell* cell( int32 index ) {
		return (TCell*) _cells.elem(index);
	}
	
	inline int32 length() { return _ncells; }	
	inline int32 nCells() { return  _ncells; }
	virtual inline int32 nActiveCells() { return  _ncells; }
	
	virtual inline void clear() { _ncells = 0; _cells.fill(0);  }	
	
	virtual inline int32 add( TCell* c ) {
		if( _ncells < _cells.length() ) { _cells.elem(_ncells) = c; }
		else { _cells.add_high(c); }
		return _ncells++;
	}
	
	void copyRegion( MultiGrid* g, Region2& r, int layer_index = -1 ) ;
};

//---- ActivationLayer ---------------------------------------------------------

class ActivationLayer : public CellPlex {
	
	int32 _nActiveCells;
	int32 _nGhostCells;
	int _currentLayerIndex;
	
	GhostCellMap** _ghostCellMap;
	int _maxGhost;
	intPixVHMap _ghostMapData;
	Bool _sendmapGenerated;
	Bool _cellsFinalized;
	Bool _multiLayers;
	int _nSendRequests;
	int _nReceiveRequests;
	MultiGrid* _multiGrid;
	
	PixArray _cellBuffer;
	PixArray _ghostBuffer;
	IntArray _LayerOffset;
	IntArray _GhostOffset;

#ifdef USE_MPI
	TMsgBuff* ghostMapData(int iproc);
	GhostCellMap* ghostCellMap( int iproc );
	void transferSendmapData(int nprocs);
	void createSendMap( TMsgBuff& inBuff );
#endif
	int32 finalizeCell( TCell* c );
			
public:
	
	ActivationLayer( MultiGrid* multiGrid, int index, int maxGhost=0 ) : CellPlex(index),  _ghostMapData(0,64), 
			_cellBuffer(32,32,(Pix)0), _ghostBuffer(32,32,(Pix)0), _LayerOffset(32,32,-1), _GhostOffset(32,32,-1)  {  
		_multiGrid = multiGrid; _nActiveCells = _nGhostCells = _maxGhost = 0; _multiLayers = False; _currentLayerIndex = -1;
		_ghostCellMap = NULL;  _cellsFinalized = _sendmapGenerated = False;  _nSendRequests = _nReceiveRequests = 0; _maxGhost = maxGhost;
	}
	ActivationLayer(MultiGrid* multiGrid, int index, int maxGhost, int l, int chunksize ) :  CellPlex(index,l,chunksize), 
				_ghostMapData(0,64), _cellBuffer(32,32,(Pix)0), _ghostBuffer(32,32,(Pix)0),  _LayerOffset(32,32,-1), _GhostOffset(32,32,-1)  {  
		_multiGrid = multiGrid; _nActiveCells = _nGhostCells =  0; _maxGhost = maxGhost; _multiLayers = False; _currentLayerIndex = -1;
		_ghostCellMap = NULL;  _cellsFinalized = _sendmapGenerated = False; _nSendRequests = _nReceiveRequests = 0; 
	}

	void addCell( TCell* c );
	void finalizeCells();
			
	inline int32 nActiveCells() { return  _nActiveCells; }
	inline int32 nGhostCells() { return  _nGhostCells; }
	inline void clear() { _nActiveCells = _nGhostCells = 0; CellPlex::clear();  }	
	
	float mapValue( TCell* c, int activationLevel, const float* origonData, Bool doAverage, float nullValue=0.0 );

	inline int maxGhost() { return _maxGhost; }
	int nSendRequests() { return _nSendRequests; }
	int nReceiveRequests() { return  _nReceiveRequests; }
	inline int layerOffset(int ilayer) { return _LayerOffset(ilayer); }
	inline int _ghostOffset(int ilayer) { return _GhostOffset(ilayer); }
  	inline Bool multiLayers() { return _multiLayers; }


	
#ifdef USE_MPI	
	MPI_Request* setupCommunication( int& nrequest, int nprocs, int nGhost, const float* data, MPI_Comm comm, int tag );
	void dumpTransferData( int iproc, int nGhost, const float* data, EG_LinkMode mode );
#endif

};

#endif
