#include "Array1XObject2.h"

/****************************************************************
*								*
* Array1.C.m4							*
*								*
* Class Array1 implements an 1-dimensional lparx grid.  	*
* The elements of the grid are given by ``XObject2''.		*
*								*
* Author:  Scott Kohn (skohn-at-cs.ucsd.edu)			*
* Revised: Stephen Fink						*
*****************************************************************/

// #include <generic.h>
#include "Point1.h"
#include "Region1.h"

/****************************************************************
*								*
* Define the Array constructors and resize operators.		*
*								*
*****************************************************************/

Array1(XObject2)::Array1(XObject2)()
  : _region(),
    _extents(Point1(0)),
    _bottom(0),
    _delete_data(FALSE),
    _size(0),
    _array((XObject2 *) NULL) { }

Array1(XObject2)::Array1(XObject2)(const Region1& region)
  : _region(region),
    _extents(_region.upper()-_region.lower()+1),
    _bottom(-_region.lower(0)),
    _delete_data(TRUE),
    _size(_region.size()),
    _array(_size ? new XObject2[_size] : ((XObject2 *) NULL)) { }

Array1(XObject2)::Array1(XObject2)(const int i)
  : _region(0, i-1),
    _extents(i),
    _bottom(-_region.lower(0)),
    _delete_data(TRUE),
    _size(_region.size()),
    _array(_size ? new XObject2[_size] : ((XObject2 *) NULL)) { }

Array1(XObject2)::Array1(XObject2)(const Region1& region, XObject2 *data, const int release)
  : _region(region),
    _extents(_region.upper()-_region.lower()+1),
    _bottom(-_region.lower(0)),
    _delete_data(release),
    _size(_region.size()),
    _array(data) { }

Array1(XObject2)::Array1(XObject2)(const int i, XObject2 *data, const int release)
  : _region(0, i-1),
    _extents(i),
    _bottom(-_region.lower(0)),
    _delete_data(release),
    _size(_region.size()),
    _array(data) { }

void Array1(XObject2)::resize(const Region1& region)
  {
   if (_delete_data && _array) delete [] _array;
   _region = region;
   _extents = _region.upper()-_region.lower()+1;
   _bottom = -_region.lower(0);
   _delete_data = TRUE;
   _size = _region.size();
   _array = (_size ? new XObject2[_size] : ((XObject2 *) NULL));
  }

void Array1(XObject2)::resize(const int i)
  {
   if (_delete_data && _array) delete [] _array;
   _region = Region1(0, i-1);
   _extents = Point1(i);
   _bottom = -_region.lower(0);
   _delete_data = TRUE;
   _size = _region.size();
   _array = (_size ? new XObject2[_size] : ((XObject2 *) NULL));
  }

void Array1(XObject2)::fill(const XObject2& t)
  {
   for (int i = 0; i < _size; i++) _array[i] = t;
  }
