#include "Array1int.h"

/****************************************************************
*								*
* Define the Array constructors and resize operators.		*
*								*
*****************************************************************/

Array1(int)::Array1(int)()
  : _region(),
    _marker(Point1(0)),
    _bottom(0),
    _delete_data(FALSE),
    _size(0),
    _array((int *) NULL) { }

Array1(int)::Array1(int)(const Region1& region)
  : _region(region),
    _marker(Point1(0)),
    _bottom(-_region.lower(0)),
    _delete_data(TRUE),
    _size(_region.size()),
    _array(_size ? new int[_size] : ((int *) NULL)) { fill(0); }

Array1(int)::Array1(int)(const int i)
  : _region(0, i-1),
    _marker(Point1(0)),
    _bottom(-_region.lower(0)),
    _delete_data(TRUE),
    _size(_region.size()),
    _array(_size ? new int[_size] : ((int *) NULL)) { fill(0); }

Array1(int)::Array1(int)(const Region1& region, int *data, const int release)
  : _region(region),
    _marker(Point1(0)),
    _bottom(-_region.lower(0)),
    _delete_data(release),
    _size(_region.size()),
    _array(data) { }

Array1(int)::Array1(int)(const int i, int *data, const int release)
  : _region(0, i-1),
    _marker(Point1(0)),
    _bottom(-_region.lower(0)),
    _delete_data(release),
    _size(_region.size()),
    _array(data) { }

void Array1(int)::resize(const Region1& region)
  {
   _region = region;
   int newbottom = -_region.lower(0);
   int newsize = _region.size();
   _delete_data = TRUE;
   int* newarray = ( newsize > 0 ) ? new int[newsize]  : (int*) NULL;
   if( _array ) {
     if( newarray ) {
       for (int i = 0; i < newsize; i++) newarray[i] = 0;
       memcpy(newarray+(newbottom-_bottom),_array,_size*sizeof(int));
     }
     if (_delete_data) delete [] _array;
   }
   _array = newarray;
   _size = newsize;
   _bottom = newbottom;
  }

void Array1(int)::resize( const int index, const int buff )
  {
   if(_region.inside(index)) return;
   _region.expand(index,buff);
   int newbottom = -_region.lower(0);
   int newsize = _region.size();
   _delete_data = TRUE;
   int* newarray = ( newsize ) ?  ( new int[newsize]  ) : ((int *) NULL);
   if( _array ) {
     if( newarray ) {
       for (int i = 0; i < newsize; i++) newarray[i] = 0;
       memcpy(newarray+(newbottom-_bottom),_array,_size*sizeof(int));
     }
     if (_delete_data) delete [] _array;
   }
   _array = newarray;
   _size = newsize;
   _bottom = newbottom;
  }

void Array1(int)::resize(const int i)
  {
   if (_delete_data && _array) delete [] _array;
   _region = Region1(0, i-1);
   _bottom = -_region.lower(0);
   int newsize = _region.size();
   _delete_data = TRUE;
   int* newarray= ( newsize>0) ? new int[newsize] : (int*) NULL;
   if( _array ) {
     if( newarray ) {
       for (int i = 0; i < newsize; i++) newarray[i] = 0;
       memcpy(newarray,_array,_size*sizeof(int));
     }
     if (_delete_data) delete [] _array;
   }
   _array = newarray;
   _size = newsize;
  }



void Array1(int)::fill(const int& t)
  {
   for (int i = 0; i < _size; i++) _array[i] = t;
  }
