#if __GNUG__ >= 2
#  pragma implementation
#endif

#include "CellRecord.h"

#ifdef USE_MPI

//---- CellRecordArray -----------------------------------------------------------

CellRecordArray::CellRecordArray( int size, int size_incr ) { 
	_nCellRecords = _nAllocated = 0; 
	_sizeIncrement = size_incr; 
	_CellRecords = NULL;  
	if( size > 0 ) { realloc(size); } 
}

void CellRecordArray::realloc( int newsize ) {
	 CellRecord* tmp = new CellRecord[newsize];
	 if( _nAllocated > 0 ) {
		 memcpy(tmp,_CellRecords,_nAllocated*sizeof(CellRecord));
		 delete[] _CellRecords;
	 } 
	 _CellRecords = tmp;
	 _nAllocated = newsize;
}

//---- CellRecordDistributedArray -----------------------------------------------------------

MPI_Datatype CellRecordDistributedArray::_CellRecordType = MPI_DATATYPE_NULL;

void CellRecordDistributedArray::generateCellRecordType() {
	if( _CellRecordType == MPI_DATATYPE_NULL ) {
		int bl[2];
		MPI_Aint disp[2];
		MPI_Datatype types[2];
		bl[0] = NCellRecordInts;
		bl[1] = NCellRecordFloats;
		disp[0] = 0;
		disp[1] = NCellRecordInts*sizeof(int);
		types[0] = MPI_INT;
		types[1] = MPI_FLOAT;
		MPI_Type_struct(2,bl,disp,types,&_CellRecordType);
	}
}

int CellRecordDistributedArray::generateInArray() {
	int i;
	const int nprocs = gNProcs();
	memset( _dataBuff, 0, nprocs*sizeof(int) );
	for( i=0; i<nprocs; i++ ) {
		_dataBuff[i] = _CellRecordOutArrays[i].nCellRecords();
	}
	MPI_Alltoall(_dataBuff,1,MPI_INT,_dataBuff,1,MPI_INT,MPI_COMM_WORLD);
	for( i=0; i<nprocs; i++ ) {
		CellRecordArray& cr = _CellRecordOutArrays[i];
		if( cr.nCellRecords() > 0 ) {
			MPI_Isend( cr.CellRecordData(), cr.nCellRecords(), _CellRecordType, i, CellRecordDistributedArrayTag, MPI_COMM_WORLD, _com_request+i );
		}
	}
	int incount = 0;
	for( i=0; i<nprocs; i++ ) {  
		if( _dataBuff[i] > 0 ) {
			_CellRecordInArray.setDataSize( incount + _dataBuff[i] );
			MPI_Recv( _CellRecordInArray.CellRecordData( incount ), _dataBuff[i], _CellRecordType, i, CellRecordDistributedArrayTag, MPI_COMM_WORLD, _com_status+i );
			incount += _dataBuff[i];
		}
	}
	return incount;
}

#endif

