#ifndef __FloatGrid__
#define __FloatGrid__

#include "Point1.h"
#include "Point2.h"
#include "Region1.h"
#include "Region2.h"
#include "Environ.h"
#include <math.h>
#include <string.h>

typedef class FloatGrid FloatGrid;

//----------------------------------------------------------------------------------------
//						FloatGrid
//----------------------------------------------------------------------------------------

class FloatGrid : public Region2
{
protected:
  float* fData;
  static float fGarbage;
  
public:
                         // Constructors

  FloatGrid(int r0, int c0, int r1, int c1, int r_inc = 1, int c_inc = 1);
  FloatGrid(const FloatGrid& md);
  inline FloatGrid() : Region2() { fData = NULL; }  
  inline FloatGrid(const Region2& r) : Region2(r) { fData = NULL;  ReAlloc(r); }
  
  inline int Size() { return size(); }
  void SetValue(  int ir, int ic, float val );

  void Set( float val ) {
    for( int i=0; i<nelem(); i++ ) fData[i] = val; 
  }
  inline int NElements() { return nelem(); }

  inline void SetFields(int rows, int cols, int r_inc = 1, int c_inc = 1) { 
    setupper(rows-1,cols-1); setlower(0,0); setincrement(r_inc,c_inc); 
  }

  inline void SetFields( Region2& r, int r_inc = 1, int c_inc = 1) { 
    setregion(r); setincrement(r_inc,c_inc); 
  }
  
  void CopyDataTo( float* data, const Region2& r);
  void CopyDataFrom( float* data, const Region2& r);
  inline FloatGrid& operator= ( FloatGrid& fg ) { CopyDataFrom(fg.Data(),fg); return *this; }
 
  inline int Index ( const Point2& p ) { return bindex( p(0), p(1) ); }

   inline float& operator [] ( int index ) { 
#ifdef DEBUG
      if( index >= nelem() ) { gPrintErr("Illegal Index"); return fGarbage; }
#endif
      return fData[ index ];
  }

    inline float& operator [] ( const Point2& p ) { 
    int index = Index(p);
#ifdef DEBUG
      if( index >= nelem() ) { gPrintErr("Illegal Index"); return fGarbage; }
#endif
      return fData[ index ];
  }
  
    inline float& operator () ( int i0, int i1 ) { 
    int index = bindex(i0,i1);
#ifdef DEBUG
      if( index >= nelem() ) { gPrintErr("Illegal Index"); return fGarbage; }
#endif
      return fData[ index ];
  }
  inline float operator () ( int i0, int i1 ) const { 
    int index = bindex(i0,i1);
#ifdef DEBUG
      if( index >= nelem() ) { gPrintErr("Illegal Index"); return fGarbage; }
#endif
      return fData[ index ];
  }
  
  inline void Alloc() {
    if(fData) delete[] fData;
    fData = new float[ nelem() ];
  }
  
  void ReAlloc( int r0, int c0, int r1, int c1, int r_inc=-1, int c_inc=-1 );
  void ReAlloc( const Region2& r  );

  inline float* Data() const { return fData; }
  
  
};


#endif

