//----------------------------------------------------------------------------------------
//	MemoryMgr.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __MemoryMgr__
#define __MemoryMgr__

#include "floatVec.h"
#include "BitString.h"
#include "SList.h"

// #define MM_ALLOW_GROWTH

const float kMinAllocation = 0.5;

#ifdef MM_ALLOW_GROWTH 
const float kAllowedOverFlow = 1.5;
#else
const float kAllowedOverFlow = 1.0;
#endif

typedef float** FloatHandle;
 
/*
*************************************************************************
*									*
* MemObject          					                *
*									*
*************************************************************************
*/

class MemObject : public TOrderedObject {
protected:
  byte fMemInfo[4];
  int fMemoryIndex;
  static int fCount;
public:
  MemObject() : TOrderedObject(fCount++) {;}
  enum EMemInfo { kPermanent };
  virtual void Initialize() = 0;
  static int kPermanentMemory;
  inline byte GetMemInfo(EMemInfo index) { return fMemInfo[index]; }
  int MemoryIndex(){ return fMemoryIndex; }
};

/*
*************************************************************************
*									*
* FloatStore          					                *
*									*
*************************************************************************
*/

enum  ESizeClass { kM_TooSmall, kM_OK, kM_Grow, kM_TooLarge };
 
class FloatStore: public floatVec, public TOrderedObject {
  BitString fFlags;
  TObjectList fMemObjList;
  MemObject* fCurrentOwner;

public:

  static EInfoIndex kPermanent;

  FloatStore() : fFlags() { fCurrentOwner = NULL; }
  FloatStore(int len) : floatVec(len), fFlags() { fCurrentOwner = NULL; }
  ~FloatStore() { fCurrentOwner = NULL; }

  int CheckAvail( int index );
  int CheckFlags();
	inline void SetCurrentOwner(MemObject* m) { fCurrentOwner = m; }
	inline int  CheckCurrentOwner(MemObject* m) { return (fCurrentOwner == m); }

  int CheckSlot( MemObject* mobj, int index );
  ESizeClass CheckSize( int len );

  virtual void Dump(FILE* oFile=NULL) const { TextDump(oFile); }

  FloatStore& GrabVector( int len, MemObject& mobj );
  void Finalize();
}; 

/*
*************************************************************************
*									*
* MemoryManager          					        *
*									*
*************************************************************************
*/

class MemoryManager : public TOrderedObjectDLList  {

  public:

  MemoryManager (): TOrderedObjectDLList() {}

  FloatStore& GetVector( int size, MemObject& recipient, MemObject* donor = NULL  );
  void Finalize();

};      					


#endif
