#if __GNUG__ >= 2
#  pragma implementation
#endif

#include "MultiGrid.h"
#include "MML_Model.h"
#include "MML_Variable.h"
#include "MsgBuff.h"


//---- MultiGrid ---------------------------------------------------------

TLayer* MultiGrid::addCellLayer( int index, int rows, int cols ) {
	TLayer* layer = new TLayer(this,index,rows,cols);
	TLayer::CoordType ct = TLayer::kLower;
	float f0 = Model::I0().UTM((int)ct,0);
	float f1 = Model::I0().UTM((int)ct,1);
	layer->setCoords( ct, f0, f1 );
	ct = TLayer::kUpper;
	f0 = Model::I0().UTM((int)ct,0);
	f1 = Model::I0().UTM((int)ct,1);
	layer->setCoords( ct, f0, f1 );
	_cellLayers.elem(index) = (Pix)layer;
	TCell::setMultiGrid(this);
	return layer;
}

void MultiGrid::addCellLayers( int nLayers, TPartition2* partition, int maxGhost ) {
	int rows =  partition->rows();
	int cols =  partition->cols(); 
	TLayer::CoordType ctL = TLayer::kLower;
	float fL0 = Model::I0().UTM((int)ctL,0);
	float fL1 = Model::I0().UTM((int)ctL,1);
	TLayer::CoordType ctU = TLayer::kUpper;
	float fU0 = Model::I0().UTM((int)ctU,0);
	float fU1 = Model::I0().UTM((int)ctU,1);
	Region2* r = partition->region(gIProc);
	for( int index=0; index<nLayers; index++ ) {
		TLayer* layer = new TLayer(this,index,rows,cols);
		layer->setCoords( ctL, fL0, fL1 );
		layer->setCoords( ctU, fU0, fU1 );
		_cellLayers.elem(index) = (Pix)layer;
		layer->setPartition(partition);
		layer->SetObjInfo( TLayer::kType, kVolume );
		layer->addCells( maxGhost );
	}
	TCell::setMultiGrid(this);
	TLayer *cell_layer, *cell_layer_up = NULL;
	for( int cell_layer_index = 0;  cell_layer_index < nLayers; cell_layer_index++ ) {
		if( (cell_layer = (TLayer*) _cellLayers[cell_layer_index]) != NULL ) {
			if( cell_layer_up != NULL ) { 
				for( unsigned int ir = r->lower(0); ir<= r->upper(0); ir++ ) {
				  for( unsigned int ic = r->lower(1); ic<= r->upper(1); ic++ ) {
					TCell* up_cell = cell_layer_up->getCell(ir,ic); 
					TCell* down_cell = cell_layer->getCell(ir,ic); 
					if( ( up_cell != NULL ) && ( down_cell != NULL ) ) {
					  down_cell->setParent(up_cell);
					  up_cell->addChild(down_cell);
					}
				  }
				}
			} 
			cell_layer_up = cell_layer;
		}
	}

}


TLayer* MultiGrid::defaultLayer( int& layer_index ) {
	TLayer *cell_layer, *rv = NULL; layer_index = -1;
	for( int cell_layer_index = 0;  cell_layer_index < _cellLayers.length(); cell_layer_index++ ) {
		if( (cell_layer = (TLayer*) _cellLayers[cell_layer_index]) != NULL ) {
			if( rv == NULL ) { rv = cell_layer; layer_index = cell_layer_index; } 
			if( cell_layer->partition() != NULL ) { rv = cell_layer;  layer_index = cell_layer_index; break; } 
		}
	}
	return rv;
}

/*
float MultiGrid::ParameterValue( TParmRec* pr, TCell* c ) { 
	return pr->Value(c);
	static int dim[3] = { -1, -1, -1 };
	float row = c->row();
	float col = c->col();
	float li = c->GetObjInfo( TCell::kLayerIndex );
	if( dim[0] < 0 ) {
		TLayer* l = (TLayer*)_cellLayers[li]; 
		dim[0] = l->Dim(0);
		dim[1] = l->Dim(1);
		dim[2] = _cellLayers.length();
	}	
	float f0 = (dim[0]==1) ? 0.0 : row/(dim[0]-1);
	float f1 = (dim[1]==1) ? 0.0 : col/(dim[1]-1);
	float f2 = (dim[2]==1) ? 0.0 : li/(dim[2]-1);
	return pr->Value(f0,f1,f2);
}
*/


int MultiGrid::defaultLayerIndex() {
	TLayer *cell_layer; int layer_index = -1;
	for( int cell_layer_index = 0;  cell_layer_index < _cellLayers.length(); cell_layer_index++ ) {
		if( (cell_layer = (TLayer*) _cellLayers[cell_layer_index]) != NULL ) {
			if( layer_index < 0 ) { layer_index = cell_layer_index; } 
			if( cell_layer->partition() != NULL ) { layer_index = cell_layer_index; break; } 
		}
	}
	return layer_index;
}

ActivationLayer* MultiGrid::DefaultActivationLayer() {
	ActivationLayer* rv = NULL;
	for( int i=0; i< _activationLayers.length(); i++ ) {
		if( ( rv = (ActivationLayer*) _activationLayers.elem(i) ) != NULL ) break;
	}
	return rv;
}

int MultiGrid::DefaultActivationIndex() {
	int rv = -1;
	for( int i=0; i< _activationLayers.length(); i++ ) {
		if(  _activationLayers.elem(i) != NULL ) { rv = i; break; }
	}
	return rv;
}
		     

ActivationLayer* MultiGrid::addActivationLayer( int activation_index, int maxGhost, int& isNew ) {
	ActivationLayer* layer = (ActivationLayer*) _activationLayers.elem(activation_index);
	isNew = 1;
	if( layer == 0 ) {
		layer = new ActivationLayer(this,activation_index,maxGhost);
		for( int i=0; i < _cellLayers.length(); i++ ) {
			TLayer* l = (TLayer*)_cellLayers[i];
			if( l ) { l->addActivationLayer(activation_index); }
		}
		_activationLayers.elem(activation_index) = (Pix)layer;
	} else { isNew = 0; return layer; }
	return layer;
}

int MultiGrid::getOwner(  TLayer* l, TCell* c ) {  
	int cell_layer_index; 
	return GetPartition(cell_layer_index)->getowner( l, c ); 
}

ByteGrid* MultiGrid::RegionMap(int layer_index) { 
	return getCellLayer(layer_index)->partition()->cellDistribution(); 
}

TPartition2* MultiGrid::GetPartition(int& cell_layer_index) {
	TPartition2* p = NULL;
	TLayer* cell_layer = NULL;
	int activated_index = -1;
	for( cell_layer_index = 0;  cell_layer_index < _cellLayers.length(); cell_layer_index++ ) {
		if( (cell_layer = (TLayer*) _cellLayers[cell_layer_index]) != NULL ) {
			if( (p = cell_layer->partition()) != NULL ) break;
		}
	}
	if( p == NULL ) { gPrintErr(" No partitioned cell level found in MultiGrid::defineActivationLayer" ); }
	return p;
}
/*
ActivationLayer* MultiGrid::defineActivationLayer( int activation_layer_index, ByteGrid* activationData, int threshold ) {
	int local_debug = 0;
	int cell_layer_index;
	TPartition2* p = GetPartition(cell_layer_index); 
	if( p == NULL ) return NULL;
	TLayer* cell_layer = (TLayer*) _cellLayers[cell_layer_index];
	ByteGrid* cellData = p->cellDistribution();
	ActivationLayer* act_layer = addActivationLayer( activation_layer_index, p->maxGhost() );
	if( activationData == NULL ) activationData = cellData;
	int ig = 0, cnt=0;
	for( TCell* c = cell_layer->firstCell(); c; cell_layer->nextCell(c) ) {
		if( (ig = c->GetObjInfo( TCell::kGhostIndex )) == 0	 ) {
			int row = cell_layer->getCellLocCoord(TLayer::kRows, c);
			int col = cell_layer->getCellLocCoord(TLayer::kCols, c);
			long key = activationData->IntValue( row, col );
			if( (key > 0) && (key < threshold) ) {
				if( local_debug ) { sprintf(gMsgStr,"AL%d add (%d,%d): key = %d, cell_layer_index = %d",activation_layer_index,row,col,key,cell_layer_index); gPrintLog(); }
				if( key == 1 ) {
					c->activate( act_layer );
				} else if( key < threshold/2 ) {
					c->activateParent( act_layer, key - 1  );
				} else {
					c->activateChildren( act_layer, threshold - key  );
				}
			}
		}
	}
	for( TCell* c = cell_layer->firstCell(); c; cell_layer->nextCell(c) ) {
		if( (ig = c->GetObjInfo( TCell::kGhostIndex )) > 0	 ) {
			int row = cell_layer->getCellLocCoord(TLayer::kRows, c);
			int col = cell_layer->getCellLocCoord(TLayer::kCols, c);
			long key = activationData->IntValue( row, col );
			if( (key > 0) && (key < threshold) ) {
				if( local_debug ) { sprintf(gMsgStr,"AL%d add ghost %d (%d,%d): key = %d, cell_layer_index = %d",activation_layer_index,ig,row,col,key,cell_layer_index); gPrintLog(); }
				if( key == 1 ) {
					c->activate( act_layer );
				} else if( key < threshold/2 ) {
					c->activateParent( act_layer, key - 1  );
				} else {
					c->activateChildren( act_layer, threshold - key  );
				}
			}
		}
	}
	return act_layer;
}
*/

ActivationLayer* MultiGrid::defineActivationLayer( int surface_layer_index, int activation_layer_index, ByteGrid* activationData, int threshold  ) {
	int local_debug = 0;
	int cell_layer_index, newAL;
	TLayer* cell_layer = NULL;
	TPartition2* p = GetPartition(cell_layer_index);
	ActivationLayer* act_layer = addActivationLayer( activation_layer_index, p->maxGhost(), newAL );
	if( newAL == 0 ) return act_layer;
	sprintf(gMsgStr,"Defining Activation Layer %d  :",activation_layer_index); gPrintScreen();
	for( cell_layer_index = 0;  cell_layer_index < _cellLayers.length(); cell_layer_index++ ) {
	  if( ( surface_layer_index < 0 ) || ( surface_layer_index == cell_layer_index ) ) {
		if( (cell_layer = (TLayer*) _cellLayers[cell_layer_index]) != NULL ) {
			if( (p = cell_layer->partition()) == NULL ) { gFatal(" No partition for cell layer" ); }
			TLayer* cell_layer = (TLayer*) _cellLayers[cell_layer_index];
			ByteGrid* cellData = p->cellDistribution();
			if( activationData == NULL ) activationData = cellData;
			int ig = 0, cnt=0;
			for( TCell* c = cell_layer->firstCell(); c; cell_layer->nextCell(c) ) {
				int row = cell_layer->getCellLocCoord(TLayer::kRows, c);
				int col = cell_layer->getCellLocCoord(TLayer::kCols, c);
				long key = (activationData) ? activationData->IntValue( row, col ) : 1;
				if( surface_layer_index == -2 ) {
				  if( key == cell_layer_index ) {
					c->activate( act_layer );
				  }
				} else  if( (key > 0) /* && (key < threshold) */ ) {
					if( local_debug ) { 
					  sprintf(gMsgStr,"AL%d add (%d,%d): key = %d, cell_layer_index = %d/%d", 
							  activation_layer_index,row,col,key,cell_layer_index,_cellLayers.length()); gPrintLog(); 
					}
					c->activate( act_layer );
//					if( key == 1 ) {
//						c->activate( act_layer );
//					} else if( key < threshold/2 ) {
//						c->activateParent( act_layer, key - 1  );
//					} else {
//						c->activateChildren( act_layer, threshold - key  );
//					}
				}
			}
		}
	  }
	}
	act_layer->finalizeCells();
	if( gDebug ) { sprintf(gMsgStr,"Activation Layer %d : %d total active cells",activation_layer_index, act_layer->nActiveCells() ); gPrintScreen(); }
	return act_layer;
}


int MultiGrid::createAggregatedCellLayer( int originLevel, ByteGrid& aggregationData, int agg_rows, int agg_cols ) {
		TLayer* origin_layer = (TLayer*) _cellLayers[originLevel];
		TLayer* destination_layer = (TLayer*) _cellLayers.elem(originLevel+1);
		if( destination_layer == NULL ) { destination_layer = addCellLayer(originLevel+1,agg_rows,agg_cols); }
		destination_layer->addChildLinkLayer();
		for( TCell* c = origin_layer->firstCell(); c; origin_layer->nextCell(c) ) {
			int row = origin_layer->getCellLocCoord(TLayer::kRows, c);
			int col = origin_layer->getCellLocCoord(TLayer::kCols, c);
			long key = aggregationData.IntValue( row, col );
			TCell* agg_c = destination_layer->getCell(key);
			if( agg_c == NULL ) {
				int aggpt_row = destination_layer->getLocCoordFromKey( TLayer::kRows, (int32) key );
				int aggpt_col = destination_layer->getLocCoordFromKey( TLayer::kCols, (int32) key );
				agg_c = destination_layer->addCell(aggpt_row,aggpt_col);
			}
			c->setParent(agg_c);
			agg_c->addChild(c);
		}
		return 0;
}

int MultiGrid::mapLayer( int originActivationLevel, float* origonData, int destinationActivationLevel, float* destinationData, Bool doAverage, float nullValue ) {
		ActivationLayer* origin_layer = activationLayer(originActivationLevel);
		ActivationLayer* destination_level = activationLayer(destinationActivationLevel);
		if( (destination_level==NULL) || (origin_layer==NULL) ) return 0;
		for( int32 icell=0; icell<destination_level->nCells(); icell++ ) {
				TCell* c = destination_level->cell( icell );
				int32 mindex = c->memoryIndex( destinationActivationLevel );
				destinationData[mindex] = origin_layer->mapValue( c, originActivationLevel, origonData, doAverage, nullValue );
		}
		return 1;
}

inline int quantize(int index, int quantum) {
  if(quantum==0) return index;
  int quot = index/quantum; int rem = index % quantum;
  if (rem > quantum/2) return (quot + 1)*quantum;
  else return quot*quantum;
}

int TPartition2::setup( int nprocs, ByteGrid& cellWeights, int threshold, int maxGhost, int quantum ) {
	int local_debug = 0;
	if( _regions != NULL ) { return 0; }
	_cellDistribution = &cellWeights;
  _rows = cellWeights.extents(0);
  _cols = cellWeights.extents(1);
  _nProcs = nprocs;
  if( maxGhost < 0 ) { _maxGhost = (nprocs>1) ? 1 : 0; }
  else { _maxGhost = maxGhost; }
  static int nproc[2] = {0,0};
#ifdef USE_MPI
  MPI_Dims_create(nprocs, 2, nproc);
#else
	if( nprocs > 1 ) { gPrintErr( " Multi-processing requires MPI. " ); _nProcs = 1; }
#endif
  _regions = new Region2[_nProcs];
  unsigned long SArea=0, SAreaR=0, SAreaC=0;
  int ir0=0, ip=0, ipg=0, irq, icq, ir, ic; 
  long mVal, valMax = 0;
  if(local_debug) {
    sprintf(gMsgStr,"\n---------Distribution DATA(r:%d,c:%d)---------------\n",_rows,_cols); gPrintLog();
    gMsgStr[_cols] = '\0';
    for(ir=0; ir<_rows; ir++) {
      for(ic=0; ic<_cols; ic++) {
		mVal = cellWeights.IntValue(ir,ic);
		if( (mVal > 0) && (mVal < 10) ) gMsgStr[ic] = ('0' + mVal);
		else if( mVal >= 10 ) gMsgStr[ic] = '*';
		else if( mVal >= 20 ) gMsgStr[ic] = '#';
		else if( mVal < 0 ) gMsgStr[ic] = '!';
		else gMsgStr[ic] = '_';
      } 
      gPrintLog();
    }
  }
	if( _nProcs == 1 ) {
    _regions[0].setlower(0,0); 
    _regions[0].setupper(_rows-1,_cols-1);
		for(ir=0; ir<_rows; ir++) {
			for(ic=0; ic<_cols; ic++) {
				mVal = cellWeights.IntValue(ir,ic);
				if( mVal > valMax ) {
				  valMax = mVal;
				  if(local_debug) { 
					int index = cellWeights.bindex(ir,ic);
					sprintf(gMsgStr,"Setting maxLayers: %d %d (index=%d)-> %d",ir,ic,index,valMax); gPrintLog(); 
				  }
				}
			} 
		}
    return valMax;
  }
  for(ir=0; ir<_rows; ir++) {
    for(ic=0; ic<_cols; ic++) {
			mVal = cellWeights.IntValue(ir,ic);
      if( mVal > threshold ) { SArea += mVal; }
      if( mVal > valMax ) valMax = mVal;
    } 
  }
    
  for(ir=0; ir<_rows; ir++) {
    if( ip == nproc[0]-1 ) {
      if(local_debug) { sprintf(gMsgStr,"\nDistribute: Setting final row bifurcation at %d",_rows-1); gPrintLog(); }
      for(ipg = ip*nproc[1]; ipg < (ip+1)*nproc[1]; ipg++) {
				_regions[ipg].setlower(ir0,0); _regions[ipg].setupper(_rows-1,_cols-1); 
				if(local_debug) { sprintf(gMsgStr,"Partition%d: (%d/%d)->(%d/%d): q%d ",ipg,ir0,0,_rows-1,_cols-1,quantum); gPrintLog(); }
      }
      break;
    }
    for(ic=0; ic<_cols; ic++) {
      mVal = cellWeights.IntValue(ir,ic);
      if( mVal > threshold ) { SAreaR += mVal; }
    }
    if( (SAreaR >=  SArea/nproc[0]) || (ir == _rows-1) ) {
			 irq = quantize(ir,quantum);
			 if(local_debug) { sprintf(gMsgStr,"\nDistribute: Setting row bifurcation (%d/%d) at %d(%d)/%d:", SAreaR,SArea,irq,ir,_rows); gPrintLog(); }
			 for(ipg = ip*nproc[1]; ipg < (ip+1)*nproc[1]; ipg++) { 
					_regions[ipg].setlower(ir0,0); _regions[ipg].setupper(irq-1,_cols-1); 
					if(local_debug) { sprintf(gMsgStr,"Partition%d: (%d/%d)->(%d/%d): q%d ",ipg,ir0,0,irq-1,_cols-1,quantum); gPrintLog(); }
			 }
			 ir0 = irq; ip++; SAreaR = 0;
    }
  }
  
  for(ip=0; ip<nproc[0]; ip++) {
    int ic0=0, ip1=0;    
    ipg = ip*nproc[1]; SArea = 0;
    int lr0 = _regions[ip].lower(0);
    int lr1 = _regions[ip].upper(0);
    int lrows = lr1 - lr0 + 1;
    int lcols = _regions[ipg].extents(1);
    for(ir=lr0; ir<=lr1; ir++) {
      for(ic=0; ic<lcols; ic++) {
				mVal = cellWeights.IntValue(ir,ic);
				if( mVal > threshold ) { SArea += mVal; }
      } 
    }
    int lb = _regions[ipg].lower(0);
    int ub = _regions[ipg].upper(0);
    for(ic=0; ic<_cols; ic++) {
      if( ip1 == nproc[1]-1 ) {
				if(local_debug) { 
					sprintf(gMsgStr,"\nDistribute: Setting final col bifurcation at %d: ",_cols-1); 
					gPrintLog(); 
				}
				_regions[ipg+ip1].setlower(lb,ic0); 
				_regions[ipg+ip1].setupper(ub,_cols-1);
				if(local_debug) { sprintf(gMsgStr,"Partition%d (%d/%d)->(%d/%d) ",ipg+ip1,lb,ic0,ub,_cols-1); gPrintLog(); }
				break;
			}
			for(ir=lb; ir<ub; ir++) {
				mVal = cellWeights.IntValue(ir,ic);
				if( mVal > threshold ) { SAreaC += mVal; }
			} 
			if( SAreaC >=  SArea/nproc[1]) {
				icq = quantize(ic,quantum);
				if(local_debug) { sprintf(gMsgStr,"\nDistribute: Setting column bifurcation (%d+%d): (%d/%d) at %d(%d)/%d: ",
							 ipg,ip1,SAreaC,SArea,icq,ic,_cols); gPrintLog(); }
				_regions[ipg+ip1].setlower(lb,ic0); 
				_regions[ipg+ip1].setupper(ub,icq-1);
				if(local_debug) { 
					sprintf(gMsgStr,"Partition%d: (%d/%d)->(%d/%d): q%d ",ipg+ip1,lb,ic0,ub,icq-1,quantum); 
					gPrintLog(); 
				}
				ic0 = icq; ip1++; SAreaC = 0;
      }
    }
  }	
  for( ip=0; ip<gNProc; ip++ ) {
    sprintf(gMsgStr,"\nPartition%d(r,c): (%d,%d)->(%d,%d)", ip,
	    _regions[ip].lower(0),_regions[ip].lower(1),
	    _regions[ip].upper(0),_regions[ip].upper(1)); 
    gPrintLog(); 
  }
  return valMax;
}

void TPartition2::setup( int nprocs, int rows, int cols, int threshold, int maxGhost, int quantum ) {
	int local_debug = 0;
	if( _regions != NULL ) { return; }
	_cellDistribution = new ByteGrid(0, 0, rows-1, cols-1, 1);
	_cellDistribution->Set( 1 );
  _rows = rows;
  _cols = cols;
  _nProcs = nprocs;
  if( maxGhost < 0 ) { _maxGhost = (nprocs>1) ? 1 : 0; }
  else { _maxGhost = maxGhost; }
  static int nproc[2] = {0,0};
#ifdef USE_MPI
  MPI_Dims_create(nprocs, 2, nproc);
#else
	if( nprocs > 1 ) { gPrintErr( " Multi-processing requires MPI. " ); _nProcs = 1; }
#endif
  _regions = new Region2[_nProcs];
  if( _nProcs == 1 ) {
    _regions[0].setlower(0,0); 
    _regions[0].setupper(_rows-1,_cols-1);
    return;
  }
  unsigned long SArea=0, SAreaR=0, SAreaC=0;
  long mVal;
  int ir0=0, ip=0, ipg=0, irq, icq, ir, ic; 
  SArea = rows * cols;
    
  for(ir=0; ir<_rows; ir++) {
    if( ip == nproc[0]-1 ) {
      if(local_debug) { sprintf(gMsgStr,"\nDistribute: Setting final row bifurcation at %d",_rows-1); gPrintLog(); }
      for(ipg = ip*nproc[1]; ipg < (ip+1)*nproc[1]; ipg++) {
				_regions[ipg].setlower(ir0,0); _regions[ipg].setupper(_rows-1,_cols-1); 
				if(local_debug) { sprintf(gMsgStr,"Partition%d: (%d/%d)->(%d/%d): q%d ",ipg,ir0,0,_rows-1,_cols-1,quantum); gPrintLog(); }
      }
      break;
    }
    for(ic=0; ic<_cols; ic++) { SAreaR += mVal; }
    
    if( (SAreaR >=  SArea/nproc[0]) || (ir == _rows-1) ) {
			 irq = quantize(ir,quantum);
			 if(local_debug) { sprintf(gMsgStr,"\nDistribute: Setting row bifurcation (%d/%d) at %d(%d)/%d:", SAreaR,SArea,irq,ir,_rows); gPrintLog(); }
			 for(ipg = ip*nproc[1]; ipg < (ip+1)*nproc[1]; ipg++) { 
					_regions[ipg].setlower(ir0,0); _regions[ipg].setupper(irq-1,_cols-1); 
					if(local_debug) { sprintf(gMsgStr,"Partition%d: (%d/%d)->(%d/%d): q%d ",ipg,ir0,0,irq-1,_cols-1,quantum); gPrintLog(); }
			 }
			 ir0 = irq; ip++; SAreaR = 0;
    }
  }
  
  for(ip=0; ip<nproc[0]; ip++) {
    int ic0=0, ip1=0;    
    ipg = ip*nproc[1]; SArea = 0;
    int lr0 = _regions[ip].lower(0);
    int lr1 = _regions[ip].upper(0);
    int lrows = lr1 - lr0 + 1;
    int lcols = _regions[ipg].extents(1);
    for(ir=lr0; ir<=lr1; ir++) {
      for(ic=0; ic<lcols; ic++) { SArea += mVal;  } 
    }
    int lb = _regions[ipg].lower(0);
    int ub = _regions[ipg].upper(0);
    for(ic=0; ic<_cols; ic++) {
      if( ip1 == nproc[1]-1 ) {
				if(local_debug) { 
					sprintf(gMsgStr,"\nDistribute: Setting final col bifurcation at %d: ",_cols-1); 
					gPrintLog(); 
				}
				_regions[ipg+ip1].setlower(lb,ic0); 
				_regions[ipg+ip1].setupper(ub,_cols-1);
				if(local_debug) { sprintf(gMsgStr,"Partition%d (%d/%d)->(%d/%d) ",ipg+ip1,lb,ic0,ub,_cols-1); gPrintLog(); }
				break;
			}
			for(ir=lb; ir<ub; ir++) { SAreaC += mVal; } 
			
			if( SAreaC >=  SArea/nproc[1]) {
				icq = quantize(ic,quantum);
				if(local_debug) { sprintf(gMsgStr,"\nDistribute: Setting column bifurcation (%d+%d): (%d/%d) at %d(%d)/%d: ",
							 ipg,ip1,SAreaC,SArea,icq,ic,_cols); gPrintLog(); }
				_regions[ipg+ip1].setlower(lb,ic0); 
				_regions[ipg+ip1].setupper(ub,icq-1);
				if(local_debug) { 
					sprintf(gMsgStr,"Partition%d: (%d/%d)->(%d/%d): q%d ",ipg+ip1,lb,ic0,ub,icq-1,quantum); 
					gPrintLog(); 
				}
				ic0 = icq; ip1++; SAreaC = 0;
      }
    }
  }	
  for( ip=0; ip<gNProc; ip++ ) {
    sprintf(gMsgStr,"\nPartition%d(r,c): (%d,%d)->(%d,%d)", ip,
	    _regions[ip].lower(0),_regions[ip].lower(1),
	    _regions[ip].upper(0),_regions[ip].upper(1)); 
    gPrintLog(); 
  }
}



void TPartition2::setup_uniform( int rows, int cols, int mrows, int mcols, ByteGrid* depthMap, int maxGhost ) {
  if( _regions != NULL ) { return; }
  sprintf(gMsgStr,"\nCreating Partition%d(r,c): decompose (%d,%d) over (%d,%d)", rows, cols, mrows, mcols);  gPrintLog(); 
  _rows = rows;
  _cols = cols;
  _nProcs = mrows * mcols;
  _cellDistribution = depthMap;
  if( maxGhost < 0 ) { _maxGhost = (_nProcs>1) ? 1 : 0; }
  else { _maxGhost = maxGhost; }
  _regions = new Region2[_nProcs];
  if( _nProcs == 1 ) {
    _regions[0].setlower(0,0); 
    _regions[0].setupper(_rows-1,_cols-1);
    return;
  }
  
  int ir0, ic0, ipg = 0;
  int pc = cols/mcols, pr=rows/mrows;
  for( int ir=0; ir<mrows; ir++ ) {
	for( int ic=0; ic<mcols; ic++ ) {
	  ipg = ic + ir*mcols;
	  ir0 = ir*pr;
	  ic0 = ic*pc;
	  _regions[ipg].setlower(ir0,ic0); 
	  _regions[ipg].setupper(ir0+pr-1,ic0+pc-1); 
	}
  }
  
  for( int ip=0; ip<gNProc; ip++ ) {
    sprintf(gMsgStr,"\nPartition%d(r,c): (%d,%d)->(%d,%d)", ip,
	    _regions[ip].lower(0),_regions[ip].lower(1),
	    _regions[ip].upper(0),_regions[ip].upper(1)); 
    gPrintLog(); 
  }
  
}





