//-*-Mode: C++;-*-
#ifndef _MultiGrid_h_
#define _MultiGrid_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

#include "ActivationLayer.h"

typedef class TParmRec TParmRec;

//---- MultiGrid -----------------------------------------------------------

class MultiGrid {
	PixXPlex _cellLayers;
	PixXPlex _activationLayers;
	int _nCells;
	
public:

    MultiGrid() { _nCells = 0; }
    ~MultiGrid() { _nCells = 0; }
    
    TLayer* addCellLayer( int index, int rows, int cols );
    void addCellLayers( int nLayers, TPartition2* partition, int maxGhost ); 
		inline TLayer* getCellLayer( int& layer_index ) { 
			if( layer_index > 255 ) { gFatal("Illegal layer index."); }
			return (layer_index<0) ? defaultLayer(layer_index) : (TLayer*) _cellLayers.elem( layer_index ); 
		}
		inline int nCellLayers() { return _cellLayers.length(); }
		
		inline TLayer* getCellLayer() { int layer_index = -1; return defaultLayer(layer_index); }
		int getOwner(  TLayer* l, TCell* c );
		inline TCell* translateNEWS( TCell* cell, int dr, int dc, int dv=0 ) { 
			int cell_layer =  cell->GetObjInfo( TCell::kLayerIndex ) + dv;
			if( ( cell_layer < 0 ) || ( cell_layer > _cellLayers.high() ) ) return (TCell*)NULL;
			return ( (TLayer*)_cellLayers[cell_layer] )->translateNEWS(cell, dr, dc); 
		}
		inline TCell* getCell( unsigned int ir, unsigned int ic, int layer_index = -1 ) { 
		  TLayer* l = defaultLayer( layer_index );
		  return l->getCell( ir, ic );
		}
		TLayer* defaultLayer( int& layer_index );
		int defaultLayerIndex();
    ActivationLayer* addActivationLayer(int activation_index, int maxGhost, int& isNew );
    ActivationLayer* defineActivationLayer( int surface_layer_index, int activation_layer_index, ByteGrid* activationData=NULL, int threshold=256 );
    TPartition2* GetPartition(int& cell_layer_index);
		inline ActivationLayer* activationLayer(int activation_index) { return (ActivationLayer*) _activationLayers.elem(activation_index); }
		ActivationLayer* DefaultActivationLayer() ;
		int DefaultActivationIndex() ;
    int createAggregatedCellLayer( int origonLevel, ByteGrid& aggregationData, int agg_rows, int agg_cols  );
    int mapLayer( int originActivationLevel, float* origonData, int destinationActivationLevel, float* destiontionData, Bool doAverage, float nullValue = 0.0  );
		ByteGrid* RegionMap(int layer_index = -1);
		inline void setNCells( int nCells ) { _nCells = nCells; }
		inline int getNCells() { return _nCells; }

};

//---- TPartition -----------------------------------------------------------

class TPartition2 {
	int _rows;
	int _cols;
	int _nProcs;
	int _maxGhost;
	Region2*  _regions;
	ByteGrid* _cellDistribution;
public:
	TPartition2() { _regions = NULL;  _cellDistribution = NULL; _rows = _cols = 0; _nProcs = 1; _maxGhost = 0; }
	int setup( int nprocs, ByteGrid& cellWeights,  int threshold=0, int maxGhost=0, int quantum=0 );
	void setup( int nprocs, int rows, int cols, int threshold=0, int maxGhost=0, int quantum=0 );
	void setup_uniform( int rows, int cols, int mrows, int mcols, ByteGrid* depthMap=NULL, int maxGhost=0);
	inline void setCellDistribution(ByteGrid* cellDistribution) { _cellDistribution = cellDistribution; }
	inline int rows() { return _rows; }
	inline int cols() { return _cols; }
	inline ByteGrid* cellDistribution() { return _cellDistribution; }	
	int maxGhost() { return _maxGhost; }
	
	inline int ghostIndex( int iproc, int ir, int ic ) const { 
		int ighost = _regions[iproc].ghostLayer ( ir, ic );
		return ( ighost <= _maxGhost ) ? ighost : -1;
	}
	
	inline int nProcs() { return _nProcs; }	
	inline int getowner( TLayer* l, TCell* c ) const { 
		for(int i=0; i<_nProcs; i++) { 
			if( _regions[i].inside( l->getCellLocPoint(c) ) ) return i;
		}
		return -1;
	}
	
	inline int getowner( int ir, int ic ) const { 
		for(int i=0; i<_nProcs; i++) { 
			if( _regions[i].inside( ir, ic ) ) return i;
		}
		return -1;
	}
	
	inline Region2* region( int iproc ) {
#ifdef DEBUG
		if(  _regions == NULL ) { gPrintErr( " Attempt to access Partition prior to setup. " ); return NULL; }
#endif
		return _regions + iproc; 
	}		
};

#endif
