//----------------------------------------------------------------------------------------;
//	Network.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#ifndef __Network__
#define __Network__

enum ECoordType { kLocal, kGlobal, kDistributed };

#ifdef USE_MPI
#include "mpi.h"
#endif

#include "Environ.h"
#include "Array.h"
#include "FloorPlan2.h"
#include "ByteGrid.h"
  
#define ALLPROCS 0
#define MAX_NODES 512
  
class Net {
  
 private:
  
  static FloorPlan* fFP;					 
  static ByteGrid* fStudyArea;
  
  static int fProcDims[2];
  static byte fNetInfo[8];

  static void RecursiveBisectionDistribution ( );
  static void GenerateFloorPlan();
  
 public:

  enum EInfo { kMaxScale };
  
  static void Startup(); 
  static void Finalize(); 

  static inline void SetGrid( ByteGrid* studyArea ) {  fStudyArea = studyArea; }
  static int SetDims( int d0, int d1 );
  static inline int GetDims(int index) { return fProcDims[index]; }
  static int SetMaxScale(int scale);
  static inline byte GetInfo( EInfo index) { return fNetInfo[index]; }
  
  static int GetOwner( const Point2& pt ) { return fFP->getowner(pt); }
  static Region2& LocalRegion( int proc = gIProc );
  static inline ByteGrid& GlobalRegion() { 
    if( fStudyArea == NULL) { gFatal("No StudyArea Specified for FloorPlans"); } 
	return *fStudyArea; }
  static FloorPlan* GetFloorPlan();
#ifdef USE_MPI
  static inline void Sync() { 
		MPI_Comm c;
		Env::GetComm(&c,0);
		MPI_Barrier(c); 
	}
#endif
};

#endif



