//----------------------------------------------------------------------------------------
//	OrderedPoint.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __OrderedPoint__
#define __OrderedPoint__

#include <string.h>
#include "TObjects.h"
#include "Point2.h"

typedef Point2 Point;

/*
*************************************************************************
*									*
*   OrderedPoint								*
*									*
*************************************************************************
*/

class OrderedPoint : public Point, public TOrderedObject {

 public:
                     // Constructors

  inline OrderedPoint( int cols, int rows, int index ) : Point(cols,rows), TOrderedObject(index) {;}
  inline OrderedPoint( int index ) : Point(), TOrderedObject(index) {;}
   inline OrderedPoint( int cols, int rows ) : Point(cols,rows), TOrderedObject() {;}
  inline OrderedPoint() : Point(), TOrderedObject() {;}
 
  inline void Dump(FILE* oFile=NULL) const { 
    if(oFile) { 
      fprintf(oFile,"P%d(%d,%d)(%x %x %x %x)  (%d %d)\n", fIndex, p[0], p[1], 
	      GetObjInfo(kO_Info0),GetObjInfo(kO_Info1),GetObjInfo(kO_Info2),GetObjInfo(kO_Info3),
	      GetObjIndex(kO_Index0),GetObjIndex(kO_Index1));
    } else { 
      sprintf(gMsgStr,"P%d(%d,%d)(%x %x %x %x)  (%d %d)\n", fIndex, p[0], p[1], 
	      GetObjInfo(kO_Info0),GetObjInfo(kO_Info1),GetObjInfo(kO_Info2),GetObjInfo(kO_Info3),
	      GetObjIndex(kO_Index0),GetObjIndex(kO_Index1));
      gPrintLog(); 
    }
  }
  inline int row() const { return p[0]; }
  inline int col() const { return p[1]; }



};

class AggregatePoint : public OrderedPoint {

  OrderedPoint** fLinks;
  unsigned int fNLinks;

public:

  inline AggregatePoint( int cols, int rows, int index ) : OrderedPoint( cols, rows, index ) {fLinks=NULL;}
  inline  AggregatePoint( int index ): OrderedPoint( index ) {fLinks=NULL;}
  inline AggregatePoint( int cols, int rows ) : OrderedPoint( cols, rows ) {fLinks=NULL;}
  inline  AggregatePoint(): OrderedPoint() {fLinks=NULL;}
  
  inline byte  Link ( OrderedPoint* lnode, int lindex ) {
    if( lindex >= fNLinks ) {
      int nsize = sizeof(OrderedPoint*);
      if(fLinks) {
	OrderedPoint** newlinks = (OrderedPoint**) calloc(lindex+4,nsize);
	memcpy(newlinks,fLinks,fNLinks*nsize);
	free(fLinks); fNLinks = lindex+4;
	fLinks = newlinks;
      }
      else fLinks = (OrderedPoint**) calloc(fNLinks=lindex+4,nsize);
    }
    fLinks[lindex] =  lnode;
    return lindex;
  }

  inline int NLinks() { return fNLinks; }

  inline OrderedPoint* link ( byte lindex ) const {
    if( lindex < fNLinks ) { return fLinks[lindex]; }
    else { return (OrderedPoint*) NULL; }
  }

  inline Pix plink ( byte lindex ) const {
    if( lindex < fNLinks ) { return Pix( fLinks[lindex] ); }
    else return 0;
  }
};

#endif
