#include "PointFactory.h"

int PointFactory::fNSets = kPFMaxAgLevel+1;
PointGrid PointFactory::fMaps[kPFMaxAgLevel];
OrderedPointRPlex PointFactory::fPoints;

int PointFactory::GetScaledIndex( const PointRef& pref, int scale, int index ) {
    int icoord = (int)pref(index);
    if(scale==0) return icoord;
    int iscale =  Util::pow2(scale);
    int rcoord = icoord - fMaps[0].lower(index);
    return (rcoord/iscale)*iscale +  fMaps[0].lower(index);
}


OrderedPoint* PointFactory::GetPoint( PointRef& pref, int scale, int agLevel ) {
    if( !pref.OK() ) return NULL;
    int ir  = GetScaledIndex(pref,scale,0);
    int ic  = GetScaledIndex(pref,scale,1);
    if( !fMaps[agLevel].isActive() ) { fMaps[agLevel].Alloc( (Region2&) pref.Region() ); fMaps[agLevel].Set(NULL); }
    OrderedPoint* rpt = fMaps[agLevel].GetPoint(ir,ic);
    if(rpt==NULL) {
      rpt = (agLevel == 0) ? GetNewPointFast( ir, ic, (Region2&) pref.Region() ) : new AggregatePoint(ir,ic);
			pref.SetInfo(kPRI_New,True);
    } 
    else pref.SetInfo(kPRI_New,False);
    return rpt;
}

OrderedPoint* PointFactory::GetPointFast( int ir, int ic, Region2& r ) {
    if( !r.inside(ir,ic) ) return NULL;
    if( !fMaps[0].isActive() ) { fMaps[0].Alloc( r ); fMaps[0].Set(NULL); }
    OrderedPoint* rpt = fMaps[0].GetPoint(ir,ic);
    if(rpt==NULL) { rpt = GetNewPointFast( ir, ic, r ); } 
    return rpt;
}

OrderedPoint* PointFactory::GetExistingPoint( PointRef& pref, int scale, int agLevel ) {
    if( !pref.OK() ) return NULL;
    int ir  = GetScaledIndex(pref,scale,0);
    int ic  = GetScaledIndex(pref,scale,1);
    if( !fMaps[agLevel].isActive() ) { fMaps[agLevel].Alloc( (Region2&) pref.Region() ); fMaps[agLevel].Set(NULL); }
    return fMaps[agLevel].GetPoint(ir,ic);
}

OrderedPoint* PointFactory::GetExistingPointFast( PointRef& pref ) {
    if( !pref.OK() ) return NULL;
    return fMaps[0].GetPoint(pref(0),pref(1));
}

OrderedPoint* PointFactory::GetExistingPointFast( int ir, int ic ) {
    return fMaps[0].GetPoint(ir,ic);
}

OrderedPoint* PointFactory::GetNewPointFast( int ir, int ic, Region2& r ) {
    OrderedPoint* rpt = NewPoint( ir, ic );
		if( !fMaps[0].isActive() ) { fMaps[0].Alloc( r ); fMaps[0].Set(NULL); }
		fMaps[0].SetPoint( rpt, ir, ic );
    return rpt;
}

OrderedPoint* PointFactory::NewPoint( int ir, int ic ) {
    OrderedPoint* pt = new OrderedPoint(ir,ic);
    int index = fPoints.add_high(*pt);
    pt->SetIndex(index);
    return pt;
}

  
