//----------------------------------------------------------------------------------------
//	PointFactory.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __PointFactory__
#define __PointFactory__

#include "PointGrid.h"
#include "PointRef.h"

const int kPFMaxAgLevel = 3;

/*
*************************************************************************
*									*
* PointFactory								*
*									*
*************************************************************************
*/

class PointFactory  {

  static int fNSets;
  static PointGrid fMaps[kPFMaxAgLevel];
  static OrderedPointRPlex fPoints;
  
  static OrderedPoint* NewPoint( int ir, int ic ); 

public:

  static int GetScaledIndex( const PointRef& pref, int scale, int index );
  static OrderedPoint* GetPoint( PointRef& pref, int scale=0, int agLevel=0 );
  static OrderedPoint* GetPointFast( int ir, int ic, Region2& r );
	static OrderedPoint* GetNewPointFast( int ir, int ic, Region2& r  );  
	static OrderedPoint* GetExistingPoint( PointRef& pref, int scale=0, int agLevel=0 );
	static OrderedPoint* GetExistingPointFast( PointRef& pref ); 
	static OrderedPoint* GetExistingPointFast( int ir, int ic );
};

typedef PointFactory PFactory;
 
#endif
