#ifndef __PointGrid__
#define __PointGrid__

#include "Environ.h"
#include <math.h>
#include "Array.h"
#include <PointSet.h>

//----------------------------------------------------------------------------------------
//						PointGrid
//----------------------------------------------------------------------------------------


class PointGrid : public Region2
{
  OrderedPoint** fData;
  
  public:
                         // Constructors

  PointGrid(int r0, int c0, int r1, int c1, int r_inc = 1, int c_inc = 1);
  PointGrid(const PointGrid& md);
  PointGrid(const Region2& r);
  inline PointGrid() : Region2() { fData = NULL; setincrement(1,1); }        	  
  
  inline int BSize() { return nelem()*sizeof(OrderedPoint*); }
  inline int isActive() { return (fData != NULL); }
  inline int NElements() { return nelem(); }
  inline void SetFields(int r0, int c0, int r1, int c1, int r_inc = 1, int c_inc = 1) 
  { setupper(r1,c1); setlower(r0,c0); setincrement(r_inc,c_inc); }        	  
  
  inline OrderedPoint* GetPoint( int ir, int ic ) const { 
    int index = bindex(ir,ic);
    if( !inside(ir,ic) ) {  return NULL; }
    if( index < 0 || index >= nelem() ) { return NULL; }
    return fData [ index ];
  }
  inline OrderedPoint* GetPoint( const Point2& p  ) const { return GetPoint(p(0),p(1)); }
  
  inline OrderedPoint* SetPoint( OrderedPoint* value, int ir, int ic ) { 
    int index = bindex(ir,ic);
#ifdef DEBUG
    if( !inside(ir,ic) )  { gPrintErr("Illegal Index"); return NULL; }
    if( index < 0 || index >= nelem() ) { gPrintErr("Illegal Index");  return NULL; }
#endif
    return ( fData [ index ] = value );
  }
  
  inline void Alloc(Region2& r) {
    ((Region2&)(*this)) = r;
    if(fData) delete[] fData;
    fData = (OrderedPoint**) malloc( sizeof(OrderedPoint*) * nelem() );
  }

  inline void Alloc() {
    if(fData) delete[] fData;
    fData = (OrderedPoint**) malloc( sizeof(OrderedPoint*) * nelem() );
  }
  inline void Set ( OrderedPoint* p ) { for(int i=0; i<nelem(); i++ ) fData[i] = p; }  
  void ReAlloc(int r0, int c0, int r1, int c1, int r_inc = -1, int c_inc = -1);
  void ReAlloc( const Region2& r );
  void CopyData( OrderedPoint** data, const Region2& r);
};

#endif
