//----------------------------------------------------------------------------------------
//	PointSet.cc
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------

#include "PointSet.h"

/*
*************************************************************************
*									*
* OdreredPointSet								*
*									*
*************************************************************************
*/


void OrderedPointSet::Dump(FILE* oFile) { 
  if(oFile) { 
    fprintf(oFile,"PL%d(%x %x %x %x %x %x %x %x )\n", fNObjects, 
	    fInfo[0],fInfo[1],fInfo[2],fInfo[3],fInfo[4],fInfo[5],fInfo[6],fInfo[7] ); 
  } else { 
    sprintf(gMsgStr,"PL%d(%x %x %x %x %x %x %x %x )\n", fNObjects, 
	    fInfo[0],fInfo[1],fInfo[2],fInfo[3],fInfo[4],fInfo[5],fInfo[6],fInfo[7] ); 
    gPrintLog(); 
  }
  for( Pix px = first(); px != 0; next(px) ) {                         
    ((OrderedPoint&)get_object(px)).Dump(oFile);
    DumpLink(px,oFile);
  }
}

OrderedPointSet& OrderedPointSet::CopyRegion( OrderedPointSet& g, Region2& r ) {
  clear();
  for( Pix p = g.first(); p; g.next(p) ) {                         
    OrderedPoint& point = (OrderedPoint&) g.get_object(p);
    if( r.inside(point) ) { Add(point); }
  }
  return *this;
}








