//----------------------------------------------------------------------------------------
//	PointSet.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __PointSet__
#define __PointSet__

#include "PointPlex.h"
#include "PixGrid.h"
#include "ODLnkSet.h"

const int kBlockSize = 100;

class OrderedPointSet : public TOrderedObjectODLSet, public TOrderedObject { 

    Pix* fPixMap;
    unsigned int fMapSize;
    char fInfo[8];
    Pix fCurrent;

#ifdef USE_MPI
    MPI_Comm fComm;
#endif
    
public:

  OrderedPointSet() { fCurrent=0; fMapSize=0; memset(fInfo,0,8); fPixMap = NULL;}
  OrderedPointSet(int size) : TOrderedObjectODLSet(size) { fCurrent=0; fMapSize=0; memset(fInfo,0,8); fPixMap = NULL;}

  inline void ReSizeMap( int size ) { 
    if( size<=fMapSize) return;
    int newsize = size + kBlockSize;
    Pix* newPix = new Pix[ newsize ]; 
    for(int i= fMapSize; i<newsize; i++) newPix[i] = (Pix)0;
    if( fPixMap ) { 
      for(int i= 0; i<fMapSize; i++) newPix[i] = fPixMap[i]; 
      delete[] fPixMap; 
    }
    fPixMap = newPix; fMapSize = newsize;
  }
  	
  inline Pix GetPix( const OrderedPoint& p ) const {
		int index = p.Index();
		if( index >= fMapSize ) return 0;
    return fPixMap[ index ];
  }  

  inline Pix SetPix( const OrderedPoint& p, Pix val ) {
  	ReSizeMap(p.Index() +1 );
    return fPixMap[ p.Index() ] = val;
  }

  inline int contains( const OrderedPoint& p ) {
		int index = p.Index();
		if( index >= fMapSize ) return 0;
    return ( fPixMap[ index ] != 0 );
  }
  
	inline const OrderedPoint& GetPoint( Pix p ) const {
    return (OrderedPoint&) get_object(p);
  }

  OrderedPointSet& CopyRegion( OrderedPointSet& set, Region2& r ); 

  void Dump(FILE* oFile=NULL) const;

  inline int Size() const { return fNObjects; }

  inline Pix Add(OrderedPoint& point) {
    return SetPix( point, add(point) );
  }


  inline int Index( const Pix p ) const { return index(p); }

  inline int Index( const OrderedPoint& pt ) const { Pix p = GetPix(pt); return ( p ? index(p) : -1 ); }
  

};

#endif
