#include "SDSObject.h"
#include "HDFMgr.h"

int32 SDSObject::SDExport( char* pathName  )
{
#ifdef HAS_HDF
  CString fileName = CString(pathName) + fVariableName.chars() + "_" + fDSetName.chars() + ".sds";
  int32 sd_id = SDstart( fileName.chars(), DFACC_CREATE );
  int32 dims[3];
  int32 size0 = DimensionSize ( 0 ); 
  int32 size1= DimensionSize ( 1 );
  int32 size2= DimensionSize ( 2 );

  dims[0] = size0;
  dims[1] = size1;
  dims[2] = size2;
  int32 sds_id = SDcreate( sd_id, (char*)DSetName(), DFNT_FLOAT32, 3, dims );

  char name[kAttrStrLen], units[kAttrStrLen], format[kAttrStrLen], info[kAttrStrLen];
  SDgetdatastrs( fSDS_id, name, units, format, NULL, kAttrStrLen );
  SDsetdatastrs( sds_id, name, units, format, NULL );

  int32 istat, start[3] = {0,0,0};

  float* dataBuff = new float[ dims[0] * dims[1] * dims[2] ]; 
  istat = SDreaddata(fSDS_id, start, NULL, dims, dataBuff );
  istat = SDwritedata( sds_id, start, NULL, dims, dataBuff );
  delete[] dataBuff;

  ExportSetAttributes(sds_id);

  SDendaccess(sds_id);
  SDend(sd_id);
  return istat;
#endif
  return 0;
}


