//----------------------------------------------------------------------------------------
//	SDSObject.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __SDSObject__
#define __SDSObject__

#ifdef HAS_HDF
extern "C" {
#include "mfhdf.h"
}
#else
extern "C" {
#include "sme_types.h"
}
#endif

#include "TObjects.h"
#include "Environ.h"
#include "XGraph.h"

const int kF_All = -1;

class SDSObject : public TOrderedObject {

protected:

  int32 fSD_id;
  int32 fSDS_id;
  CString fDSetName;
  CString fVariableName;

public:
  
  SDSObject() { fSD_id = 0; fSDS_id = 0; }
  ~SDSObject() { SDFinalize(); }

  inline const char* DSetName() const  { return fDSetName.chars(); }
  inline const char* VariableName() const { return fVariableName.chars(); }
  inline void DSetName( const char* name ) { fDSetName = name; }
  inline void VariableName( const char* name ) { fVariableName = name; }

  virtual int32 SDWrite( const char* info=NULL, const char* units=NULL, const char* format=NULL ) = 0;
  virtual int32 SDRead( int index, int32 group_ref, char* info=NULL, char* units=NULL, char* format=NULL ) = 0;
  int32 SDExport( char* fileName  );
  virtual int32 ExportSetAttributes(int32 sds_id) = 0;
  inline int NData() { return DimensionSize(0); }

  virtual int TextDump( const CString& path, int index=0, int nData=1, const char* info=NULL, const char* units=NULL, const char* format=NULL ) const 
    { gPrintErr("Can't TextDump this type of SDSObject."); return 0; } 

#ifdef HAS_X
  virtual int GraphData( TGraph* aGraph, int index=0, int nData=1, char* info=NULL ) { gPrintErr("Can't Graph this type of SDSObject."); } 
  virtual int ViewData( TSheet* aSheet, int index=0, int nData=1, char* info=NULL ) { gPrintErr("Can't View this type of SDSObject."); }
  virtual int AnimateData( XAnim* aAnim, int index=0, int nData=1, char* info=NULL) { gPrintErr("Can't Animate this type of SDSObject."); }
#endif
  virtual int DumpMap( const CString& path, int index=0, int nMaps=1, char* info=NULL ) { gPrintErr("Can't Dump this type of SDSObject as MapII"); return 0; } 
  virtual int DumpHDF( const CString& path, int index=0, int nMaps=1, char* info=NULL ) { gPrintErr("Can't Dump this type of SDSObject as HDF"); return 0; }
  virtual byte* GetData() { gPrintErr("Get Data not implemented for this type of SDSObject"); return (byte*)NULL; }
  virtual int DataSize() { return 0; }  // data size in bytes; 

  virtual int32 SDFinalize() {
    if( fSD_id == 0 ) return 0; 
#ifdef HAS_HDF 
    comp_info c;
//    SDsetcompress(fSD_id,"COMP_RLE",&c);
    int istat = SDendaccess(fSD_id);
    fSD_id = 0;
    return istat;
#endif
  }

  inline int DimensionSize (int index) {
#ifdef HAS_HDF
    int32 size;
    int32 dim_id = SDgetdimid( fSDS_id, 0 );
    SDdiminfo( dim_id, NULL, &size, NULL, NULL);
    return (int)size;
#endif
		return 0;
  }

  inline int ReadAttr( char* name, void* value ) {
#ifdef HAS_HDF
    int32 rindex = SDfindattr(fSDS_id,name);
    return SDreadattr(fSDS_id, rindex, value );
#else
	return 0;
#endif
  }
};


#endif

