#if __GNUG__ >= 2
#  pragma implementation  
#endif

#include "TCell.h"
#include "MultiGrid.h"
int LinkLayer::_count_index = 0;
int LinkLayer::kLinkIncrement = 4;

FlagIndex CellIndex::f0 = 1;
FlagIndex CellIndex::f1 = 2;
FlagIndex CellIndex::f2 = 4;
FlagIndex CellIndex::f3 = 8;
FlagIndex CellIndex::f4 = 16;
FlagIndex CellIndex::f5 = 32;
FlagIndex CellIndex::f6 = 64;
FlagIndex CellIndex::f7 = 128;

//---- TCell ---------------------------------------------------------

enum EIndexIndex TCell::kNActivationLayers = kO_Index0;
enum EIndexIndex TCell::kOwner = kO_Index1;
enum EInfoIndex TCell::kNLinkLayers  = kO_Info0;
enum EInfoIndex TCell::kGhostIndex = kO_Info1;
enum EInfoIndex TCell::kLayerIndex = kO_Info2;
enum EInfoIndex TCell::kTmp = kO_Info3;

int TCell::kActivationLevelIncrement = 2;
int TCell::kNeighborLevelIncrement = 2;

MultiGrid* TCell::fMultiGrid = NULL;

TCell::TCell( int index, byte layerIndex, int maxActivationLevels ) : TOrderedObject(index)  {
	_activationLayers = NULL;
	_neighborLinkLayers = NULL;
	_childrenLinkLayer = NULL;
	_next = _parent = NULL;
	if(maxActivationLevels) createActivationLevel( maxActivationLevels );
	else SetObjIndex( kNActivationLayers, 0 );
	SetObjInfo( kLayerIndex, layerIndex );
	_global_index = -1;
}

TCell::TCell( TCell* c ) : TOrderedObject( c->Index() )  {
	_activationLayers = c->_activationLayers;
	_neighborLinkLayers = c->_neighborLinkLayers;
	_childrenLinkLayer = c->_childrenLinkLayer;
	_activationLayers = c->_activationLayers;
	_next = c->_next;
	_parent = c->_parent;
	memcpy(fInfo,c->fInfo,8);
	_global_index = -1;
}

TCell::~TCell() {
	if(_activationLayers)  delete[] _activationLayers;
	if(_neighborLinkLayers)  delete[] _neighborLinkLayers;
	if(_childrenLinkLayer)  delete _childrenLinkLayer;
}


void TCell::createActivationLevel( int nlevel ) {
	int new_levels = nlevel + kActivationLevelIncrement;
	CellIndex* new_layers = new CellIndex[new_levels];
	if( _activationLayers ) { 
		memcpy(new_layers,_activationLayers,GetObjIndex(kNActivationLayers)*sizeof(CellIndex));
		delete[] _activationLayers;
	}
	_activationLayers = new_layers;
	SetObjIndex( kNActivationLayers, new_levels );
}

void TCell::activateParent(  ActivationLayer* layer, int up_levels ) {
	int activation_Level = layer->Index();
	TCell* parent = this;
	while( up_levels-- ) { 
		if( parent->parent() == NULL ) break;
		parent = parent->parent(); 
	}
	parent->activate( layer );
}

void TCell::activateChildren( ActivationLayer* cell_layer, int down_levels ) {
	int activation_Level = cell_layer->Index();
	if( childLinkLayer() == NULL ) { activate(cell_layer); }
	else {
		down_levels--;
		for( TCell* c = _childrenLinkLayer->first(); c; c = _childrenLinkLayer->next() ) {
			if( down_levels == 0 ) {
				c->activate(cell_layer);
			} else {
				c->activateChildren(cell_layer,down_levels);
			}
		}
	}
}

int TCell::setActiveAboveRecur( int activation_Level ) {
	if( setActivatedAbove( activation_Level ) ) return 0; 
	if( _childrenLinkLayer ) { 
		for( TCell* c = _childrenLinkLayer->first(); c; c = _childrenLinkLayer->next() ) {
				c->setActiveAboveRecur( activation_Level );
		}
	}
	return 1;
}

unsigned int TCell::operator() (int dim) const {
	int layer_index =  GetObjInfo( kLayerIndex );
	return fMultiGrid->getCellLayer( layer_index )->getLocCoordFromKey( dim, Index() ); 
}

int TCell::setActiveBelowRecur( int activation_Level ) {
	if( setActivatedAbove( activation_Level ) ) return 0;
	if( _parent ) { _parent->setActiveBelowRecur( activation_Level ); }
	return 1;
}

void TCell::activate( ActivationLayer* layer ) {
	int activation_Level = layer->Index();
	if( _activationLayers[activation_Level].active() == 0 ) {
		layer->addCell(this); 
		if( _parent ) { setActiveBelowRecur( activation_Level ); }
		if( _childrenLinkLayer ) { 
			for( TCell* c = _childrenLinkLayer->first(); c; c = _childrenLinkLayer->next() ) {
					c->setActiveAboveRecur( activation_Level );
			}
		}
	}
}

TCell* TCell::getNeighbor( int link_layer, int link_index ) {
#ifdef DEBUG
  if( _neighborLinkLayers == NULL )  {
	sprintf(gMsgStr,"Missing Link Layers: %d %d : ( %d, %d ) -> Check Frame declaration in config file!\n\n", link_layer, link_index, row(), col() );
	gPrintScreen();
  }
#endif
  return _neighborLinkLayers[link_layer]->Link( link_index ); 
}

void TCell::finalizeActivation( int activation_Level, int32 memory_index ) {
	_activationLayers[activation_Level].activate( memory_index );
}

void TCell::mergeDataOverChildren( const float* data, int activationLevel, float& sum_value, int* icount, float* max_value, float* min_value ) {
	if( activated(activationLevel) ) {
		float d = data[ memoryIndex(activationLevel) ];
		sum_value += d;
		if(icount) { (*icount)++; }
		if(max_value) { if( d > *max_value) *max_value = d; }
		if(min_value) { if( d < *min_value) *min_value = d; }
	} else  if( _childrenLinkLayer ) { 
		for( TCell* c = _childrenLinkLayer->first(); c; c = _childrenLinkLayer->next() ) {
				c->mergeDataOverChildren( data, activationLevel, sum_value, icount, max_value, min_value  );
		}
	}
}

void TCell::computeCellsize() {
	if( _childrenLinkLayer ) { 
		_cellsize = 0;
		for( TCell* c = _childrenLinkLayer->first(); c; c = _childrenLinkLayer->next() ) {
				_cellsize += c->cellsize();
		}
	}
}




