#ifndef __XAnimation__
#define __XAnimation__

#ifdef HAS_X
 
#include "XGraph.h"
#include "TMap2.h"

//----------------------------------------------------------------------------------------
//					 XAnimation
//----------------------------------------------------------------------------------------

enum EXA_Info { kXA_ShowDecomp };

class XAnimation : public TMap2 
{
protected:
 
  XAnim* fAnim;
  int fRootProc;
  byte fInfo[8];
  PointSetCoverage* fCov;

public:
  XAnimation(Region2* region, int mag=1, char* name=NULL, float s1=1.0, float s0=0.0, int rootProc=0, Xgraph* xg=NULL) 
    : TMap2(region) {
    if((fRootProc = rootProc) == gIProc ) {
      Xgraph* xgraph = (xg==NULL) ? new Xgraph(extents(1)*mag+80,extents(0)*mag+80,True) : xg;
      fAnim = (XAnim*)xgraph->NewImage(kXAnim);
      fAnim->SetMapData( name, s0, s1);
      fAnim->CreateNewImage( extents(1), extents(0), (char*)Data(), mag );
    } else fAnim = NULL; 
    fS[0] = s0; fS[1] = s1;
    memset(fInfo,0,8);
    fCov = NULL;
  }

  ~XAnimation() { if(fAnim) delete fAnim; }

  inline void SetInfo (EXA_Info index, byte val) { fInfo[index] = val; }
  inline byte GetInfo (EXA_Info index) { return fInfo[index]; }
 
  inline void Flush( PointSetCoverage* cov=NULL ) {
    if(cov) fCov = cov;
    if( fRootProc == gIProc ) {
      fAnim->SetImageData( (char*)Data() );
      fAnim->Flush();
      if(fInfo[kXA_ShowDecomp] && fCov) {
	for(int i=0; i<gNProc; i++) fAnim->DrawRegion(fCov->Region(i));
      }
    }
  }

  inline XAnimation& operator=( PointSetCoverage& cov ) { 
    byte* data = NULL;
    cov.Condense( data, fRootProc, 1,  kPSC_Grid, fS[1], fS[0] );
    if( fRootProc == gIProc ) { CopyDataFrom( data, 1, cov.GlobalRegion() ); }
    fCov = &cov;
    return *this; 
  }       
};

#endif
#endif

  

