#ifndef _included_XObject2_h
#define _included_XObject2_h

/****************************************************************
* XObject.h							*
*								*
* An XObject is anything that has a processor owner and a 	*
* Region							*
*****************************************************************/

#include "Region2.h"
#include "Globals.h"

#ifndef XOBJ_NO_OWNER
#define XOBJ_NO_OWNER (-1)
#endif

class XObject2: public Region2
{
   int _owner;		/* processor that owns this object */
public:
   inline XObject2(): _owner(XOBJ_NO_OWNER) {}
   inline XObject2(const int proc): _owner(proc) {}
   inline XObject2(const int proc,const Region2& R): 
		_owner(proc), Region2(R) {}
   inline ~XObject2() {}

   inline int owner() const { return(_owner); }

   inline void setowner(const int proc) { _owner = proc; }

   inline int local_object() const {return (_owner == gMyID());}
};

#endif
