//----------------------------------------------------------------------------------------
//	Fluxes.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __Fluxes__
#define __Fluxes__ 
 
#include "SSVariable.h"
#include "SSModule.h"

class Flux {

public:

  enum EType { kGW, kSW };
  enum EFluxUnits { kHead, kVolume };

protected:

  static TSpatialFluxVariable fSWfluxWE;
  static TSpatialFluxVariable fSWfluxNS;
  static TSpatialFluxVariable fGWfluxWE; 
  static TSpatialFluxVariable fGWfluxNS;
  static TVariable* fCellSize;

  static float fAlpha[5];
  static float fSFluxIn, fSFluxOut, fGFluxIn, fGFluxOut;  
  static float fBaseFluxRate;
  static Pix fCurrentSPoint, fCurrentGPoint;
  static TModule* fCurrentModule;
  static DistributedGrid* fCurrentGrid;
	
  static float SurfaceWater( Pix p0, Pix p1, TSpatialVariable& SWater, TSpatialVariable& Elevation, TSpatialVariable& MC );
  static float GroundWater( Pix p0, Pix p1, TSpatialVariable& GW_head, TSpatialVariable& tot_head, TSpatialVariable& rate );
  static inline int AllowFlux( EType type, Pix p0, Pix p1) { return ( p0 > 0 && p1 > 0 ); }
  static inline int AllowFlux( EType type, Pix p0) { return (p0 > 0); }

public:

  static int Config(TConfigData& config);
  static void Setup( );
  
  static float SWP( Pix p0, TSpatialVariable& SWater, TSpatialVariable& Elevation, TSpatialVariable& MC, EFluxUnits uf = kVolume);
  static float GWP( Pix p0, TSpatialVariable& GW_head, TSpatialVariable& tot_head, TSpatialVariable& rate, EFluxUnits uf = kVolume);
  static float SWInP( Pix p0, TSpatialVariable& SWater, TSpatialVariable& Elevation, TSpatialVariable& MC);
  static float GWInP( Pix p0, TSpatialVariable& GW_head, TSpatialVariable& tot_head, TSpatialVariable& rate);
  static float SWOutP( Pix p0, TSpatialVariable& SWater, TSpatialVariable& Elevation, TSpatialVariable& MC);
  static float GWOutP( Pix p0, TSpatialVariable& GW_head, TSpatialVariable& tot_head, TSpatialVariable& rate);
  static float SWInHeadP( Pix p0, TSpatialVariable& SWater, TSpatialVariable& Elevation, TSpatialVariable& MC);
  static float GWInHeadP( Pix p0, TSpatialVariable& GW_head, TSpatialVariable& tot_head, TSpatialVariable& rate);
  static float SWOutHeadP( Pix p0, TSpatialVariable& SWater, TSpatialVariable& Elevation, TSpatialVariable& MC);
  static float GWOutHeadP( Pix p0, TSpatialVariable& GW_head, TSpatialVariable& tot_head, TSpatialVariable& rate);
  static float SWTransportOutP( Pix p0, TSpatialVariable& SWater_height, TSpatialVariable& Constituents);
  static float SWTransportInP( Pix p0, TSpatialVariable& SWater_height, TSpatialVariable& Constituents);
  static float GWTransportOutP( Pix p0, TSpatialVariable& GWater_head, TSpatialVariable& Constituentsy);
  static float GWTransportInP( Pix p0, TSpatialVariable& GWater_head, TSpatialVariable& Constituents);

};


#endif
