#include "Frame.h"
#include "DistributedGrid.h"
#include "CVariable.h"
#include "Externals.h"
#include "SSModel.h"
#include "GOFCalc.h"

/*
byte TFrame::kUndefined = 255;
EConfigInfo TFrame::kType = kCInfo0;
EConfigInfo TFrame::kisSetup = kCInfo1;
EConfigInfo TFrame::kisGlobal = kCInfo2;
EConfigInfo TFrame::kSetupMode = kCInfo3;

TNamedObjectList TFrame::fPSetList;


int  TFrame::Config(TConfigData& cd) {
  MFrame::Config(cd);
  const TString& cmd = cd.Cmd();
  int iarg;

  if( cmd == "s" ) {
    SetType( DGrid::kScalar );
  } else if( cmd == "g" ) {
    SetType( DGrid::kGrid );
  } else if( cmd == "t" || cmd == "T" )  {
    SetType( DGrid::kTree );
    if( cmd == "T" ) SetCInfo(kSetupMode,1);
  } else return 0;

  if( fIArgs[0] > 0 ) SetParm(TFrame::kScale,iarg);
  if( fIArgs[1] > 0 ) SetParm(TFrame::kAgg,iarg);
  if( fIArgs[2] > 0 ) SetParm(TFrame::kMaxGhost,iarg);
  if( fIArgs[3] > 0 ) SetParm(TFrame::kMaxComm,iarg);

  return 1;
}  

inline TFrame& TFrame::operator= ( TFrame& f ) {
    fPSet = f.fPSet;
    fMaxGhost = f.fMaxGhost;
    fMaxCommD = f.fMaxCommD;
    fScale = f.fScale;
    fAgg = f.fAgg;
    MFrame::operator= ( f );
    return *this;
}


void TFrame::Setup() {
  if( GetCInfo(kisSetup) ) return;
  ReadRegionMap();
  if( GetCInfo(kisGlobal) ) {
    Net::SetGrid( fRegionMap );
  }
  Setup( Type(), fScale );
  SetCInfo(kisSetup,True);
}

*/


MultiGrid* TMultiFrame::fMultiGrid = NULL;

void TMultiFrame::SetCoordVariable( byte index, CVariable* var ) {
	if( index >= 3 ) return;
	_CoordVar[index] = var;
	sprintf(gMsgStr,"Setting Coord Variable %s:%d", var->Name(), index );
	gPrintScreen();
}

void TMultiFrame::Setup( LayerConfig& lc ) {
  TPartition2*  partition = NULL;
  if( lc.GetCInfo(LayerConfig::kisSetup) ) return;
	ETopology type = lc.Type();
	TLayer* l = NULL;
	if( type == kCollection ) {
		if( fMultiGrid != NULL ) { gFatal("Can't mix Point Collection Frame with Grid or Tree Frames!"); }
		fMultiGrid = new MultiGrid;
		partition = new TPartition2;
		partition->setup( gNProc, lc.Dim(0), lc.Dim(1), 0, fMaxGhost );
		for( int i=0; i<lc.Dim(2); i++ ) {
			TLayer* l = fMultiGrid->addCellLayer( i, lc.Dim(0), lc.Dim(1) );
			l->setPartition(partition);
			l->addCells( fMaxGhost );
		}
		fMultiGrid->defineActivationLayer( -1, lc.activationLayerIndex() );
	} else if( type == kParameterSpace ) {
		if( fMultiGrid != NULL ) { gFatal("Can't mix ParameterSpace Frame with Grid or Tree Frames!"); }
		
#ifdef HAS_MPE 
		fMultiGrid = new MultiGrid;
		partition = new TPartition2;
		int Ncells = GOFCalc::getNCells();
		partition->setup( gNProc, 1, Ncells, 0, fMaxGhost );
		TLayer* l = fMultiGrid->addCellLayer( 0, 1, Ncells );		
		l->setPartition(partition);
		l->addCells( fMaxGhost );
		fMultiGrid->defineActivationLayer( -1, lc.activationLayerIndex() );
#endif

	} else if( type == kVolume ) {
		TModel::I().SetCInfo(Model::kOptLevel,0);
		if( fMultiGrid != NULL ) { gFatal("Can't mix Volume Frame with Grid or Tree Frames!"); }
		fMultiGrid = new MultiGrid;
		partition = new TPartition2;
		int nLayers;
		int partition_type = Externals::get_partition_type();
		TMap* depthMap = (TMap*) lc.getDepthMap();	
//		depthMap->Dump( Env::LogFile(), -1, "Depth Map:\n" );	
		switch( partition_type ) {
		  case -1:
			nLayers = partition->setup( gNProc, *fRegionMap, 0, fMaxGhost );
		  break;
		  case 1: {
			 int prows = Externals::get_partition_dim(0);
			 int pcols = Externals::get_partition_dim(1);
			 nLayers  = Externals::get_grid_dim(2);
			 partition->setup_uniform( lc.Dim( 0 ), lc.Dim( 1 ), prows, pcols, fRegionMap, fMaxGhost );
		  } break;
		}
		fMultiGrid->addCellLayers( lc.Dim( 2 ), partition, fMaxGhost ); 
		float* depth_array = lc.GetDepthArray();
		float abs_depth = 0.0;
		for( int index=0; index<lc.Dim( 2 ); index++ ) {
			TLayer* l = fMultiGrid->getCellLayer( index );
			l->setDepthValues( depth_array[index], abs_depth );
			abs_depth += depth_array[index];
			l->linkNeighbors( lc.LinkLayer(), lc.activationLayerIndex(), fRegionMap, kVolume, lc.FrameLinkBase(), lc.MethodName(), lc.Dim( 2 ) ); 
		}
		int surface_act_layer = lc.activationLayerIndex()+1;
		int volume_act_layer = lc.activationLayerIndex();		
		ActivationLayer* al0 = fMultiGrid->defineActivationLayer( -1, volume_act_layer );    // Create volume actication level (0)
		ActivationLayer* al1 = fMultiGrid->defineActivationLayer(  0, surface_act_layer );  // Create surface activation level (1)
		CString* map = lc.getMapName(0);     // depth map
		if( map != NULL ) {
		  map->upcase();	
		  CVariable* var = (CVariable*) Model::I0().GetVariable(*map);
		  if( var != NULL ) {
			var->AllocateSpatialVariable( surface_act_layer, lc.LinkLayer() );
			if( depthMap != NULL ) {
			  var->CopyFromMap( *depthMap );
			}
		  }
		}
		map = lc.getMapName(1);          // depth variable
		if( map != NULL ) {
		  map->upcase();	
		  CVariable* var = (CVariable*) Model::I0().GetVariable(*map);
		  if( var != NULL ) {
			var->AllocateSpatialVariable( volume_act_layer, lc.LinkLayer() );
			for( int32 i = 0; i < al0->nActiveCells(); i++ ) {
				TCell* c = al0->cell(i);
				int cell_layer = c->GetObjInfo( TCell::kLayerIndex );
				TLayer* l = fMultiGrid->getCellLayer( cell_layer );
				var->SetValue( c, l->getDepth() ); 
			}
		  }
		}
		map = lc.getMapName(2);         // cell height
		if( map != NULL ) {
		  map->upcase();	
		  CVariable* var = (CVariable*) Model::I0().GetVariable(*map);
		  if( var != NULL ) {
			var->AllocateSpatialVariable( volume_act_layer, lc.LinkLayer() );
			for( int32 i = 0; i < al0->nActiveCells(); i++ ) {
				TCell* c = al0->cell(i);
				int cell_layer = c->GetObjInfo( TCell::kLayerIndex );
				TLayer* l = fMultiGrid->getCellLayer( cell_layer );
				var->SetValue( c, l->getHeight() ); 
			}
		  }
		}
		
	} else {
		if( fMultiGrid == NULL ) { 
			fMultiGrid = new MultiGrid;
			int iL0 = lc.CellLayer(), iL1 = iL0 + lc.Dim( 2 );
			for( int iL = iL0; iL < iL1; iL++ ) {
			  TLayer* l = fMultiGrid->addCellLayer( iL, fRegionMap->extents(0), fRegionMap->extents(1) );
			  if( partition == NULL ) {
				partition = l->partition();
				ByteGrid* region_map;
				int data_type = fRegionMap->GetObjInfo(TMap::kDataType);
				if( (data_type == TMap::kBytes) && ( fRegionMap->NBytes() == 1 ) ) {
				  region_map = fRegionMap;
				} else {
				  int rows = fRegionMap->extents(0);
				  int cols = fRegionMap->extents(1);
				  region_map = new ByteGrid( (Region2&) *fRegionMap );
				  for( int ir=0; ir<rows; ir++ ) {
					for( int ic=0; ic<cols; ic++ ) {
					  region_map->SetValue( ir, ic, fRegionMap->IntValue( ir, ic ) );
					}
				  }
				}
				partition->setup( gNProc, *region_map, 0, fMaxGhost );
			  } else {
				l->partition(partition);
			  }
			  l->addCells( fMaxGhost );
			}
		} else {
			int cellLayer = lc.CellLayer(); 
			l = fMultiGrid->getCellLayer( cellLayer ); 
		}
		if( l != NULL ) { l->linkNeighbors( lc.LinkLayer(), lc.activationLayerIndex(), fRegionMap, lc.Type(), lc.FrameLinkBase(), lc.MethodName() );  }
		fMultiGrid->defineActivationLayer( -1, lc.activationLayerIndex(), fRegionMap );
	}
	
	if( partition == NULL ) {
	  int cell_layer_index = -1;
	  partition = fMultiGrid->GetPartition(cell_layer_index);
	}
	if( partition == NULL ) return;
	ByteGrid* cellDistribution = partition->cellDistribution();
	unsigned int global_index=0;
	for( int cell_layer_index = 0;  cell_layer_index < lc.Dim( 2 ); cell_layer_index++ ) {
	  TLayer* cell_layer = fMultiGrid->getCellLayer( cell_layer_index );
	  if( cell_layer != NULL ) {
		for( unsigned int row = 0; row < lc.Dim( 0 ); row++ ) {
			for( unsigned int col = 0; col < lc.Dim( 1 ); col++ ) {
			  TCell* cell = cell_layer->getCell(row,col);
			  int owner = partition->getowner( row, col );
			  int cd_value = cellDistribution->IntValue( row, col );
			  if( (cd_value > cell_layer_index) || ((type != kVolume) && (cd_value > 0)) ) {
				if( gIProc == owner ) {
				  if( cell == NULL ) {
					sprintf(gMsgStr,"Missing cell at coords (%d %d %d) ",row,col,cell_layer_index); gFatal();
				  }
				  cell->setGlobalIndex(global_index);
				}
				global_index++;
			  }
			}
		}
	  }
	}
	fMultiGrid->setNCells( global_index ); 

	lc.SetCInfo(LayerConfig::kisSetup,True);
}

/*
CVariable* TMultiFrame::getSurfaceVariable( String name, int activationLevel, int linkLayer, Module* m ) {
	CVariable* rv  = new CAuxVariable(name);
	rv->SetF(FisSpatial,True,"GetSimilarVariable"); 
	rv->SSInit(m);
	rv->setActivationLevel(activationLevel,linkLayer);
	rv->Allocate();
	return rv;
}
 */
 
int  TMultiFrame::Config(TConfigData& cd, Module* m) {
  return MFrame::Config(cd,m);
}  

ByteGrid* TMultiFrame::RegionMap(int layer_index) { 
	return fMultiGrid->RegionMap(layer_index); 
}

inline TMultiFrame& TMultiFrame::operator= ( TMultiFrame& f ) {
    fMultiGrid = f.fMultiGrid;
    fMaxGhost = f.fMaxGhost;
    MFrame::operator= ( f );
    return *this;
}

int TMultiFrame::hasLayersConfigured() { return !fLayerConfigs.empty(); }

void TMultiFrame::Setup() {
	for( Pix p = fLayerConfigs.first(); p; fLayerConfigs.next(p) ) {
		LayerConfig& lc = (LayerConfig&) fLayerConfigs(p);
		ETopology type = lc.Type();
		if( type != kCollection ) { ReadRegionMap(lc); }
		Setup( lc );
	}
	for( int i=0; i<3; i++ ) {
		SetupCoordVar( i, _CoordVar[i] );
	}
}

void TMultiFrame::SetupCoordVar( int index, CVariable* var ) {
  if( var != NULL ) {
	int coord;
	ActivationLayer* al0 = DefaultActivationLayer();
	var->AllocateSpatialVariable( al0->Index(), 0 );
	var->SetCInfo(CVariable::kInitMode,CVariable::kFrameCalc);
	int ncells = al0->nActiveCells();
	for( int32 i = 0; i < ncells; i++ ) {
		TCell* c = al0->cell(i);
		switch( index ) {
			case 0: coord = c->row(); break;
			case 1: coord = c->col(); break;
			case 2: coord = c->GetObjInfo( TCell::kLayerIndex ); break;
		}
		var->SetValue( c, coord ); 
	}
	sprintf(gMsgStr,"Setting up Coord Var %s(%d): ncells %d",var->Name(),index,ncells);
	gPrintScreen();
  }
}

ByteGrid* TMultiFrame::ReadRegionMap( LayerConfig& lc ) {
	if( fRegionMap == NULL ) {
		fRegionMap = new TMap(kClassMap);
		fRegionMap->VariableName("Input");
	}
	fRegionMap->DSetName( lc.MapName() );
	fRegionMap->Read( lc, 1 );
	if( lc.Dim(0) == 0 ) {
	  lc.SetDimensions(fRegionMap->extents(0),fRegionMap->extents(1));
	}
	return fRegionMap;
}

ByteGrid* TMultiFrame::GetRegionMap( Module* m ) {
	if( fRegionMap == NULL ) { ReadRegionMap( *(getLayerConfig( m )) ); }
  return fRegionMap;
}
