//----------------------------------------------------------------------------------------
//	Frame.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------


#ifndef __Frame__
#define __Frame__

#include "DistributedGrid.h"
#include "MultiGrid.h"
#include "TMap.h"
#include "SList.h"
#include "MML_Frame.h"

const int kNoData = -1;
/*
class TFrame : public MFrame {

protected:

  static byte kUndefined;

  static TNamedObjectList fPSetList;
  DistributedGrid* fPSet;
  TMap* fRegionMap;

  int fMaxGhost;
  int fMaxCommD;
  int fScale;
  int fAgg;

  inline DGrid* GetPSet ( DGrid::EFrameType type, int scale ) {
    for( Pix p = fPSetList.first(); p; fPSetList.next(p) ) {
      DGrid& g = (DGrid&) fPSetList(p);
      if( g.Same( fRegionMap, type, scale) ) return &g;
    }
    return NULL;
  }

  inline void Setup( DGrid::EFrameType type, int scale ) {
    DGrid* ps = GetPSet ( type, scale );
    if( ps ) fPSet = ps;
    else {
      fPSet = new DGrid( scale, fMaxGhost, fMaxCommD);
      fPSet->Setup( *fRegionMap, type, GetCInfo(kSetupMode), fFLBase, fMethodName );
      fPSetList.append(*fPSet);
    }
  }

public:

  enum EParmType { kMaxGhost, kMaxComm, kScale, kAgg };
  static EConfigInfo kType;
  static EConfigInfo kisSetup;
  static EConfigInfo kisGlobal;
  static EConfigInfo kSetupMode;

  TFrame( int maxGhost=2, int maxComm = 0 ) : MFrame() { 
    fMaxGhost=maxGhost; 
    fMaxCommD = (maxComm<fMaxGhost) ? fMaxGhost : maxComm; 
    fScale = 0;
    fAgg = 0;
    fRegionMap = NULL;
  }

  inline void SetParms( int scale=kNoData, int agg = kNoData, int maxGhost=kNoData, int maxComm = kNoData ) {
    if( maxGhost!=kNoData ) { fMaxGhost = maxGhost; }
    if( maxComm!=kNoData ) { fMaxCommD = maxComm; }
    if( scale!=kNoData ) { fScale = scale; }
    if( agg!=kNoData ) { fAgg = agg; } 
  }

  inline void SetParm(  EParmType type, int value ) {
    switch( type ) {
    case kMaxGhost: { fMaxGhost = value; } break;
    case kMaxComm: { fMaxCommD = value; } break;
    case kScale: { fScale = value; } break;
    case kAgg: { fAgg = value; } break; 
    }
  }
  inline int GetParm(  EParmType type ) {
    switch( type ) {
    case kMaxGhost: { return fMaxGhost; } break;
    case kMaxComm: { return fMaxCommD; } break;
    case kScale: { return fScale; } break;
    case kAgg: { return fAgg; } break; 
    }
		return 0;
  }

  inline void SetType( DGrid::EFrameType type ) { SetCInfo(kType,type); }
  inline DGrid::EFrameType Type() { return (DGrid::EFrameType) GetCInfo(kType); }

  void Setup();
	TMap* ReadRegionMap();

  inline int Size() { return fPSet ? fPSet->length() : 0; }
  inline DistributedGrid* Grid() { return fPSet; }

  inline Pix GetPix(int row, int col) const {
    if( fPSet == NULL ) return (Pix)NULL;
    PointRef pr( row, col, fPSet->Region() );
    return fPSet->GetPix(pr); 
  }
  inline byte GetPSInfo ( DGrid::EInfo index ) { return fPSet ? fPSet->GetInfo(index) : kUndefined; }

  TFrame& operator= ( TFrame& f );
	inline int SamePointsAs( const TFrame& f ) const { return ((fMaxGhost == f.fMaxGhost) && SameMap(f)); }
	inline int PointsSubsetOf( const TFrame& f ) const { return ((fMaxGhost <= f.fMaxGhost) && SameMap(f)); }

  byte isGlobal( int b = -1 ) { 
    return (b >= 0) ? fPSet->SetInfo(DGrid::kisGlobal,b) : fPSet->GetInfo(DGrid::kisGlobal); }

  virtual int  Config(TConfigData& cd);
};
*/

typedef class CVariable CVariable;

class TMultiFrame : public MFrame {

public:

  enum EParmType { kMaxGhost };
  enum EOperation { kDepthMap };

protected:

  static MultiGrid* fMultiGrid;
  TMap* fRegionMap;
  CVariable* _CoordVar[3];
  int fMaxGhost;

  inline void Setup( LayerConfig& lc );

public:
  TMultiFrame( int maxGhost=2 ) : MFrame() { 
    fMaxGhost=maxGhost; 
    fRegionMap = NULL;
    for( int i=0; i<3; i++ ) { _CoordVar[i] = NULL; }
  }
	ByteGrid* RegionMap(int layer_index = -1) ;

  inline void SetParms( int maxGhost=kNoData ) {
    if( maxGhost!=kNoData ) { fMaxGhost = maxGhost; }
  }
	inline ActivationLayer* activationLayer(int activation_index) { return fMultiGrid->activationLayer(activation_index); }
	inline ActivationLayer* DefaultActivationLayer() { return fMultiGrid->DefaultActivationLayer(); }
	inline int DefaultActivationIndex() { return fMultiGrid->DefaultActivationIndex(); }
	
  inline void SetParm(  EParmType type, int value ) {
    switch( type ) {
    case kMaxGhost: { fMaxGhost = value; } break;
    }
  }
  inline int GetParm(  EParmType type ) {
    switch( type ) {
    case kMaxGhost: { return fMaxGhost; } break;
    }
		return 0;
  }
	virtual void* getMultiGrid() { return fMultiGrid; }
	int hasLayersConfigured();
	void SetupCoordVar( int index, CVariable* var );
	
	void SetCoordVariable( byte index, CVariable* var );
	
  void Setup();
  
	ByteGrid* ReadRegionMap( LayerConfig& lc);
	ByteGrid* GetRegionMap( Module* m );

  inline int32 Size(int activation_index=0) { return activationLayer(activation_index)->nActiveCells(); }
  static inline MultiGrid* Grid() { return fMultiGrid; }

  TMultiFrame& operator= ( TMultiFrame& f );


  virtual int  Config(TConfigData& cd, Module* m);
  
};


#endif
