//----------------------------------------------------------------------------------------
//	FrameLink.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __FrameLink__
#define __FrameLink__ 
 
#include "DistributedGrid.h"
#include "Config.h"
#include "FLBase.h"
#include "CellRecord.h"

const int kMaxMaps = 5;
const int kMaxIndices = 5;

typedef class TMap TMap;
typedef class Module Module;
typedef class CVariable CVariable;


class FrameLink : public FLBase {

public:

	enum EMapOperation { kMax, kMin, kAve, kSum };
protected:

	CString fMapSource[kMaxMaps];
	CString fMapName[kMaxMaps];
	CString fFormat[kMaxMaps];
	CString fDynamicLinkVar;
	TMap* fSetupMap[kMaxMaps];
	TMap* fLinkMap;
	TMap* fNewLinkMap;
	ByteGrid fLinkedPoints;
	int fIndex[kMaxIndices];
	int fNIndices;
	int fLinkMode;
	int fLinkLayer;
	Module* fCurrentModule;
	float fDynamicLinkStep;
	
#ifdef USE_MPI
	CellRecordDistributedArray fCellArray;
#endif

  DistributedGrid* fCurrentGrid;
  int FSetup;
 
  FrameLink(const char* name) : FLBase(name) { 
		FSetup = 0; fDynamicLinkStep = -1.0; fNIndices = 0; 
		fCurrentGrid=NULL; fLinkMap=NULL; fCurrentModule=NULL; fNewLinkMap=NULL; fLinkMode=0; fLinkLayer = 0;
	}
 
  int LinkNeighbors( TCell* c, TLayer* l, PixArray& pa, int allowDiag = 0 );
  int LinkNeighborsBestPath( TCell* c, TLayer* l, PixArray& pa, int allowDiag = 1 ) ;
  int LinkNeighborsBestPath1( TCell* c, int mapIndex, TLayer* l, PixArray& pa, int allowDiag = 1 ) ;

  TCell* LinkNeighborsDownslope( TCell* c, TLayer* l, int mapIndex=1, Bool checkNeighbors = True  );
  TCell* LinkNeighborsDownslope( TCell* c, TLayer* l, CVariable* v );
  int LinkNeighborsUsingMap(TMap* m);
  float ProcessMapNeighbors( TCell* c, TLayer* l, int mapIndex, EMapOperation mop );
  void Setup();
  int RiverLink( );
  int RiverLink1( );
  int ConfigObject(TConfigData& config);
  virtual void Run( const char* methodName, TMap2* linkMap, int activationLevel, int gridLayer, int linkLayer );
	inline void SetModule( Module* m ) { fCurrentModule = m; }
   
  static inline FrameLink* GetObject(const char* name) { return (FrameLink*) fObjectList.GetObjectByName(name); }
  
  virtual void DynamicRelink();

  static inline FrameLink* GetByModule( Module* m, int& fl_index ) {
		for( Pix p = fObjectList.first(); p; fObjectList.next(p) ) {
			FrameLink& fl = (FrameLink&) fObjectList(p);
			if( m == fl.fCurrentModule) { fl_index = fObjectList.index(p); return &fl; }
		} 
		fl_index = -1; 
		return NULL; 
	}
  
  static inline FrameLink* New(const char* name) { 
		FrameLink* n = GetObject(name);
		if(n==NULL) { n = new FrameLink(name); fObjectList.append(*n);   }
		return n;
	} 
	int CreateModifiedElevationMap(int mapIndex=1);
	int DynamicRelink(CVariable* v); 
	int AdjustMapDownslope( TCell* c, TLayer* l, PixArray& pa, int mapIndex=1, TMap* newMap=NULL, int firstRun = 1 );
	int AddBoundaryPoints( TLayer* l, PixArray* pa = NULL  );
	int RegisterLink( int r0, int c0, int r1, int c1, TLayer* l );
	inline void SetLinkLayer(int ll ) { fLinkLayer = ll; }	
	int MakeLink( TCell* c0, TCell* c1, TLayer* l );   // create link from p0 to p1
		
public:

  static int Config( TConfigData& config, Module* m );


};


#endif
