//----------------------------------------------------------------------------------------
//	RunOff.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __RunOff__
#define __RunOff__ 
 
#include "SSVariable.h"
#include "SSModule.h"

class RunOff {

	enum ERunOffInfo { kPointVecGenerated, kSetup };
	static void CreatePointVec();
	 
public:

protected:

  static TSpatialAuxVariable fFlux;
  static TSpatialVariable* fStudyArea;
  static TSpatialVariable* fForcingFunction;
  static TSpatialVariable* fOutput;
  static TVariable* fCellSize;
  static PixVec fPointVec;
  static ByteBuffer fCommBuff;
  static byte fInfo[8];

  static float fAlpha[10];
	static int fNAlpha;
  static float fBeta[10];
	static int fNBeta;
	static TModule* fCurrentModule;
  static DistributedGrid* fCurrentGrid;
  static int FSetup;
  static int FOutFlowIndex0;
  static int FOutFlowIndex1;
  static int FForcingIndex;
  static int FOutputIndex;

public:

  static int Config(TConfigData& config);
  static void Setup(  TSpatialVariable& v );
  static void Wrapup();
  
  static void Partial( TSpatialVariable& AvailWater, TTemporalVariable& fluxDistance ); // inputs are volumes or heads
	static void PartialHead( TSpatialVariable& AvailWater );
  static void Full(TSpatialVariable& AvailWater, TTemporalVariable& fluxDistance ); // inputs are volumes or heads
  static void FullEquilHead1( TSpatialVariable& AvailWater, TSpatialVariable& SurfaceElev );  // inputs are heads
  static void FullEquilHead( TSpatialVariable& AvailWater, TSpatialVariable& SurfaceElev, TTemporalVariable& fluxDistance );  // inputs are heads
  static void FullEquilVol( TSpatialVariable& AvailWater, TSpatialVariable& SurfaceElev, TTemporalVariable& fluxDistance );  // inputs are volumes
	static void GWHead1( TSpatialVariable& GWater, TSpatialVariable& GWHead, TSpatialVariable& Porosity, TSpatialVariable& FluxRate );
	static void GWHead2( TSpatialVariable& GWater,  TSpatialVariable& Porosity);
	static void GWHead3( TSpatialVariable& GWater,  TSpatialVariable& Porosity);
};


#endif
