#ifndef __Model__
#define __Model__
  
#include "Globals.h"
#include "MML_Model.h"
#include "MultiGrid.h"
#include "Frame.h"
#include "ConfigObjects.h"
#include "SSComm.h"

typedef class TVariable TVariable;
typedef class TModule TModule;

//----------------------------------------------------------------------------------------
// TModel
//----------------------------------------------------------------------------------------

const int kMaxIvars = 256;

class TModel : public Model
{
protected:

   TVariable* fIVars[kMaxIvars];
   int fNIVars;

	int WriteSetupFile( char* cnfgExtension );
	inline virtual  MFrame* GetFrame() { return new TMultiFrame(fMaxGhost); }
	 	
public:

  // Construction/Destruction;
  TModel() : Model("Model") { fNIVars=0; }
  		
   void Startup();
   void Shutdown();
   
   void InitArrays(); 
				
  // Commands;

  inline static TModel& I() { 
    if(fInstance == NULL) {
      fInstance = new TModel;
      fInstance->Init();
    }
    return (TModel&) *fInstance; 
  } 
   void Run();
   virtual void QueryInterface(const char* moduleName, const char* variableName = NULL) { DataServer(moduleName,variableName); }
   virtual void QueryInterface();


   int Config(TConfigData& cd);
   virtual int ConfigExternal(TConfigData& cd, Module* m);
   int InitSimulation();
   void CloseSimulation(int iSim);
   int Open();
   void Close();
   void SetupFrames();
   void SetupVariables();
   void PostEvents();
   void Reset();
   void InitializeEvents();   
   float GetValue(char* moduleName, char* varName, Pix p=NULL);
   TVariable* GetVariable(char* moduleName, char* varName);
   long int  ReadMapFromHDF( TMap* m, const char* dsetName,  const char* variableName, int index=0 ); 
   float GetValue(char* moduleName, char* varName, unsigned int row, unsigned int col, int layer_index=-1);
   float GetValue(byte ivar, unsigned int row, unsigned int col, int layer_index=-1);
   void SetValue(byte ivar, Pix p, float value);
   void SetValue(byte ivar, unsigned int row, unsigned int col, float value, int layer_index=-1);
   float GetValue(byte ivar, Pix p );
   TVariable* GetVariable( CString& name );
   void PostExtVarUpdateCommands();

   Module* GetModule( const CString& name, Bool create = True );
   inline TVariable* IVar(byte i) { return fIVars[i]; }
   int addStateVariable( const Variable& var );
   inline TVariable* AddIVar( byte i, TVariable* var ) { TVariable* tmp = fIVars[i]; fIVars[i]=var; return tmp; }
   virtual Module* CreateNewModule( const CString& name );
   inline int MemoryOp() { return fMemoryOp; }
   inline MultiGrid* Grid() { return ((TMultiFrame&)Frame()).Grid(); }
   inline TLayer* getGridLayer( TCell* c ) { 
		 int layer_index = (c) ? c->GetObjInfo( TCell::kLayerIndex ) : 0;
		 return (c) ? ( Grid() ? Grid()->getCellLayer( layer_index ) : (TLayer*) NULL ) : (TLayer*) NULL; 
	 }
   inline Region2& LocalRegion( int& cell_layer_index, int iproc = gIProc ) { return *( Grid() ->GetPartition(cell_layer_index)->region(iproc)); }
};


#endif
