//----------------------------------------------------------------------------------------
// Module.cc
// Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------
  
#include "SSModule.h"
#include "CVariable.h"
#include "SSModel.h"
#include "HDFMgr.h"
#include "TPipe.h"
#include "FrameLink.h"

int gCheckUpdateSteps = 0;
int gCD = 0;
int gFluxErr = 0;

void initArray(float* fArray, int size, float val);
void copyArray(float* fArray0, float* fArray1, int size);

//========================================================================================
  // 				CLASS TModule
  //========================================================================================
  
TModule::TModule(const char* name) : Module(name)
{
  fNPoints = 0; 
  fCurrentPoint = 0;
  memset(fMInfo,0,8);
  memset(fCD,0,8);
}

void TModule::NewModule(int isExternal, TModule* parent )
{
  fMInfo[ kisExternal ] = isExternal; 
  if( parent == NULL ) { fMInfo[ kisGlobal ] = True; }
  fSuper = parent;
}
/*    
void TModule::SetupFrame() {

	if( fFrame == NULL ) {  
		fFrame = GetFrame(); 
	}
  TFrame* f = (TFrame*) fFrame;
  if( f->Type() == DGrid::kUndefined ) {
    if( fSuper == NULL ) { 
      f->SetType( DGrid::kScalar );
      f->Setup();
    } 
    else if( fSuper->Frame().GetCInfo(TFrame::kisSetup) == 0 ) {
      gFatal( "Frame Setup Error: Parent not setup.");
    }
    else {
      if( fFrame != NULL) delete fFrame;
      fFrame = &(fSuper->Frame()); 
      f =  (TFrame*) fFrame;
    }
  } else {
    f->Setup();
  }
  fNPoints = f->Size();

  for( Pix p = fModuleList.first(); p; fModuleList.next(p) ) {
    TModule& mod = (TModule&) fModuleList(p);
    mod.SetupFrame();
  }
}
*/
void TModule::PostEvents() {
	PostEventsByType(TEvent::kImport);
	PostEventsByType(TEvent::kFirstUpdate);
	PostEventsByType(TEvent::kIntegrate);
	PostEventsByType(TEvent::kFinalUpdate);
	PostEventsByType(TEvent::kInit);
	TModel::I().DumpEventList();
}

void TModule::SetupVariables() {   
  for( Pix p = fVarList.first(); p; fVarList.next(p) ) {
    TVariable& aVar = (TVariable&) fVarList(p);
    if( aVar.GetCInfo( Variable::kDebug ) == kNoConfig ) {
			aVar.SetCInfo( Variable::kDebug, GetCInfo(Module::kDebug) );
		}
    aVar.SetupInternals();
  }
}

int  TModule::Config( TConfigData& cd) {
  const CString& cmd = cd.Cmd();
  TModel::I().CurrentMod(this);

  if(gDebug) { 
    sprintf(gMsgStr,"Reading Module Config for %s: Nargs = %d, CMD = %s",
	    Name(), cd.NArgs(), cmd.chars() );	
    gPrintLog();  
  }
  int iarg; float farg;
  
  if( cmd == "cd" )  {
    if( cd.IntArg(0,iarg) > 0 ) fCD[0] = iarg;
    if( cd.IntArg(1,iarg) > 0 ) fCD[1] = iarg;
    return 1;
  } else {
    return Module::Config(cd); 
  }
}

void TModule::SetupDefaults() {
	SetDefaultLayers(fActivationLayer,fLinkLayer); 
	if( GetCInfo(Module::kDebug) == kNoConfig ) { SetCInfo(Module::kDebug,gDebug); }
}

void TModule::AllocMemory() {

  for( Pix p = fVarList.first(); p; fVarList.next(p) ) {
    TVariable& aVar = (TVariable&) fVarList(p);
    aVar.Allocate();
  }
}

void TModule::SetDefaultLayers( int& activationLayer, int& linkLayer ) {
	if( fActivationLayer == -1 ) {
		if( fSuper ) {  
		  ((TModule*)fSuper)->SetDefaultLayers( activationLayer, linkLayer ); 
		  SetLayerConfig( ((TModule*)fSuper)->getLayerConfig() ); 
		} else { 
		  SetLayerConfig( TModel::I().SetDefaultLayers(activationLayer,activationLayer) ); 
		}
	} else {
		activationLayer = fActivationLayer;
		linkLayer = fLinkLayer;
	}
}

void TModule::Reset() {
  for( Pix p = fVarList.first(); p; fVarList.next(p) ) {
    TVariable& aVar = (TVariable&) fVarList(p);
    aVar.Reset();
  }
}


void TModule::PrintUpdate(char* type) {
  if( GetCInfo(Module::kDebug) ) {
    sprintf(gMsgStr,"UPDATE %s for Module %s: TIME = %f",type,(const char*)fName,gTime()); 
    gPrintLog();
    if( GetCInfo(Module::kDebug) > 2 ) gPrintScreen();
  } 
}

int  TModule::ConfigExternal( TConfigData& cd, Module* m ) {
  const CString& cmd = cd.Cmd();
	if( cd.Name() == "FrameLink" ) {  return FrameLink::Config(cd,m); }
  else return Module::ConfigExternal(cd,m);
}


//----------------------------------------------------------------------------------------
//				TModule::AddSubModule:
//----------------------------------------------------------------------------------------
  
  
Module* TModule :: AddSubModule( const char* module_name, Bool create )
{
  TModule* thisModule = (TModule*) TModel::I().GetModule(module_name);

  if( thisModule == NULL && create ) {
    thisModule = new TModule(module_name);						// Allocate a new module object;
  }
  
  if(thisModule != NULL) {
	AddSubModule(thisModule);
  }
  
  return thisModule;
  
} // TModule::CreateSubModule

Variable* TModule :: CreateNewVariable( const CString& name, Variable* template_var ) { 
  Variable* newVariable = (Variable*) fVarList.GetObjectByName(name);

  if(newVariable == NULL) { 
    Variable::EType type = Variable::kAux;
    if(template_var) { type = (Variable::EType) template_var->GetCInfo(Variable::kType); }

    switch(type) {
    case  Variable::kState: {
      CStateVariable* var = new CStateVariable(name);
      var->SSInit(this);
      newVariable = var;
      } break;
    case  Variable::kFlux: {
      CFluxVariable* var = new CFluxVariable(name);
      var->SSInit(this);
      newVariable = var;
      } break;
    default: {
      CAuxVariable* var = new CAuxVariable(name);
      var->SSInit(this);
      newVariable = var;
      } break;
    };
  }
  return newVariable;
}

ByteGrid* TModule :: RegionMap() { return ((TMultiFrame&)TModel::I().Frame()).RegionMap(); }


 
