//----------------------------------------------------------------------------------------
  //	Module.h
  //	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
  //	Change History:
  //----------------------------------------------------------------------------------------
  
  
#ifndef __Module__
#define __Module__

#include "CnfgProcessor.h"  
#include "MML_Frame.h" 
#include "ByteGrid.h" 
#include "Environ.h" 
#include "MML_Module.h" 
#include "PixPlex.h" 

extern float DT;

void GlobalInitVars();
typedef class TVariable TVariable;
typedef class LayerConfig LayerConfig;

//----------------------------------------------------------------------------------------;
//						TModule;
//----------------------------------------------------------------------------------------;
 
class  TModule : public Module {

  protected:
    
    Pix fCurrentPoint;
    byte fMInfo[8];
    byte fCD[8];
    PixXPStack fSpatialArrays;
    
    int fNPoints;
    
   public:

    enum EInfo { kisExternal, kisGlobal }; 
    
    TModule( const char* name );
    byte GetMInfo( EInfo index ) { return fMInfo[index]; }
    byte SetMInfo( EInfo index, byte val ) { return fMInfo[index] = val; }

    virtual void NewModule( int isExternal, TModule* parent );
    
    void  SetDefaultLayers( int& activationLayer, int& linkLayer );
    
    void PostEvents();
    void SetupVariables(); 
    inline Pix CurrentPoint( Pix p=0 ) { return (p) ? fCurrentPoint=p : fCurrentPoint; }
		inline ByteGrid* RegionMap() ;
		
    void ReadCnfg();
    virtual int Config(TConfigData& config); 	
    virtual void AllocMemory();
    virtual void SetupDefaults();
    void Reset();
    void PrintUpdate(char* type);

    virtual Variable* CreateNewVariable( const CString& name,  Variable* template_var = NULL );
    virtual Module* AddSubModule(const char* module_name, Bool create = True );
	inline TModule* AddSubModule( TModule* m ) { return (TModule*) Module::AddSubModule( m ); }

    virtual int MakeConnections() { return 0;}
    virtual int SetupEvents() { return 0;} 
    int  ConfigExternal( TConfigData& cd, Module* m ); 
    PixXPStack&  SpatialArrays() { return fSpatialArrays; }                          
};

#endif


