// ------------------------------------------------------------------------
// SSTcl.cc
// fv Jul 30 1997
// TCL support for SME driver
// ------------------------------------------------------------------------

#ifdef USE_TCL
#ifndef _SSTCL_H
#define _SSTCL_H

#include <tcl.h>

typedef struct {
  char* command;
  int  (*func)(Tcl_Interp*, void*);
} external_command_table;

typedef struct {
  char* command;
  char* command_name;
} external_config_table;

extern Tcl_Interp* SSTcl_Interp();

int SMETcl_error(Tcl_Interp* i, const char* format, ...);
int SME_Callback(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SME_ModuleCallback(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SME_VariableCallback(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SMETcl_step(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SMETcl_run(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SMETcl_execute(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SMETcl_restart(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SMETcl_elapsed(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SMETcl_dt(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SMETcl_t0(ClientData d, Tcl_Interp* i, int argc, char* argv[]);
int SME_Init(Tcl_Interp* interp);
void SMETcl_Exit(ClientData clientData);
int SME_extmodule_callback(ClientData d, Tcl_Interp* i, 
			   int argc, char* argv[]);

/* to install external modules: have a pointer to a data structure identifying
 the object (can be NULL if it's only a collection of commands); prepare
 an array of command_table items (see SSTcl.h) to define the module commands
 along with functions to process them. The functions will be passed the
 module pointer and all the arguments supplied (the whole command line
 including the module name and the command)
 */

int SMETcl_install_module (char* name, void* module,
			   external_command_table* commands, 
			   external_config_table* config);

#endif
#endif


