#ifndef __Series__
#define __Series__

#include "TSeries.h"
#include "TObjects.h"

enum SeriesMsgTags { kST_Read, kST_Move };
const int kSeriesInfoSize = 100;

//----------------------------------------------------------------------------------------
// TDistributedSeries
//----------------------------------------------------------------------------------------

class TDistributedSeries : public TTemporalSeries {

  private:

   public:
  
  TDistributedSeries() {;} 
  TDistributedSeries( char* name )  { fDSetName = name;  }  
  TDistributedSeries( CString name )   { fDSetName = name; }  

  inline float TS() { return fTS; }
  void Read( int nameIndex = -1, int tIndex = 1, int deleteOldData = True, int rootProc = -1 );
  inline TDistributedSeries& operator=( TDistributedSeries& s )  { 
    fTS = s.fTS;  
    TSliceSeries::operator= ( (TSliceSeries&) s );
    return *this; }
  inline void Copy( TDistributedSeries& s ) { TSliceSeries::operator= ( (TSliceSeries&) s ); fTS = s.fTS; }
  void Write( char* info = NULL );
  void Condense( int ostep, char mode, int ostart ); 
  int GetSeriesIndex() { return fSeriesIndex; }
  int GetReadIndex() { return fReadIndex; }

  void AddLocal( float time, float value, int root=0 );
};

//----------------------------------------------------------------------------------------
// TLocalSeries
//----------------------------------------------------------------------------------------

class TLocalSeries : public TTemporalSeries {

  private:

  int fOwner;

  public:
  
  TLocalSeries( int owner = -1 ) { fOwner = owner; }
  TLocalSeries( char* name, int owner = -1 )  { SeriesName(name); fOwner = owner; }  
  TLocalSeries( CString name, int owner = -1 )   { SeriesName(name); fOwner = owner; } 
  void SetOwner (int owner ) { if(owner != fOwner) Move(fOwner,owner); fOwner = owner; } 
  int GetOwner () { return fOwner; } 

  inline float TS() { return fTS; }
  int AddData( float* data, int np, float t0, float ts, int addProc=0, int clearOldData = True );

  int Read( int nameIndex = -1, int tIndex = 1, char* info=NULL, int deleteOldData = True, int rootProc=-1 );
  inline TLocalSeries& operator=( TLocalSeries& s ) { 
    fTS = s.fTS;
    TSliceSeries::operator= ( s );
    return *this;
  }
  inline void Copy( TLocalSeries& s ) { TSliceSeries::operator= ( (TSliceSeries&) s ); fTS = s.fTS; }
  void Write( char* info = NULL, int rootProc=-1 ); 
  int GetIndex() { return fIndex; }
  void Condense(int cstep, char mode, int cstart=0 );

  int Move( int srcProc, int destProc, char* info=NULL, int deleteOld=True );
  inline int Copy( int srcProc, int destProc, char* info=NULL ) { return Move( srcProc, destProc, info, False ); } 
  void MakeGhost( int ghostProc ); 
};

//----------------------------------------------------------------------------------------
// TPtSeries
//----------------------------------------------------------------------------------------

class TPtSeries : public TLocalSeries {

  friend class TPtSeriesList;	
  Point2 fPoint;
  float fCoords[2];
  int fLayerIndex;

public:
  	
  TPtSeries(CString name, int owner = -1 );
  TPtSeries(char* name, int owner = -1 );
  TPtSeries(int owner = -1);
//  TPtSeries(CString name, Point2 point);
  ~TPtSeries ();
 
  inline void SetPoint( Point2& point  ) {
    fPoint = point;
    SetSeriesInfo(kTS_SpatialReferenced,0);
  }  
  inline void SetPoint( float f0, float f1  ) {
    fCoords[0] = f0; fCoords[1] = f1; 
    SetSeriesInfo(kTS_SpatialReferenced,1);
  }  
  inline TPtSeries& operator=( TPtSeries& s ) { 
    fPoint = s.fPoint;
    fCoords[0] = s.fCoords[0]; fCoords[1] = s.fCoords[1];
    TLocalSeries::operator= ( s );
    return *this;
  }
  int Read ( int index, int tIndex, int clearOldData, int rootProc = -1 );
  inline Point2& Point() { return fPoint; }
  inline float Coord(int index) { return fCoords[index]; }
};

//----------------------------------------------------------------------------------------
// TPtSeriesList
//----------------------------------------------------------------------------------------

class TPtSeriesList {

  private:
 
	int fReadIndex;
	int fLayerIndex;
	TOrderedObjectDLList fList;
	CString fPointMapName;
	signed char fInterpolate;
	signed char fFormat;
	signed char fUseReadIndex;
	signed char fDoneFirstRead;
	TMap* fSiteMap;
	int fYear;
	int ReadHeaderInfo(FILE* cfile, int format=0, const char* root_path=NULL );

  public:
	CString fSeriesName;
	CPathString fPTSDataPath;
	CPathString fDefaultDataPath;
	int fNptTS;
	float fTS;
	float fT0, fT1;				// start and end times of TImeseries;

	inline int Size() { return fNptTS; }
	inline float DT() { return fTS; }
	TPtSeriesList(char* name);
	TPtSeriesList();
	~TPtSeriesList();
	void Reset();
	inline void SeriesName(const char* name) {  fSeriesName = name; }
	float GetInterpolatedValue( TCell* c, TLayer* l,  float time, int print_log =0 );  
	int Read( int format, int deleteOld = True); 
	void CreatePointMap( MultiCoverage& cov, float time );
	int Import( const CPathString& dataPath, char* fileName, int format );
	int ReadHDF( int deleteOld );
};

#endif
