#ifndef __SpaceSim__
#define __SpaceSim__

#include <stdarg.h>
#include <stdio.h>

#include <Globals.h>

enum ECnfgLevel { kSS_Model, kSS_Module, kSS_Variable, kSS_Command, kSS_Dependency, kSS_Parameter, kSS_External, kSS_HDF };
enum EStepMode { kSS_EventS, kSS_CommandS, kSS_UpdateD };

int SS_Init (int argc, char *argv[]);
int SS_Update ( float end_time, int useTimer=False);    /* Run Simulation until sim time == end_time  */
int SS_Run ( int useTimer = False);                   /* Run full Simulation */
int SS_RunMPE( int max_runs );
float SS_Step ( EStepMode sm = kSS_EventS);     /* Execute One Event (Command), return time */
int SS_DumpToDebug();
int SS_Open();
void SS_Close ();
void SS_Exit( int doExit = 1 );
float SS_GetValue(int index, int row, int col);
void SS_SetValue(int index, int row, int col, float value);
int SS_error_index();

int SS_SetCurrentModule(const char* name);            /* Set Current Module */  
int SS_SetCurrentVariable(const char* name);          /* Set Current Variable */
int SS_SetCurrentCommand(const char* name);          /* Set Current Command */
int SS_Config( ECnfgLevel level, char* cmd, ... );    /* Set Config Data for Current Model/Module/Variable */
int SS_SetCurrentVariable(void* v);
int SS_ConfigArgs( ECnfgLevel level, int nargs );
int SS_RegisterConfigData(ECnfgLevel level);
const float* SS_GetCurrentData( int* size );
const int SS_SetCurrentData(float* data, int layOut, int size );
const char* SS_ExecuteCommand (char* cmdList, int* cmd_code=NULL, int * repeat=NULL, void* interp=NULL, int onProc = -1 );  // onProc = -1 executes on all processors
const char* SS_ExecuteTelnetCommand (char* cmdList, int* cmd_code, int * repeat=NULL, void* interp=NULL );
int SS_UseJavaSocket () ;
const char* SS_ExecuteJavaCommand ( char* cmdList, int useSocket = 1, void* interp=NULL );
void SS_MakeList( ECnfgLevel level, const char* hint );
int SS_MakeHDFList(char mode);
void SS_MakeBreakList();
int SS_Proc();
int SS_UseTcl();
const char* SS_TclFile();
#endif

