#if __GNUG__ >= 2
#  pragma implementation
#endif

#include "SpaceLib.h"

// enum EReduceOp { kR_Max, kR_Min, kR_Sum, kR_Ave };

void Space::SMax( CVariable& result, CVariable& input ) {
	float value = input.Cov().Reduce ( kR_Max, -1, NULL ); 
	result.Set(value); 
}

void Space::SMax( CVariable& result, CVariable& input, CVariable& mask ){
	float value = input.Cov().Reduce ( kR_Max, -1, mask.Cov() ); 
	result.Set(value); 
}

void Space::SMin( CVariable& result, CVariable& input ) {
	float value = input.Cov().Reduce ( kR_Min, -1, NULL ); 
	result.Set(value); 
}

void Space::SMin( CVariable& result, CVariable& input, CVariable& mask ){
	float value = input.Cov().Reduce ( kR_Min, -1, mask.Cov()  ); 
	result.Set(value); 
}

void Space::SSum( CVariable& result, CVariable& input ) {
	float value = input.Cov().Reduce ( kR_Sum, -1, NULL ); 
	result.Set(value); 
}

void Space::SSum( CVariable& result, CVariable& input, CVariable& mask ){
	float value = input.Cov().Reduce ( kR_Sum, -1, mask.Cov()  ); 
	result.Set(value); 
}

void Space::SSumDist( CVariable& result, CVariable& input, CVariable& mask ){
	float* values = input.Cov().MultiReduce ( kR_Sum, -1, mask.Cov() );
	result.Cov().SpreadValues( values, mask.Cov() ); 
	delete[] values;
}

void Space::SAve( CVariable& result, CVariable& input ) {
	float value = input.Cov().Reduce ( kR_Ave, -1, NULL ); 
	result.Set(value); 
}

void Space::SAve( CVariable& result, CVariable& input, CVariable& mask ){
	float value = input.Cov().Reduce ( kR_Ave, -1, mask.Cov()  ); 
	result.Set(value); 
}

void Space::PD0_CentralDiff( CVariable& result, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, WW ); 
			Pix rp1 = grid.NeighborPix( p, EE );
			if( ( rp0 != 0 )  && ( rp1 != 0 ) ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = (f1 - f0)/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::PD1_CentralDiff( CVariable& result, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, SS ); 
			Pix rp1 = grid.NeighborPix( p, NN );
			if( ( rp0 != 0 )  && ( rp1 != 0 ) ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = ( f1 - f0 )/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::Convection0_CentralDiff( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, WW ); 
			Pix rp1 = grid.NeighborPix( p, EE );
			if( ( rp0 != 0 )  && ( rp1 != 0 ) ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = multiplier(pt)*( f1 - f0 )/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::Convection1_CentralDiff( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, SS ); 
			Pix rp1 = grid.NeighborPix( p, NN );
			if( ( rp0 != 0 )  && ( rp1 != 0 ) ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = multiplier(pt)*( f1 - f0 )/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::Convection1_Quick( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, SS ); 
			Pix rp00 = grid.NeighborPix( rp0, SS ); 
			Pix rp1 = grid.NeighborPix( p, NN );
			Pix rp11 = grid.NeighborPix( rp1, NN );
			int b0 =  ( rp0 != 0 )  && ( rp1 != 0 );
			if( ( rp00 != 0 )  && ( rp11 != 0 ) && b0 ) {
				const float f = differential( grid.GetPoint(p) ); 
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				const float f00 = differential( grid.GetPoint(rp00) ); 
				const float f11 = differential( grid.GetPoint(rp11) ); 
				result(pt) = multiplier(pt)*( -f11 + 10*(f1-f0) + f00 )/(16*l) + fabs( multiplier(pt))*( f11 - 4*f1 + 6*f - 4*f0 + 4*f00 )/(16*l);
			} else if( b0 ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = multiplier(pt)*( f1 - f0 )/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::Convection0_Quick( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, WW ); 
			Pix rp00 = grid.NeighborPix( rp0, WW ); 
			Pix rp1 = grid.NeighborPix( p, EE );
			Pix rp11 = grid.NeighborPix( rp1, EE );
			int b0 =  ( rp0 != 0 )  && ( rp1 != 0 );
			if( ( rp00 != 0 )  && ( rp11 != 0 ) && b0 ) {
				const float f = differential( grid.GetPoint(p) ); 
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				const float f00 = differential( grid.GetPoint(rp00) ); 
				const float f11 = differential( grid.GetPoint(rp11) ); 
				result(pt) = multiplier(pt)*( -f11 + 10*(f1-f0) + f00 )/(16*l) + fabs( multiplier(pt))*( f11 - 4*f1 + 6*f - 4*f0 + 4*f00 )/(16*l);
			} else if( b0 ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = multiplier(pt)*( f1 - f0 )/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::Convection0_Upwind( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, WW ); 
			Pix rp00 = grid.NeighborPix( rp0, WW ); 
			Pix rp1 = grid.NeighborPix( p, EE );
			Pix rp11 = grid.NeighborPix( rp1, EE );
			int b0 =  ( rp0 != 0 )  && ( rp1 != 0 );
			if( ( rp00 != 0 )  && ( rp11 != 0 ) && b0 ) {
				const float f = differential( grid.GetPoint(p) ); 
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				const float f00 = differential( grid.GetPoint(rp00) ); 
				const float f11 = differential( grid.GetPoint(rp11) ); 
				result(pt) = multiplier(pt)*( -f11 + 8*(f1-f0) + f00 )/(12*l) + fabs( multiplier(pt))*( f11 - 4*f1 + 6*f - 4*f0 + 4*f00 )/(16*l);
			} else if( b0 ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = multiplier(pt)*( f1 - f0 )/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::Convection1_Upwind( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	float l = cell_length.Value();
	for( Pix p = grid.first(); p; grid.next(p) ) {
			const OrderedPoint& pt = grid.GetPoint(p);
			Pix rp0 = grid.NeighborPix( p, SS ); 
			Pix rp00 = grid.NeighborPix( rp0, SS ); 
			Pix rp1 = grid.NeighborPix( p, NN );
			Pix rp11 = grid.NeighborPix( rp1, NN );
			int b0 =  ( rp0 != 0 )  && ( rp1 != 0 );
			if( ( rp00 != 0 )  && ( rp11 != 0 ) && b0 ) {
				const float f = differential( grid.GetPoint(p) ); 
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				const float f00 = differential( grid.GetPoint(rp00) ); 
				const float f11 = differential( grid.GetPoint(rp11) ); 
				result(pt) = multiplier(pt)*( -f11 + 8*(f1-f0) + f00 )/(12*l) + fabs( multiplier(pt))*( f11 - 4*f1 + 6*f - 4*f0 + 4*f00 )/(16*l);
			} else if( b0 ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				result(pt) = multiplier(pt)*( f1 - f0 )/(2*l);
			} else {
				result(pt) = 0;
			}
	}
}

void Space::Convection1_UpwindOp( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	result.Set(FLT_MAX); 
	register float l = cell_length.Value();
	register float cf0, cf1, cf2, cf3, cf4;
	for( Pix p = grid.first(); p; grid.next(p) ) {
		const OrderedPoint& pt = grid.GetPoint(p);
		float& r = result(pt);
		float& m = multiplier(pt);
		if( r == FLT_MAX ) {
			Pix rp0 = grid.NeighborPix( p, SS ); 
			Pix rp00 = grid.NeighborPix( rp0, SS ); 
			Pix rp1 = grid.NeighborPix( p, NN );
			Pix rp11 = grid.NeighborPix( rp1, NN );
			int b0 =  ( rp0 != 0 )  && ( rp1 != 0 );
			if( ( rp00 != 0 )  && ( rp11 != 0 ) && b0 ) {
				cf0 = differential( grid.GetPoint(rp00) ); 
				cf1 = differential( grid.GetPoint(rp0) ); 
				cf2 = differential( grid.GetPoint(p) ); 
				cf3 = differential( grid.GetPoint(rp1) ); 
				cf4 = differential( grid.GetPoint(rp11) ); 
				r = m*( -cf4 + 8*(cf3-cf1) + cf0 )/(12*l) + fabs( m )*( cf4 - 4*cf3 + 6*cf2 - 4*cf1 + 4*cf0 )/(16*l);
				Pix p0  = p;
				while( (rp00 = grid.NeighborPix( rp00, SS )) != 0 ) {
					p0 = grid.NeighborPix( p0, SS );
					if( (r = result( grid.GetPoint(p0))) != FLT_MAX ) {				 
						cf4 = cf3; cf3 = cf2; cf2 = cf1;  cf1 = cf0; 
						cf0 = differential( grid.GetPoint(rp00) ); 
						float m = multiplier( grid.GetPoint(p0) ); 
						r = m *( -cf4 + 8*(cf3-cf1) + cf0 )/(12*l) + fabs( m )*( cf4 - 4*cf3 + 6*cf2 - 4*cf1 + 4*cf0 )/(16*l);
					} else break;
				}
			} else if( b0 ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				r = m*( cf3 - cf1 )/(2*l);
			} else {
				r = 0;
			}
		}
	}
}

void Space::Convection0_UpwindOp( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  ) {
	DistributedGrid& grid = differential.Grid();
	result.Set(FLT_MAX); 
	register float l = cell_length.Value();
	register float cf0, cf1, cf2, cf3, cf4;
	for( Pix p = grid.first(); p; grid.next(p) ) {
		const OrderedPoint& pt = grid.GetPoint(p);
		float& r = result(pt);
		float& m = multiplier(pt);
		if( r == FLT_MAX ) {
			Pix rp0 = grid.NeighborPix( p, WW ); 
			Pix rp00 = grid.NeighborPix( rp0, WW ); 
			Pix rp1 = grid.NeighborPix( p, EE );
			Pix rp11 = grid.NeighborPix( rp1, EE );
			int b0 =  ( rp0 != 0 )  && ( rp1 != 0 );
			if( ( rp00 != 0 )  && ( rp11 != 0 ) && b0 ) {
				cf0 = differential( grid.GetPoint(rp00) ); 
				cf1 = differential( grid.GetPoint(rp0) ); 
				cf2 = differential( grid.GetPoint(p) ); 
				cf3 = differential( grid.GetPoint(rp1) ); 
				cf4 = differential( grid.GetPoint(rp11) ); 
				r = m*( -cf4 + 8*(cf3-cf1) + cf0 )/(12*l) + fabs( m )*( cf4 - 4*cf3 + 6*cf2 - 4*cf1 + 4*cf0 )/(16*l);
				Pix p0  = p;
				while( (rp00 = grid.NeighborPix( rp00, SS )) != 0 ) {
					p0 = grid.NeighborPix( p0, SS );
					if( (r = result( grid.GetPoint(p0))) != FLT_MAX ) {				 
						cf4 = cf3; cf3 = cf2; cf2 = cf1;  cf1 = cf0; 
						cf0 = differential( grid.GetPoint(rp00) ); 
						float m = multiplier( grid.GetPoint(p0) ); 
						r = m *( -cf4 + 8*(cf3-cf1) + cf0 )/(12*l) + fabs( m )*( cf4 - 4*cf3 + 6*cf2 - 4*cf1 + 4*cf0 )/(16*l);
					} else break;
				}
			} else if( b0 ) {
				const float f0 = differential( grid.GetPoint(rp0) ); 
				const float f1 = differential( grid.GetPoint(rp1) ); 
				r = m*( cf3 - cf1 )/(2*l);
			} else {
				r = 0;
			}
		}
	}
}

