//-*-Mode: C++;-*-
#ifndef _SpaceLib_h_
#define _SpaceLib_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

//----------------------------------------------------------------------------------------
// SpaceSim/_SpaceLib.h
// Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------

#include "CVariable.h"

class Space {

public:
  
  static void SMax( CVariable& result, CVariable& input );
  static void SMax( CVariable& result, CVariable& input, CVariable& mask  );
  static void SMaxP( CVariable& result, CVariable& input ) {;}
  static void SMaxP( CVariable& result, CVariable& input, CVariable& mask  ) {;}
  
  static void SMin( CVariable& result, CVariable& input );
  static void SMin( CVariable& result, CVariable& input, CVariable& mask  );
  static void SMinP( CVariable& result, CVariable& input ) {;}
  static void SMinP( CVariable& result, CVariable& input, CVariable& mask  ) {;}
  
  static void SSum( CVariable& result, CVariable& input );
  static void SSum( CVariable& result, CVariable& input, CVariable& mask  );
  static void SSumDist( CVariable& result, CVariable& input, CVariable& mask  );
  static void SSumP( CVariable& result, CVariable& input ) {;}
  static void SSumP( CVariable& result, CVariable& input, CVariable& mask  ) {;}
  
  static void SAve( CVariable& result, CVariable& input );
  static void SAve( CVariable& result, CVariable& input, CVariable& mask  );
  static void SAveP( CVariable& result, CVariable& input ) {;}
  static void SAveP( CVariable& result, CVariable& input, CVariable& mask  ) {;}

  static void PD0_CentralDiff( CVariable& result, CVariable& operand, CVariable& cell_length  );   
  static void PD1_CentralDiff( CVariable& result, CVariable& operand, CVariable& cell_length  );   
  static void Convection0_CentralDiff( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
  static void Convection1_CentralDiff( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
  static void Convection0_Quick( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
  static void Convection1_Quick( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
  static void Convection0_Upwind( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
  static void Convection1_Upwind( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
  static void Convection0_UpwindOp( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
  static void Convection1_UpwindOp( CVariable& result, CVariable& multiplier, CVariable& differential, CVariable& cell_length  );
};

#endif 
