//----------------------------------------------------------------------------------------
// StellaLib.cp
// Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------

#include "StellaLib.h"
#include "MML_Time.h"
#include "MultiGrid.h"
#include "MML_Model.h"
#include <stdlib.h>
#include <math.h>

#ifndef RAND_MAX 
#define RAND_MAX 2147483659
#endif

float SL::MaxP(float x, float y, float xp, float yp ){
  if( x > y ) return xp;
  else return yp;
}
float SL::MaxP(float x, float y, float z, float xp, float yp, float zp){
  if( x > y ) {
    if(z>x) return zp;
    else return xp;
  }
  else {
    if(z>y) return zp;
    else return yp;
  }
}

float SL::MinP(float x, float y, float xp, float yp ){
  if( x < y ) return xp;
  else return yp;
}

float SL::MinP(float x, float y, float z, float xp, float yp, float zp){
  if( x < y ) {
    if(z<x) return zp;
    else return xp;
  }
  else {
    if(z<y) return zp;
    else return yp;
  }
}

float SL::Max(float x, float y) {
  if( x > y ) return x;
  else return y;
}

float SL::Max(float x, float y, float z) {
  if( x > y ) {
    if(z>x) return z;
    else return x;
  }
  else {
    if(z>y) return z;
    else return y;
  }
}

float SL::Min(float x, float y) {
  if( x < y ) return x;
  else return y;
}

float SL::Min(float x, float y, float z) {
  if( x < y ) {
    if(z<x) return z;
    else return x;
  }
  else {
    if(z<y) return z;
    else return y;
  }
}

float SL::Rand( float  fminVal, float fmaxVal, float seed )
{ 
  float rv, tmp;
  tmp = rand();
  rv = fminVal + (fmaxVal-fminVal)*(tmp/RAND_MAX); 
  return(rv);
}

float SL::Mod( float x, float y) {
  return (float)fmod((double)x, (double)y);
}

float SL::Graph(unsigned char y, float x, int np, float g[][2] )
{
  float s;
  int ig=np/2;

  while(1) {
    if (x <= g[ig][0]) { 
      if(ig>0) ig=ig-1; 
      else return(g[0][1+y]);
    }
    else if (x > g[ig+1][0]) { 
      if(ig<np) ig=ig+1; 
      else return(g[np][1+y]);
    }
    else {
      s = 	(g[ig+1][1+y]-g[ig][1+y])/ (g[ig+1][0]-g[ig][0]);
      return(s * (x-g[ig][0]) + g[ig][1+y]); 
    }
  }
}

double SL::Graph(unsigned char y, double x, int np, double g[][2] )
{
  double s;
  int ig=np/2;

  while(1) {
    if (x <= g[ig][0]) { 
      if(ig>0) ig--; 
      else return(g[0][1+y]);
    }
    else if (x > g[ig+1][0]) {        
      if( ++ig == np ) { return(g[np][1+y]); }
    }
    else {
      s = 	(g[ig+1][1+y]-g[ig][1+y])/ (g[ig+1][0]-g[ig][0]);
      return(s * (x-g[ig][0]) + g[ig][1+y]); 
    }
  }
}

double SL::GraphP(unsigned char y, double x, int np, double g[][2] )
{
  int ig=np/2;
  while(1) {
    if (x < g[ig][0]){ 
      if(ig>0) ig--; 
      else return 0.0;
    } 
    else if (x > g[ig+1][0]) { 
      if( ++ig == np ) { return 0.0; }
    }
    else {
      return 	(g[ig+1][1+y]-g[ig][1+y])/ (g[ig+1][0]-g[ig][0]);
    } 
  }
}

float SL::GraphP(unsigned char y, float x, int np, float g[][2] )
{
  int ig=np/2;
  while(1) {
    if (x < g[ig][0]){ 
      if(ig>0) ig--; 
      else return 0.0;
    }
    else if (x > g[ig+1][0]) { 
      if( ++ig == np ) { return 0.0; }
    } 
    else {
      return 	(g[ig+1][1+y]-g[ig][1+y])/ (g[ig+1][0]-g[ig][0]);
    } 
  }
}

float SL::Normal(float mean, float sd, float seed )
{
  static float rTable[] =
  {.5000,.5398,.5793,.6179,.6554,.6915,.7257,.7580,.7881,.8159,
   .8413,.8643,.8849,.9032,.9192,.9332,.9452,.9554,.9641,.9713,
   .9773,.9821,.9861,.9893,.9918,.9938,.9953,.9965,.9974,.9981,
   .9987,.9990,.9993,.9995,.9997,.9998,.9998,.9999,.9999,1.00} ;

  int table_loc ;
  double rand_num ;
  float sign ;
  float interval = .1 ;
  int n_interval = 40 ;
  float high, low ;
  float return_val = 0.0;

  sign = Rand(0.0, 1.0) ;
  sign = (sign < .5 ? -1 : 1) ;
  rand_num = Rand(.5, 1.0);
  low = rTable[0] ;
  for (table_loc=1; table_loc<n_interval; table_loc++)
    {
      high = rTable[table_loc] ;
      if (high > rand_num)
	{
	  return_val = mean + sd * (sign  * interval * (table_loc - 1 +
							(rand_num-low)/(high-low))) ;
	  return(return_val) ;
	}
      low = high ;
    }
  return(return_val) ;
}

float SL::Pulse(float v, float t0, float ti) {
  int pulse = 0;
  float dt = TTime::DT();
  float t = TTime::Step(0,1) - t0;
  if(ti<0) ti = dt;
  
  if( t >= 0 ) {
    if( Mod(t,ti) < dt  ) pulse = 1;
  }
  if(pulse) return v/dt;
  else return 0.0;
}

float  SL::Ramp( float  slope, float start ) {
  float t = TTime::Current();
	return ( t > start ) ? ( t - start ) *  slope : 0.0;
}

float  SL::Step( float  height, float start ) {
	float t = TTime::Current();
	return ( t >= start ) ? height : 0.0;
}

float  SL::RampP( float  slope, float start, float slopep, float startp ) {
  float t = TTime::Current();
	return ( t > start ) ?  (t-start )*slopep - startp*slope : 0.0;
}

float  SL::RampP( float  slope, float slopep ) {
  float t = TTime::Current();
	return ( t > 0.0 ) ?  t *  slopep : 0.0;
}

float  SL::SinWave( float a, float T ) { 
  float t = TTime::Current();
	return  a*sin((double)((6.2832*t)/T)); 
}

float  SL::SinWaveP( float a, float T, float ap, float Tp ) { 
  float t = TTime::Current();
  if( Tp == 0 ) {
		return  ap*sin((double)((6.2832*t)/T));
	} else {
		return  ap*sin((double)((6.2832*t)/T)) - a*Tp*((6.2832*t)/(T*T))*cos((double)((6.2832*t)/T));
	} 
}
 





