//----------------------------------------------------------------------------------------
// SpaceSim/StellaLib.h
// Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------

#ifndef __StellaLib__
#define __StellaLib__

#include "Utilities.h"

#ifndef PI
const float  PI = 3.14159;
#endif

class SL {

public:

  static inline float  Abs(float x) { return  fabs((double)x); }
  static inline float  Cos(float x) { return  cos((double)x); }
  static inline float  Sin(float x) { return  sin((double)x); }
  static inline float  Tan(float x) { return  tan((double)x); }
  static inline float  Atan(float x) { return  atan((double)x); }
  static inline float  Arctan(float x) { return  atan((double)x); }
  static inline float  Exp(float x) { return  exp((double)x); }
  static inline float  Logn(float x) { return  log((double)x); }
  static inline float  Log10(float x) { return  log10((double)x); }
  static inline float  Int(float x) { return  ((int)(x)); }
  static inline float  Sqrt(float x) { return  pow((double)x,0.5); }
  static inline float  Sum(float x, float y) { return  x+y; }
  static inline float  Sum(float x, float y, float z) { return  x+y+z; }
  static inline float  Sum(float x, float y, float z, float w) { return  x+y+z+w; }
  static inline float  Sum(float x, float y, float z, float w, float u) { return  x+y+z+w+u; }
  static inline float  Sum(float x, float y, float z, float w, float u, float v ) { return  x+y+z+w+u+v; }

  static inline float  AbsP(float x, float xp) { return  (x>0) ? xp : -xp; }
  static inline float  CosP(float x, float xp) { return  -sin((double)x)*xp; }
  static inline float  SinP(float x, float xp) { return  cos((double)x)*xp; }
  static inline float  TanP(float x, float xp) { return  xp/(x*x);  }
  static inline float  AtanP(float x, float xp) { return  0.0; }  // lookup
  static inline float  ArctanP(float x, float xp) { return  0.0; }  // lookup
  static inline float  ExpP(float x, float xp) { return  exp((double)x)*xp; }
  static inline float  LognP(float x, float xp) { return  xp/x; }
  static inline float  SqrtP(float x, float xp) { return  (0.5*xp)/pow((double)x,0.5); }

   
  static inline void Clamp( float* reserve, float* fval, float dt ) {
    float fvol = dt*(*fval);
    if( *reserve < fvol ) { 
      *fval = (*reserve)/dt; 
      *reserve = 0;
    } else {
      *reserve -= fvol;  
    }
  }

  static float  SinWave( float a, float T );
	static float SinWaveP( float a, float T, float ap, float Tp );
  static float Rand( float  fminVal, float fmaxVal, float seed = 0.0 );
  static float Ramp( float  slope, float start = 0.0 );
  static float Step( float  height, float start = 0.0 );
  static float RampP( float  slope, float start, float slopep, float startp );
  static float RampP( float  slope, float slopep );
  static float Mod( float x, float y);
  static double Graph( unsigned char y, double x, int np, double g[][2] );
  static float Graph( unsigned char y, float x, int np, float g[][2] );
  static double GraphP( unsigned char y, double x, int np, double g[][2] );
  static float GraphP( unsigned char y, float x, int np, float g[][2] );
  static float Normal(float mean, float sd, float seed=0.0 );
  static float Pulse(float v, float t0, float ti);
  
  static float Max(float x, float y);
  static float Max(float x, float y, float z);
  static float Min(float x, float y);
  static float Min(float x, float y, float z);
  
  static float MaxP(float x, float y, float xp, float yp );
  static float MaxP(float x, float y, float z, float xp, float yp, float zp);
  static float MinP(float x, float y, float xp, float yp );
  static float MinP(float x, float y, float z, float xp, float yp, float zp);
  
  static inline float SL::Min(float w, float x, float y, float z) { return SL::Min( SL::Min( w, x ), y, z ); }
  static inline float SL::Max(float w, float x, float y, float z) { return SL::Max( SL::Max( w, x ), y, z ); }
  static inline float SL::Min(float v, float w, float x, float y, float z) { return SL::Min( SL::Min( v, w, x ), y, z ); }
  static inline float SL::Max(float v, float w, float x, float y, float z) { return SL::Max( SL::Max( v, w, x ), y, z ); }
  
};

#endif  // __StellaLib__
