//----------------------------------------------------------------------------------------
//	TArray.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __TSDArray__
#define __TSDArray__

#include "SDSObject.h"
#include "FloatGrid.h"
#include "Coverage.h"

enum TSDArrayTags { kCondenseTag=1001 };

class TSDArray : public virtual SDSObject, public FloatGrid {

  Region2 fGlobalRegion;

protected:

public:
  
  TSDArray(Region2& r) : SDSObject(), fGlobalRegion(r), FloatGrid( Net::LocalRegion() * r )  {;}
  TSDArray() : SDSObject(), fGlobalRegion(), FloatGrid()  {;}

  inline int GetOwner() { return Net::GetOwner( fGlobalRegion.lower() ); }
  virtual int32 SDWrite( const char* info=NULL, const char* units=NULL, const char* format=NULL ) ;
  virtual int32 SDRead( int index, int32 group_ref, char* info, char* units, char* format );
  int32 ExportSetAttributes( int32 sds_id  );
  virtual int32 SDFinalize() { return 0;}
  virtual int TextDump( const CString& path, int index=0, int nData=1, const char* info=NULL, const char* units=NULL, const char* format=NULL ) const ;
#ifdef HAS_X
  virtual int ViewData( TSheet* aSheet, int index=0, int nData=1, char* info=NULL );
#endif
  virtual void Dump(FILE* oFile=NULL) const;
  void CopyFromCoverage ( PointSetCoverage cov, OrderedPointSet& set );
  void CopyFromCoverage ( PointSetCoverage cov, Region2& r );
  void Condense( int targetProc=-1  );

};


#endif

