//----------------------------------------------------------------------------------------
//	TDataSet.cc
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#include "TDataSet.h"
#include "DataSet.h"
#include "Environ.h"
#include "HDFMgr.h"

void DataSet::setMap( byte* data_map ) { 
  _data_map = data_map; 
}

int32 TDataSet::SDWrite( const char* info, const char* units, const char* format )
{
	int32 istat = -1;
#ifdef HAS_HDF
	fSD_id = HDFM::Open(HDFM::kFOutput);
	if( fSDS_id == 0 ) {
    int32 dims[3];
    dims[0] = SD_UNLIMITED;
    dims[1] = capacity();
    dims[2] = 1;
    fSDS_id = SDcreate(fSD_id,(char*)DSetName(),DFNT_FLOAT32,3,dims);
    SDsetdatastrs(fSDS_id,(char*)DSetName(),(char*)units,(char*)format,NULL);
    SDsetattr(fSDS_id,"info",DFNT_CHAR8,sizeof(info),(void*)info);
    HDFM::AddSDS(fSDS_id,HDFM::kFDataSet,VariableName());
  }

  int32 start[3], edges[3];
  edges[0] = 1;
  edges[1] = capacity();
  edges[2] = 1;

  int32 size, dim_id = SDgetdimid( fSDS_id, 0 );
  SDdiminfo( dim_id, NULL, &size, NULL, NULL);
  start[0] = size;
  start[1] = 0;
  start[2] = 0;
  istat = SDwritedata(fSDS_id,start,NULL,edges,(void*)data());

  if(istat != 0) printf("\nerror writing SDS file: %s\n",DSetName());
#endif
  return istat;
}

int32 TDataSet::ExportSetAttributes( int32 sds_id  ) {
#ifdef HAS_HDF
  char info[kAttrStrLen];
  ReadAttr("info",info);
  SDsetattr(sds_id,"info",DFNT_CHAR8,sizeof(info),info);
#endif
	return 0;
}

int32 TDataSet::SDRead( int index, int32 ref, char* info, char* units, char* format   ) {
	int32 istat = -1;
#ifdef HAS_HDF
	fSD_id = HDFM::Open(HDFM::kFInput);
  if( fSDS_id == 0 ) {
		int32 sds_index; 
    if( ref < 0 ) sds_index = HDFM::GetSDS( HDFM::kFDataSet, DSetName(), VariableName() );
    else sds_index = SDreftoindex(fSD_id,ref); 
    fSDS_id = SDselect(fSD_id,sds_index);
    if( fSDS_id == FAIL ) { 
			sprintf(gMsgStr," Can't find SDS file %s : %s",VariableName(),DSetName()); 
			gPrintErr(); return FAIL;
		}
    int size = DimensionSize(1);
    resize(size);
    char name[kAttrStrLen];
    SDgetdatastrs(fSDS_id, name, units, format, NULL, kAttrStrLen );
    DSetName(name);
  } else SDgetdatastrs(fSDS_id, NULL, units, format, NULL, kAttrStrLen );
  ReadAttr("info",info);

  int32 start[3], edges[3];
  edges[0] = 1;
  start[0] = index;
  edges[1] = capacity();
  edges[2] = 1;
  start[1] = 0;
  start[2] = 0;
	istat = SDreaddata(fSDS_id,start,NULL,edges,(void*)data()); 
#endif
  return istat;
}

int TDataSet::TextDump( CString& path, int index, int nData, const char* info, const char* units, const char* format) const  {

  FILE* outFile;
  path += fVariableName + "_" + fDSetName.chars() + ".TEXT";
  if(index==0) outFile = fopen(path.chars(),"w");
  else outFile = fopen(path.chars(),"a");
  if(outFile==NULL) { sprintf(gMsgStr,"Can't open file: %s\n",path.chars()); gPrintErr(); return 0; }
  int rv = TextDump(outFile,index,nData,info,units,format );
  fclose(outFile);
  return rv;
}

int TDataSet::TextDump( FILE* outFile, int index, int nData, const char* info, const char* units, const char* format ) const  {

  fprintf(outFile,"\n\n_=NULL________Text Dump for Plex %s_%s__________\n",
	  fVariableName.chars(),fDSetName.chars());
  if(info) fprintf(outFile,"Info = %s\n",info);
  if(units) fprintf(outFile,"Units = %s\n",units);
  if(format) fprintf(outFile,"Format = %s\n",format);
  for(int ir=0; ir<capacity(); ir++) {
    float value = (*this)[ir];
    fprintf(outFile,"%f ",value);
  }
  return 0;
}

#ifdef HAS_X

int TDataSet::ViewData( TSheet* aSheet, int index, int size ) {
  float fmin, fmax;
  if( index == 0 ) {  
  	int cols = capacity();
  	int rows = size;
  	aSheet->SetDomain(0.0,1.0);
  	CString Name = fVariableName + " " + fDSetName;
  	aSheet->SetName(Name.chars());
  }
  aSheet->SetData( (*this).data(), 1,  capacity() ); // AddRow( (*this).data(), index,  capacity() );
 
  if( index == size-1 ) aSheet->Flush();
}

#endif



void DataSet::setSize( int l0, int l1, int l2, int datasize ) { 	
	_L0 = l0;		
	_L1 = l1;		
	_L2 = l2;		
	_datasize = ( _format == 1 ) ? datasize : _L0 * _L1 * _L2;
	sprintf(gMsgStr,"\nDataSet::setSize: L(%d %d %d) format: %d, size: %d",_L0,_L1,_L2,_format,_datasize); 
	gPrintLog();
	if( _datasize > _buffersize ) {
		unsigned short* tdata = _data;
		int newsize = _datasize + 10;
		_data = new unsigned short[ newsize ];
		memset(_data, 0, newsize*sizeof(short) );
		if( tdata ) { 
			memcpy( _data, tdata, _buffersize*sizeof(short) );
			delete[] tdata; 
		} 
		_buffersize = newsize;
	}			
} 


  
  
