//----------------------------------------------------------------------------------------
//	TDataSet.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __TDataSet__
#define __TDataSet__

#include "SDSObject.h"
#include "floatVec.h"
#include "TObjects.h"

class TDataSet : public SDSObject, public floatVec {

protected:

public:
  
  TDataSet() : SDSObject(), floatVec()  {;}
  TDataSet(int size) : SDSObject(), floatVec(size)  {;}

  virtual int32 SDWrite( const char* info=NULL, const char* units=NULL, const char* format=NULL );
  virtual int32 SDRead( int index, int32 group_ref, char* info=NULL, char* units=NULL, char* format=NULL );
  int32 ExportSetAttributes( int32 sds_id  );
  virtual int32 SDFinalize() { return 0; }
  virtual int TextDump( FILE* outFile, int index=-1, int nData=1, const char* info=NULL, const char* units=NULL, const char* format=NULL ) const;
  virtual int TextDump( CString& path, int index, int nData, const char* info=NULL, const char* units=NULL, const char* format=NULL ) const;

  void Dump( FILE* oFile ){ TextDump(oFile); }
#ifdef HAS_X
  int ViewData( TSheet* aSheet, int index, int size );
#endif

};


#endif

