#include "TPipe.h"
#include "CVariable.h"
#include "SSModel.h"
#include "SSModule.h"
#include "viewserver.h"
#include "GOFCalc.h"

// #include <netinet/in.h>

int TPipe::fPipeIndex = 0;

//----------------------------------------------------------------------------------------
//						TPipe
//----------------------------------------------------------------------------------------

Pipe* TPipe::GetPipeFromConfig( TConfigData& cd, TConfigObject* cobj, TPipeCommand*& pc  ) {
  const CString& cmd = cd.Cmd();
  Pipe* p = NULL;
	Variable* v = (Variable*)cobj; 
  if( TAnimPipe::Cmd(cmd) ) {
		if( pc = v->ProcessPipes(Pipe::kAnim,Variable::kReturn) ) { p = pc->GetPipe(); }
		else {
			CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
			p = new TAnimPipe(name,(TVariable*)cobj);
		}
  } else if( TDataDisplayPipe::Cmd(cmd) ) {
		if( pc = v->ProcessPipes(Pipe::kDataDisplay,Variable::kReturn) ) { p = pc->GetPipe(); }
		else {
			CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
			p = new TDataDisplayPipe(name,(TVariable*)cobj);
		}
		v->SetF(FisDisplayVar,True,"Pipe::GetPipeFromConfig");
  } else if( TSocketPipe::Cmd(cmd) ) {
		if( pc = v->ProcessPipes(Pipe::kSocket,Variable::kReturn) ) { p = pc->GetPipe(); }
		else {
			CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
			p = new TSocketPipe(name,(TVariable*)cobj);
		}
  } else if( TGraphPipe::Cmd(cmd) ) {
    CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
    p = new TGraphPipe(name,(TVariable*)cobj);
  } else if( TSheetPipe::Cmd(cmd) ) {
     CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
     p = new TSheetPipe(name,(TVariable*)cobj);
  } else if( TMapArchivePipe::Cmd(cmd) ) {
    CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
    p = new TMapArchivePipe(name,(TVariable*)cobj);
  } else if( TPtSeriesPipe::Cmd(cmd) ) {
    CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
    p = new TPtSeriesPipe(name,(TVariable*)cobj);
  } else if( TCondensePipe::Cmd(cmd) ) {
    CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
    p = new TCondensePipe(name,(TVariable*)cobj);
// } else if( TWindowPipe::Cmd(cmd) ) {
//    CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
//    p = new TWindowPipe(name,(TVariable*)cobj);S
  }  else if( TDBaseInputPipe::Cmd(cmd)  ) {
		CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
		p = new TDBaseInputPipe(name,(TVariable*)cobj);
		v->MakeDBaseVar(); 
  } else if( TTimeSeriesInputPipe::Cmd(cmd) ) {
		if( pc = v->ProcessPipes(Pipe::kTimeSeriesInput,Variable::kReturn) ) { p = pc->GetPipe(); }
		else {
			CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
			p = new TTimeSeriesInputPipe(name,(TVariable*)cobj);
		}
		v->MakeTimeSeriesVariable();
  } else if( TPtTimeSeriesInputPipe::Cmd(cmd) ) {
		if( pc = v->ProcessPipes(Pipe::kPtTimeSeriesInput,Variable::kReturn) ) { p = pc->GetPipe(); }
		else {
			CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
			v->SetF(FisSpatial,True,"AllocatePipes"); 
			p = new TPtTimeSeriesInputPipe(name,(TVariable*)cobj);
		}
		if( !Env::UseMPE() ) { v->MakePtTimeSeriesVariable(); }
  }  else if( TMapInputPipe::Cmd(cmd) ) { 
//		fprintf(stderr,"\n  ** dbg1: process pipe %s: cmd: %s \n", v->Name(), cmd.chars() ); fflush(stderr);
		if( pc = v->ProcessPipes(Pipe::kMapInput,Variable::kReturn) ) { p = pc->GetPipe(); }
		else {
			CString name(cmd);  name += "_p_"; name.appendIndex(fPipeIndex++);
			v->SetF(FisSpatial,True,"AllocatePipes"); 
			p = new TMapInputPipe(name,(TVariable*)cobj);
		}
		if( !Env::UseMPE() ) { v->MakeMapInputVariable( cmd == "c" ); }
  } else return NULL;
  p->Config(cd);
  return p;
}

DBaseInputPipe* TPipe::GetDBaseInputPipe( const char* n, TVariable* v ) {
	CString name(n);  name += "_p_"; name.appendIndex(fPipeIndex++);
	return new TDBaseInputPipe(name,v);
}

//----------------------------------------------------------------------------------------
//						TAnimPipe
//----------------------------------------------------------------------------------------

TNamedObjectList  TAnimPipe::fGlobalViewers;

TAnimPipe::TAnimPipe(const char* name, TVariable* var) : AnimPipe( name,(Variable*)var ) {
  fMap = NULL; fAnimationIndex = -1;  fRegion_map = NULL; fAnimatorType = 3;
}

TAnimPipe::TAnimPipe(const char* name, ByteGrid* m) : AnimPipe( name, NULL ) {
  fMap = NULL; fAnimationIndex = -1;  fRegion_map = m; fAnimatorType = 3;
}

int  TAnimPipe::Config( TConfigData& cd ) {
  if( AnimPipe::Config( cd ) ) {
    return 1;
  }  return 0;
}

void TAnimPipe::GetMaps() {
	if( fRegion_map == NULL ) {
		TModule* mod = (TModule*)((Variable*)fConfigObject)->GetModule();
		TMultiFrame& f = (TMultiFrame&) TModel::I().Frame();
		fRegion_map = f.GetRegionMap( mod );
	}
	if( fMap == NULL ) {
			fMap = new TMap( (const Region2*) fRegion_map,  TMap::kShorts );
			fMap->SetByteConversion(fScale,fOffset);
/*
			switch( GetObjInfo(kADataType) ) {
			case 1:  case 4: // bytes
				fMap = new TMap( (const Region2*) fRegion_map,  TMap::kBytes );
				fMap->SetByteConversion(fScale,fOffset);
				break;
			case 2:  case 5: // shorts
				fMap = new TMap( (const Region2*) fRegion_map,  TMap::kShorts );
				fMap->SetByteConversion(fScale,fOffset);
				break;
			case 3:  case 6: // ints
				fMap = new TMap( (const Region2*) fRegion_map,  TMap::kInts );
				fMap->SetByteConversion(fScale,fOffset);
		}
*/
	}
}

TAnimPipe* TAnimPipe::GetGlobalViewer( ByteGrid* m, const CString& mname ) {
	for( Pix p = fGlobalViewers.first(); p; fGlobalViewers.next(p) ) {
		TAnimPipe& ap = (TAnimPipe&) fGlobalViewers(p);
		if( ap.RegionMap() == m ) return &ap;
	}
	CString name("Map Viewer: region "); name += mname;
	TAnimPipe* ap = new TAnimPipe(name,m);
	ap->SetObjInfo(kADataType,4);
	ap->Initialize();
	fGlobalViewers.append(*ap);
	return ap;
}

int  TAnimPipe::Initialize() {
	if( Env::UseMPE() ) { return 0; }
#ifdef JAVA
	GetMaps();
	if( gIProc != 0 ) return fAnimationIndex;
	CString name = (fConfigObject) ? fConfigObject->Name() : "Map Viewer";	
	fAnimatorType = GetObjInfo(kADataType);
	
	if( fAnimatorType == 2 ) {
		fAnimationIndex = ViewServer::create_dataset(
											fRegion_map->extents(1), 				// cols = width 
											fRegion_map->extents(0), 				//rows = height 
											1,															// third dimension.
											2,
											0,															// 2D map
											(byte*)fRegion_map->Data(),
											(const byte*) name.chars() );
	} else {
		fAnimationIndex = ViewServer::create_2D_animator( 
											fRegion_map->extents(1), 				// cols = width 
											fRegion_map->extents(0), 				//rows = height 
											fAnimatorType,
											(byte*)fRegion_map->Data(),
											(const byte*) name.chars() );
	}
#endif
	return fAnimationIndex;
}
    

int TAnimPipe::Execute() {
	if( Env::UseMPE() ) { return 0; }
#ifdef JAVA
  if( fMap == NULL ) return 0; 
  char name[250];
	CVariable* var = (CVariable*)fConfigObject;
	int rv = var->Cov().CopyToMap( *fMap, False, kAutoScaling ); 
	if( rv == 0 ) return 0;
	if( (gTime() > 9999.9) || (gTime() < 0.1) ) sprintf(name,"%s(%.1E)",var->Name(),gTime());
	else sprintf(name,"%s(%.1f)",var->Name(),gTime());
	if( gIProc == 0 ) {
		if( fAnimatorType == 2 ) {
			ViewServer::add_data_entry( fAnimationIndex, fMap->ShortData(),  fMap->NElements(), fMap->ScaleData()[0], fMap->ScaleData()[1], gTime(), gDT(), (const byte*) name   ); 
		} else {
			ViewServer::send_animation_frame( (byte)fAnimationIndex, fMap->NElements(), fMap->ShortData(), fMap->ScaleData(), gTime(), (const byte*) name  );
		}
	}
#endif
  return 1;
}

int TAnimPipe::DisplayVariable( Variable* dvar ) {
#ifdef JAVA
	if( fMap == NULL ) return 0;
  char name[250];
	CVariable* var = (CVariable*)dvar;
	int rv = var->Cov().CopyToMap( *fMap, False, kAutoScaling ); 
	if( rv == 0 ) return 0;
	if( (gTime() > 9999.9) || (gTime() < 0.1) ) sprintf(name,"%s(%.1E)",var->Name(),gTime());
	else sprintf(name,"%s(%.1f)",var->Name(),gTime());
	if( gIProc == 0 ) {
		if( fAnimatorType == 2 ) {
			ViewServer::add_data_entry( fAnimationIndex, fMap->ShortData(), fMap->NElements(), fMap->ScaleData()[0], fMap->ScaleData()[1], gTime(), gDT(), (const byte*) name );		
		} else {
				ViewServer::send_animation_frame( (byte)fAnimationIndex, fMap->NElements(), fMap->ShortData(), fMap->ScaleData(), gTime(), (const byte*) name  );
		}
	}
#endif
  return 1;
}

//----------------------------------------------------------------------------------------
//						TDataDisplayPipe
//----------------------------------------------------------------------------------------

TNamedObjectList  TDataDisplayPipe::fGlobalViewers;
DataSet* TDataDisplayPipe::fParameterDataSet = NULL;

TDataDisplayPipe::TDataDisplayPipe(const char* name, TVariable* var ) : DataDisplayPipe( name,(Variable*)var ) {
  fDataSet = NULL; fTimeBufferSize = 5;  fDataFormat = 1; fStep_count = 0; fRegion_map = NULL; fMode = 0;
//	if( gNProc > 1 ) { fDataFormat = 0; }
}

TDataDisplayPipe::TDataDisplayPipe( const char* name, ByteGrid* region_map, TVariable* var ) : DataDisplayPipe( name,(Variable*)var ) {
  fDataSet = NULL; fTimeBufferSize = 5;  fDataFormat = 1; fStep_count = 0; fRegion_map = region_map; fMode = 0;
//	if( gNProc > 1 ) { fDataFormat = 0; }
}

int  TDataDisplayPipe::Config( TConfigData& cd ) {
  if( DataDisplayPipe::Config( cd ) ) {
    return 1;
  }  return 0;
}

int  TDataDisplayPipe::Initialize() {
	if( Env::UseMPE() ) { return 0; }
 	CVariable* var = (CVariable*)fConfigObject;
 	int is_const = var->GetF(FisConstant);
 	if( is_const ) {
		fTimeBufferSize = INT_MAX;
 	}
 	int is_spatial = var->GetF(FisSpatial);
	if( is_const && !is_spatial && (fMode==0) ) {
		if( fParameterDataSet == NULL ) {
			fParameterDataSet = new DataSet( 0, NULL, "Parameters" );
		}
		fDataSet = fParameterDataSet;
	} else {
		CString name;
		if( fMode > 0 ) { 
			static int browseCount = 0;
			name = "BrowseData"; 
			name.appendIndex(browseCount++); 
		} else {
		   var->FullName(name); 
		}
		fDataSet = new DataSet( fDataFormat, NULL, name.chars() );
	}
 	sprintf(gMsgStr,"Initializing TDataDisplayPipe: %s %d %d %d %p (%p)",var->Name(),is_const,is_spatial,fDataFormat,fDataSet,fParameterDataSet);
 	gPrintScreen();
 	gPrintLog();
	return fDataSet->index();
}  
 
// (int L0, int L1, int L2, byte dim, byte* region_map, const byte* name, const char* categories, byte format, int mode ) {
// ( int dataset_index, short* data, int data_size, float max, float min, float time, float dt, const byte* info, byte format ) {

int TDataDisplayPipe::DisplayData( const char* display_name, float* fd, float fmax, float fmin, int s0, int s1, int s2 ) {
#ifdef JAVA
	int datasize = s0*s1*s2;
	int maxval = 256*256-2;
	float s = maxval/(fmax - fmin);
	int mode = 0;
	unsigned short* sdata = new unsigned short[datasize];
	byte format = 1, *region_map = NULL, dim = (s2 > 1) ? 3 : 2;
	char* categories = NULL;
	for( int i=0; i < datasize; i++ ) {
	  sdata[i] = (unsigned short) (( fd[i] - fmin)*s + 1 );
	}
	int index = ViewServer::create_dataset( s0, s1, s2, dim, 0, region_map, (byte*)display_name, categories, format, mode );
	ViewServer::add_data_entry( index, (short*)sdata,  datasize,  fmax, fmin, gTime(), gDT(), (const byte*)display_name, (byte)Variable::kFloat ); 
	delete[] sdata;
#endif
	return 0;
}

TDataDisplayPipe* TDataDisplayPipe::GetGlobalViewer( CVariable& v, byte mode ) {
	Region2 r;
	TDataDisplayPipe* ap = NULL;
	int cell_layer_index = -1;
	TPartition2* P = (v.GetF(FisSpatial)) ? v.Cov().GetPartition( cell_layer_index ) : NULL;
	ByteGrid* cd = (P==NULL) ? NULL : P->cellDistribution(); 
	for( Pix p = fGlobalViewers.first(); p; fGlobalViewers.next(p) ) {
		ap = (TDataDisplayPipe*) &fGlobalViewers(p);
		if( (ap->RegionMap() == cd) && (ap->Mode() == mode) ) break;
		else ap = NULL;
	}
	if( ap == NULL ) {
		ap = new TDataDisplayPipe( "Data Browser", cd, &v );
		ap->setBrowseMode( mode );
		ap->Initialize(  );
		fGlobalViewers.append(*ap);
	} else {
		ap->fConfigObject = &v;
	}
	return ap;
}

int TDataDisplayPipe::Execute() {
	if( Env::UseMPE() ) { return 0; }
#ifdef JAVA
 	CVariable* var = (CVariable*)fConfigObject;
	int flush = ( ( fMode > 0 ) || ((fStep_count++ % fTimeBufferSize) ==  (fTimeBufferSize-1)) );
	if( fMode > 0 ) { fTimeBufferSize = 0; }
	byte adim = (byte) var->getArrayDimension();
	
	int sendData = var->CopyToDataSet( *fDataSet, flush, fTimeBufferSize );
	
	if( gIProc != 0 ) return 0;
	
	if( fDataSet->index() < 0 ) {
		byte* map = (byte*)fDataSet->dataMap();
		const char* categories =  ( var->GetCategories() == NULL ) ? NULL : var->GetCategories()->text_representation();
		int index = ViewServer::create_dataset( fDataSet->getSize(0), fDataSet->getSize(1), fDataSet->getSize(2), 
												fDataSet->getDims(), adim, map, 	(const byte*) fDataSet->name().chars(), 
												categories, fDataSet->format(), fMode );
		sprintf(gMsgStr,"ExecutingDataDisplayPipe: create DataSet %s -> mapdata: ",fDataSet->name().chars()); gPrintLog();
		if( map != NULL ) {
		  for(int i=0; i<20; i++ ) { fprintf( Env::LogFile(), " %d ", map[i] ); }	
		}	

		fDataSet->setIndex(index);
	}
	
	if( sendData ) {
		char name[250];
		if( (gTime() > 9999.9) || (gTime() < 0.1) ) sprintf(name,"%s.%s(%.1E)",var->GetModule()->Name(),var->Name(),gTime());
		else sprintf(name,"%s.%s(%.1f)",var->GetModule()->Name(),var->Name(),gTime());
		ViewServer::add_data_entry( fDataSet->index(), (short*)fDataSet->data(),  fDataSet->dataSize(), 
																fDataSet->max(), fDataSet->min(), gTime(), 
																fDataSet->DT(), (const byte*)name, (byte)var->DataType() ); 
	}
	sprintf(gMsgStr,"ExecutingDataDisplayPipe %s(%d): send(%d), for variable %s, format = %x",
					fDataSet->name().chars(), fDataSet->index(), sendData, var->Name(), (byte)var->DataType() );
	gPrintLog();
#endif
  return 1;
}


//----------------------------------------------------------------------------------------
//						TSocketPipe
//----------------------------------------------------------------------------------------

TSocketPipe::TSocketPipe(const char* name, TVariable* var) : SocketPipe( name,(Variable*)var ) {
  fMap = NULL;
}

int  TSocketPipe::Config( TConfigData& cd ) {
  if( SocketPipe::Config( cd ) ) {
    return 1;
  }  return 0;
}

int  TSocketPipe::Initialize() {
	CVariable* var = (CVariable*)fConfigObject;
	if( var->GetF(FisSpatial) ) {
		Region2 r;
		var->GlobalRegion(r);
		fMap = new TMap( &r,1 ); 
		return 1;
	}
	return 0;
}
    

int TSocketPipe::SendBlockData(TMap* m)
{
  return 0;
}      

int TSocketPipe::Execute() {
	CVariable* var = (CVariable*)fConfigObject;
	if( var->GetF(FisSpatial)) {
		if( fMap == NULL ) Initialize();
		fMap->SetByteConversion( fScale, fOffset, GetObjInfo(kNBytes) );
		return var->Cov().CopyToMap( *fMap );		
	}   
	return 0;
}

//----------------------------------------------------------------------------------------
//						TPointPipe
//----------------------------------------------------------------------------------------

int TPointPipe::Initialize() {
	CVariable* var = (CVariable*)fConfigObject;
	fCell = (void*)TModel::I().Grid()->getCellLayer(fCellLayer)->getCell(fPoint);
  return 1;
}

//----------------------------------------------------------------------------------------
//						TGraphPipe
//----------------------------------------------------------------------------------------

TAssoc_array TGraphPipe::fGraphs;

class TGraphIndex : public TObject {
  int _gindex;
public:    
  TGraphIndex( int index ) : TObject() { _gindex = index; }
  inline int getIndex() { return _gindex; }
};

TGraphPipe::TGraphPipe(const char* name, TVariable* var) : GraphPipe( name, (Variable*) var ) {
	fComponentIndex = -1;
}

int  TGraphPipe::Config( TConfigData& cd ) {

  if( GraphPipe::Config(cd) ) {
    return 1;
  }  return 0;
}

int  TGraphPipe::Initialize() {
	int rv = 0;
#ifdef JAVA
	Module* m = NULL;
	CVariable* var = (CVariable*)fConfigObject;
	if( var->GetF(FisSpatial) ) { 	fCell = TModel::I().Grid()->getCellLayer(fCellLayer)->getCell(fPoint);  }
	else { fCell = 0; }
	m = var->GetModule();
	ExSchedule* s = m->GetSchedule();
	fDT = s->DT();
	
	if( (fDomain[0] == fDomain[1]) && m ) {
		fDomain[0] = (int) (s->StartTime()/fDT); 
		fDomain[1] = (int) (s->StopTime()/fDT); 
	}
	CString gname(Env::ProjName() + " graphs");
	ViewServer::create_new_graph( fIndex, fDomain[0], fDomain[1], fDT, fRange[0], fRange[1],  (const byte*)gname.chars(), ViewServer::DAYS );  
	rv = fComponentIndex =  ViewServer::add_graph_component( (const byte*) fConfigObject->Name(), (const byte*) "default", fIndex );
#endif
	return rv;
}
 
int  TGraphPipe::Execute() {
	float value;
#ifdef JAVA
	CVariable* var = (CVariable*)fConfigObject;
	value = var->Value((TCell*)fCell);
	int offset = (int)(gTime()/fDT);
	ViewServer::send_graph_data(  fIndex, fComponentIndex, offset, 1, &value );
#endif
	return 0;
}

int TGraphPipe::GraphData( CVariable* dvar, const char* graph_name, const char* timeseries_name, float* data, int datasize, Bool overwrite, int array_index ) { 
	int ci = -1;
#ifdef JAVA
	if( dvar->GetF(FisSpatial) ) { 
		gPrintErr( "non-spatial graph method called for spatial variable"); 
		return -1; 
	}
	CVariable* var = (CVariable*)dvar;
	Module*	m = dvar->GetModule();
	ExSchedule* s = m->GetSchedule();
	float dt = s->DT();
	int start = (int) (s->StartTime()/dt); 
	int stop = (int) (s->StopTime()/dt); 
	TGraphIndex* graph_index = (TGraphIndex*)fGraphs.objptr(graph_name);
	if( graph_index == NULL ) {
	  fGraphs.add( graph_name, graph_index = new TGraphIndex( 8 + fGraphs.items() ) );
	}
	int gi = graph_index->getIndex();
	if( array_index >= 0 ) {
	  if( data == NULL ) {
		data = (float*) var->TimeSeriesData(array_index,datasize);
	  }
	} else {
	  if( data == NULL ) {
		data = var->Data();
		datasize = var->DataSize();
	  }
	}
	if( datasize == 0 ) { return -1; }
	float fmax = data[0], fmin = data[0];
	for( int i=1; i<datasize; i++ ) {
		if( data[i] > fmax ) { fmax = data[i]; }
		if( data[i] < fmin ) { fmin = data[i]; }
	}
	ViewServer::create_new_graph( gi, start, stop, dt, fmin, fmax, (const byte*) graph_name, ViewServer::DAYS, (byte) overwrite );  
	ci = ViewServer::add_graph_component( (const byte*) timeseries_name, (const byte*) "default", gi );
	ViewServer::send_graph_data(  gi, ci, 0, datasize, data );
#endif
	return ci;
}
//----------------------------------------------------------------------------------------
//						TSheetPipe
//----------------------------------------------------------------------------------------

TSheetPipe::TSheetPipe(const char* name, TVariable* var) : SheetPipe( name, (Variable*) var ) {;}

int TSheetPipe::Config( TConfigData& cd ) {
  if( SheetPipe::Config( cd ) ) {
    return 1;
  } return 0;
}

int  TSheetPipe::Initialize() {
		return 0;
}
 
int  TSheetPipe::Execute() {
	float value =0.0;
	CVariable* var = (CVariable*)fConfigObject;
	value = var->Value((TCell*)fCell);
	return 0;
}

//----------------------------------------------------------------------------------------
//						TMapArchivePipe
//----------------------------------------------------------------------------------------

TMapArchivePipe::TMapArchivePipe(const char* name, TVariable* var) : MapArchivePipe(name, (Variable*) var ) {
  fWriteIndex = 0;
}

int TMapArchivePipe::Config( TConfigData& cd ) {
  const CString& cmd = cd.Cmd();
  EMapType mt;
  if( MapArchivePipe::Config(cd) && (  (mt = (EMapType) GetObjInfo(kMapType)) != kGeometry  ) ) {
    fMap.SetObjInfo( TMap::kMapType, mt );
    fMap.DSetName(fMapName);
    fMap.VariableName(Var()->Name());
	if( mt==kGRASS ) { fMap.SetByteConversion(1,0,0); }
    else if( mt==kASCII ) { fMap.SetDataType(TMap::kFloats); fMap.SetByteConversion(1,0,0); }
    else if( mt==kArc ) { 
	  fMap.SetDataType(TMap::kFloats); 
	  if( fScale > 0.0 ) { fMap.SetByteConversion(fScale,fOffset,0); }
	}
    else if( mt==kPPM ) { 
	  fMap.SetDataType(TMap::kFloats); 
	  fMap.SetByteConversion(fScale,fOffset,0);
	}
    else if( mt==kHDF5 ) { 
	  fMap.SetDataType(TMap::kFloats); 
	  fMap.SetByteConversion(fScale,fOffset,GetObjInfo(kPrecision));
	}
    else {
	  if( fScale > 0.0 ) { fMap.SetByteConversion(fScale,fOffset,GetObjInfo(kPrecision)); }
	}
    return 1;
  }
  return 0; 
}

int  TMapArchivePipe::Initialize() {
  if( Env::UseMPE() ) { return 0; }
  if( GetObjInfo(kMapType) == kGeometry ) {
 	CVariable* var = (CVariable*)fConfigObject;
	fDataSet = new DataSet( GetObjInfo(kPrecision), NULL, fMapName.chars() );
	return fDataSet->index();
  }
}

FILE* TMapArchivePipe::open_output_file(const char* suffix) {
	FILE *fp = NULL;
	if( gIProc != 0 ) { return fp; }
	CPathString pathName(Env::ArchivePath()); 
	pathName.Add("Maps");
	CString mapFileName( fMapName );
	mapFileName.appendIndex(fWriteIndex++,3); 
	mapFileName += suffix;
	pathName.Add(mapFileName);
	if ( (fp = fopen (pathName, "w")) == NULL ) {
		sprintf ( gMsgStr, "Can't open Map archive file %s.\n", pathName.chars() ); gPrintErr();
	} else {
		sprintf ( gMsgStr, "Writing to Map archive file %s.\n", pathName.chars() ); gPrintScreen();
	}
	return fp;
}

int TMapArchivePipe::Finalize() { 
  if( Env::UseMPE() ) { return 0; }
  CVariable* var = (CVariable*)fConfigObject;
  if( GetObjInfo(kMapType) == kGeometry ) {
	var->CopyToDataSet( *fDataSet, 1 );
	FILE *fp = open_output_file(".grid");
	if( fp != NULL ) { fDataSet->Dump(fp); fclose(fp); }
  } else {
	if( Var()->DataType() == Variable::kInt ) fMap.SetObjInfo(TMap::kMapClass,kClassMap);
	else fMap.SetObjInfo(TMap::kMapClass,kSurfaceMap);
	Module* m = var->GetModule();
	LayerConfig* lc = m->getLayerConfig();
	fMap.SetCellsize(fCellsize);
	if( lc->Dim( 2 ) == 1 ) {
	  int rv = var->CopyToMap( fMap, -1 );
	  if( rv == 0 ) return 0;
	  fMap.Write( -1, True );
	} else {
	  int map_index = 0;
	  int iL0 = lc->CellLayer(), iL1 = iL0 + lc->Dim( 2 );
	  for( int iL = iL0; iL < iL1; iL++ ) {
		int rv = var->CopyToMap( fMap, iL );
		if( rv == 0 ) return 0;
		fMap.Write( map_index++, True );
	  }
	}
  }
  return 1;
}

int  TMapArchivePipe::Execute() {
  if( Env::UseMPE() ) { return 0; }
  CVariable* var = (CVariable*)fConfigObject;
  if( GetObjInfo(kMapType) == kGeometry ) {
	var->CopyToDataSet( *fDataSet, 1 );
	FILE *fp = open_output_file(".grid");
	if( fp != NULL ) { fDataSet->Dump(fp); fclose(fp); }
  } else {
	if( Var()->DataType() == Variable::kInt ) fMap.SetObjInfo(TMap::kMapClass,kClassMap);
	else fMap.SetObjInfo(TMap::kMapClass,kSurfaceMap);
	Module* m = var->GetModule();
	LayerConfig* lc = m->getLayerConfig();
	fMap.SetCellsize(fCellsize);
	if( lc->Dim( 2 ) == 1 ) {
	  int rv = var->CopyToMap( fMap, -1 );
	  if( rv == 0 ) return 0;
	  fMap.Write( -1 );
	} else {
	  int map_index = 0;
	  int iL0 = lc->CellLayer(), iL1 = iL0 + lc->Dim( 2 );
	  for( int iL = iL0; iL < iL1; iL++ ) {
		int rv = var->CopyToMap( fMap, iL );
		if( rv == 0 ) return 0;
		fMap.Write( map_index++ );
	  }
	}
  }
  return 1;
}

//----------------------------------------------------------------------------------------
//						TPtSeriesPipe
//----------------------------------------------------------------------------------------

TPtSeriesPipe::TPtSeriesPipe(const char* name, TVariable* var) : PtSeriesPipe( name, (Variable*) var ) {
  fIndex = 0;
}

int TPtSeriesPipe::Config( TConfigData& cd ) {
  if( PtSeriesPipe::Config( cd ) ) {
    return 1;
  } else return 0;
}

int TPtSeriesPipe::Initialize() {  
	CVariable* var = (CVariable*)fConfigObject;
	if( var->GetF(FisSpatial) ) { 
	  fCell = TModel::I().Grid()->getCellLayer(fCellLayer)->getCell(fPoint); 
	}
	return 0; 
}

int TPtSeriesPipe::Execute() {
  if( Env::UseMPE() ) { return 0; } 
  float data;
  CVariable* var = (CVariable*)fConfigObject;
  if( fCell ) {
	data = var->Value((TCell*)fCell);
	int index;
	TTemporalTimeSlice* s = fData.grow_high(index);
	s->SetData(gTime(),data);
	if( gDebug ) { 
	  sprintf(gMsgStr,"\n(P%d)Archiving Point for %s, index=%d, value = %f\n",  gIProc, Name(), index, data ); 
	  gPrintLog(); 
	}
  } 
  return 1;
}
 
int  TPtSeriesPipe::Finalize() {
//  fData.Write();
	CVariable* var = (CVariable*)fConfigObject;
#ifdef HAS_MPE
	if( Env::UseMPE() ) { 
	  if( ( GOFCalc::getNIter() > 0 ) || ( GOFCalc::getParameterIndex() != 0 ) ) return 0;
	}
#endif
	CPathString pathName(Env::ArchivePath());
	pathName.Add(var->Name());
	CString term(".PTS."); 
	if( Env::UseMPE() ) { 
#ifdef HAS_MPE
	  if( GOFCalc::getNIter() == 0 ) term += "initial";
	  else term += "final";
#endif
	} else {
	  term+=Name(); 
	  int bi = Env::BatchIndex();
	  if( bi >= 0 ) { term.appendIndex(bi,3); }
	}
	FILE* oFile = fopen(pathName.Path(term),"w");
	if(oFile) {
		if( fCell ) { fData.DumpToFile(oFile); } 
		else { var->DumpToFile(oFile); }
		fclose(oFile);
	} else Util::CheckErrors( "Write PTSeries:", pathName.Path(term) ); 
  return 1;
}

/*
TWindowPipe::TWindowPipe( const char* name, TVariable* var) : WindowPipe(name, (Variable*)var ) {
  fIndex = 0;
}
TWindowPipe::TWindowPipe(const char* name, EType type, TVariable* var) : WindowPipe(name, type, (Variable*) var ) {
  fIndex = 0;
}

int TWindowPipe::Config( TConfigData& cd ) {
  if( WindowPipe::Config( cd ) ) {
    return 1;
  }
  return 0;
}

int TWindowPipe::Initialize() {
    MakeWindowSet();
    return 1;
}
 
void TWindowPipe::MakeWindowSet() {
  Point2 dp(fSize,fSize);
  Region2 r( fPoint-dp, fPoint+dp );
  fMap.ReAlloc( r * TModel::I().LocalRegion(layer_index) );
	CVariable* var = (CVariable*)fConfigObject;
	fWindowSet.CopyRegion( var->Grid(), fArray );
}


int TWindowPipe::Execute()
{
    if(gDebug) { 
      sprintf(gMsgStr,"W(%d,%d,%d) Window to Map %s\n",fPoint(0),fPoint(1),fSize,Name()); 
      gPrintLog(); 
    }
		CVariable* var = (CVariable*)fConfigObject;
		fArray.CopyFromCoverage( var->Cov(), fWindowSet );
    int targetProc=0;
    if(gGlobalFileSystem) targetProc=fArray.GetOwner();
    fArray.Condense(targetProc);
    if( gIProc==targetProc ) fArray.SDWrite();
    return 1;
}
*/

//----------------------------------------------------------------------------------------
//						TCondensePipe
//----------------------------------------------------------------------------------------

TCondensePipe::TCondensePipe(const char* name, TVariable* var) : CondensePipe( name, (Variable*)var ), fWindowSet(100) {
  fIndex = 0;
}

int TCondensePipe::Config( TConfigData& cd ) {
  if( CondensePipe::Config( cd ) ) {
    return 1;
  } 
  return 0;
}

int TCondensePipe::Initialize() {
	if( Env::UseMPE() ) { return 0; }
    MakeWindowSet();
    return 1;
}

int TCondensePipe::Execute() {
  if( Env::UseMPE() ) { return 0; }
  float value = Condense();
  if( gIProc == 0 ) {
		int index;
    TTemporalTimeSlice* s = fTData.grow_high(index);
    s->SetData(gTime(),value);
    switch ( GetObjInfo(kMode) ) {
    case kR_Max:
      fCumValue = ( fCumValue < value ) ? value : fCumValue ; 
      break;
    case kR_Min:
      fCumValue = ( fCumValue > value ) ? value : fCumValue ; 
      break;
    case kR_Sum:
      fCumValue += value;
      break;
    case kR_Ave:
      fCumValue += value;
    }
    if( gDebug ) { 
      sprintf(gMsgStr,"(P%d) Archiving Condense for %s(%d), value = %f, cumval = %f\n", 
	      gIProc, Name(), index, value, fCumValue ); 
      gPrintLog(); 
      if( gDebug > 1 ) gPrintScreen();
    }
  }
  return 1;
}

int TCondensePipe::Finalize() {
	if( Env::UseMPE() ) { return 0; }
//  fCData.SDWrite();
	CPathString pathName(Env::ArchivePath());
	pathName.Add(fConfigObject->Name());
	CString term(".CondenseData."); term+=Name(); 
	int bi = Env::BatchIndex();
	if( bi >= 0 ) { term.appendIndex(bi,3); }
	FILE* oFile = fopen(pathName.Path(term),"w");
	if(oFile) {
		fTData.DumpToFile(oFile);
		fprintf(oFile,"\ntotal \t%f",fCumValue);
		fclose(oFile);
	} else Util::CheckErrors( "Write Condense:", pathName.Path(term) ); 
  return 1;
}

float  TCondensePipe::Condense() { 
	CVariable* var = (CVariable*)fConfigObject;
	return var->Cov().Reduce ((EReduceOp)GetObjInfo(kMode), 0, &fWindowSet ); 
}

void TCondensePipe::MakeWindowSet() {
  Point2 dp(fSize,fSize);
  Region2 r( fPoint-dp, fPoint+dp );
  int layer_index;
	r *= TModel::I().LocalRegion(layer_index);
	CVariable* var = (CVariable*)fConfigObject;
	fWindowSet.copyRegion( TModel::I().Grid(), r  ); 
}

//----------------------------------------------------------------------------------------
//						TimeSeriesInputPipe
//----------------------------------------------------------------------------------------

TTimeSeriesInputPipe::TTimeSeriesInputPipe( const char* name, TVariable* var )
  : TimeSeriesInputPipe( name, (Variable*) var ) {;}  

int TTimeSeriesInputPipe::Execute() {
	CAuxVariable* cv = (CAuxVariable*)fConfigObject;
	cv->Read( fSeriesName, GetObjInfo(kFormat) );
	if( fCommand ) {
		float dt = cv->DT();
		int size = cv->Length();
		fCommand->SetTimeSchedule(dt*size,gTime());
	}
	return 0;
}

//----------------------------------------------------------------------------------------
//						PtTimeSeriesInputPipe
//----------------------------------------------------------------------------------------

TPtTimeSeriesInputPipe::TPtTimeSeriesInputPipe( const char* name, TVariable* var ) 
  : PtTimeSeriesInputPipe( name, (Variable*) var ) {;}

int TPtTimeSeriesInputPipe::Execute() {
	if( gDebug ) { sprintf(gMsgStr,"Executing TPtTimeSeriesInputPipe %s at time %f\n",fName.chars(),gTime()); gPrintLog(); }
	CAuxVariable* cv = (CAuxVariable*)fConfigObject;
	cv->Read( fPtSeriesName, GetObjInfo(kFormat) );
	sprintf(gMsgStr,"reading PtTimeSeries, series name = %s",fPtSeriesName.chars()); gPrintScreen();
	if( fCommand ) {
		float dt = cv->DT();
		int size = cv->Length();
		fCommand->SetTimeSchedule( dt*size, gTime() );
		if( gDebug ) { sprintf(gMsgStr,"->Rescheduling with DT = %f\n",dt*size); gPrintLog(); }
	}
	return 0;
}

//----------------------------------------------------------------------------------------
//						TMapInputPipe
//----------------------------------------------------------------------------------------
 
void TMapInputPipe::createMapName( CString& mapName, int& out_count, CString& newName ) {
	int index = 0, pre_index = 0, post_index = 0, buffer_index = 0, repeat = 0; 
	char ch, buffer[256];
	ExSchedule* s = fCommand->Schedule();
	if( s!= NULL ) { 
		if( fRepeatTime < 0.0 ) { 
			fRepeatTime = s->StartTime(); 
		}
		if( ( s->RepeatTime() > 0 ) && ( ( gTime() - fRepeatTime) >= s->RepeatTime() ) ) {
			fRepeatTime = gTime(); repeat = 1;
		}
	}
	
  CString Names[16];
  CString sep("/");
	int nelem = split( mapName, Names, 16, sep);	
	CString& name = Names[nelem-1];
	
	while( (ch = name[index++]) != 0 )	{
		if( isdigit(ch) ) { 
			pre_index = index-1; 
			buffer[ buffer_index++ ] = ch;
			break; 
		}
	}
	if( pre_index > 0 ) {
		while( (ch = name[index++]) != 0 )	{
			if( !isdigit(ch) ) { 
				post_index = index-1; 
				buffer[ buffer_index++ ] = 0;
				break; 
			}
			buffer[ buffer_index++ ] = ch;
		}
	}
	buffer[ buffer_index ] = '\0';
	if( out_count < 0 ) {
		if( buffer_index > 0 ) out_count = atoi(buffer);
		else out_count = 0;
		_first_index = out_count;
	} else if( repeat ) {
		out_count = _first_index;
	}
	if( buffer_index > 0 ) {
		CString name1 =  name.before(pre_index);
		name1.appendIndex(out_count); 
		if( post_index > 0 ) {
			name1 += name.from(post_index);
		}
		name = name1;
	} else  {
		if( out_count > 0 ) {
			name.appendIndex(out_count); 
		}
	}
	newName = Names[0];
	for( int i=1; i<nelem; i++ ) { newName += sep; newName += Names[i]; }
	out_count++;
}
    
int TMapInputPipe::Execute() {
	if( Env::UseMPE() ) { return 0; }
	CAuxVariable* sv = (CAuxVariable*)fConfigObject;
	Module* m = sv->GetModule();
	LayerConfig* lc = m->getLayerConfig();
	CString mapName;
	createMapName(fMapName,_out_count,mapName);
	if( fMapSource == "F" ) {
		if( ! Util::is_integer ( fFormat.chars()  ) ) { 
			sprintf(gMsgStr,"Float map configuration d(F,<mapname>,index) must have column index (3rd arg): %s ", fFormat.chars());
			gFatal(); 
		}
		CPathString pathName(Env::DataPath());  
		pathName.Add(mapName);
		sv->ReadFloatData( pathName.chars(), atoi( fFormat.chars() )  );
	} else if ( fMapSource == "g" ) {
		CPathString pathName(Env::DataPath());  
		pathName.Add(mapName);
		sv->readGeometryFile( pathName.chars(),  lc );
	} else {
		if( fFormat.equals_nocase("multigrid") ) {
			int map_index = 0;
			int iL0 = lc->CellLayer(), iL1 = iL0 + lc->Dim( 2 );
			for( int iL = iL0; iL < iL1; iL++ ) {
			  CString map_name(mapName);  
			  map_name.appendIndex(map_index++);
			  if( fMap.Read( fMapSource, map_name, 0, lc ) < 0 ) return -1;
			  sv->CopyFromMap( fMap, iL );	
			  if( map_index == 1 ) {
				if( fMap.GetObjInfo(TMap::kMapClass) == kClassMap ) { 
					sv->SetCategories(fMap.CatMap()); 
				}		  
			  }
			}			
		} else {
		  const char* format = ( (fFormat == "cln.grd") || (fFormat == "") ) ? ((const char*)NULL) : fFormat.chars();
		  if( fMap.Read( fMapSource, mapName, 0, lc, format ) < 0 ) return -1;
		  int iL0 = lc->CellLayer(), iL1 = iL0 + lc->Dim( 2 );
		  for( int iL = iL0; iL < iL1; iL++ ) {
			sv->CopyFromMap( fMap, iL );
		  }		
		  if( fMap.GetObjInfo(TMap::kMapClass) == kClassMap ) { 
			  sv->SetCategories(fMap.CatMap()); 
		  }
		}
	}
	sv->GrabMemory();
	return 0;
}

int TMapInputPipe::ReadCategories() {
	CAuxVariable* sv = (CAuxVariable*)fConfigObject;
	fMap.ReadCategories( fMapSource, fMapName );
	sv->SetCategories( fMap.CatMap() );
	return 0;
}

int TMapInputPipe::Config( TConfigData& cd ) {
  const CString& cmd = cd.Cmd();
	if( cmd == "OS" || cmd == "OT" ) {
		Var()->SetF(FisConstant,False,"TMapInputPipe::Config");		
	} else {
		MapInputPipe::Config(cd);
		if( GetObjInfo(kMapClass) == kSurfaceMap ) {
			fMap.SetObjInfo(TMap::kMapClass,kSurfaceMap);
		}
		else if( GetObjInfo(kMapClass) == kClassMap ) {
			fMap.SetObjInfo(TMap::kMapClass,kClassMap);
		}
		fMap.SetByteConversion(fS[1],fS[0]);
	}
  return 0;
}


//----------------------------------------------------------------------------------------
//						TDBaseInputPipe
//----------------------------------------------------------------------------------------


int TDBaseInputPipe::Execute() {
	if( Env::BatchIndex() > 0 ) { return 0; }
	Variable* v = GetMap(0);
	if( v == NULL ) { 
		sprintf(gMsgStr,"No map %s defined for DBase Parameter", Map( 0 ).chars() );
		gFatal(); 
	}
	if( v->GetF(FisImport) ) { v = v->Connection(); }
	if( v->GetCInfo(Variable::kInitMode) != Variable::kMap ) { 
		sprintf(gMsgStr,"DBase Parameters must depend on map Variables (%s:%s is not a map Variable)", v->GetModule()->Name(), v->Name() );
		gFatal(); 
	}
	if( GetObjInfo(kOrder) == 4 ) {
#ifdef POSTGRESS
		ArgArray atmp(fMap);
		atmp.ShiftLow();
		((CAuxVariable*)fConfigObject)->ReadDBase( fFileName, fSQLRec, atmp );
	} else if( GetObjInfo(kOrder) == 0 ) {
		((CAuxVariable*)fConfigObject)->ReadDBase( fFileName, fSQLRec, fMap );
#endif
	} else if( GetObjInfo(kOrder) == 3 ) {
		((CAuxVariable*)fConfigObject)->ReadArrayParameter( fFileName );
	} else if( GetObjInfo(kOrder) == 10 ) {
		((CAuxVariable*)fConfigObject)->SetDBParamValues();
	} else {
		((CAuxVariable*)fConfigObject)->ReadDBase( fFileName, fIndex[0], fIndex[1], fIndex[2] );
	}
	return 1;
}

int TDBaseInputPipe::Config( TConfigData& cd ) {
  int rv = DBaseInputPipe::Config(cd);
  if( rv ) { ((Variable*)fConfigObject)->RemoveCommandsFromList( "m10" ); }
	if ( GetObjInfo(kOrder) ) {
			((CAuxVariable*)fConfigObject)->SetCInfo(CAuxVariable::kDBOrder,GetObjInfo(kOrder));
	}
#ifdef POSTGRESS
  if( GetObjInfo(kOrder) == 4 || GetObjInfo(kOrder) == 0 ) { 
		fSQLRec = pgSQLRec::GetSQLRec(fFunctionName); 
	}
#endif
	return rv;
}

