//----------------------------------------------------------------------------------------
//	TPipe.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __TPipe__
#define __TPipe__

#include "CnfgProcessor.h"
#include "CVariable.h"
#include "float.h"
#include "XGraph.h"
#include "MML_Time.h"
#include "MML_Pipe.h"
#include "TMap.h"
#include "Series.h"
#include "TDataSet.h"
#include "sme_postgres.h"
#include "assoc.h"

typedef class TVariable TVariable;
typedef class TPipeCommand TPipeCommand;
typedef class DBaseInputPipe DBaseInputPipe;

//----------------------------------------------------------------------------------------
//						TPipe
//----------------------------------------------------------------------------------------

const int  kDisplayWidth = 500;
const int  kDisplayHeight = 500;

class  TPipe  {	
 
protected:
#ifdef HAS_X
  static Xgraph* fXgraph;
#endif
  byte fInfo[8];
  int fStep;
  static int fPipeIndex;

public:

  enum EInfo { kOutMode };
  
  TPipe() { fStep = 1; }
  void SetPInfo( EInfo index, byte val ) { fInfo[index] = val; }
  byte GetPInfo( EInfo index ) { return fInfo[index]; }

  inline void CreateDisplay() { 
#ifdef HAS_X
    if( gIProc == 0 ) {
      if(fXgraph==NULL) fXgraph = new Xgraph( kDisplayWidth, kDisplayHeight );
    }
#endif
  }
  static Pipe* GetPipeFromConfig( TConfigData& cd, TConfigObject* cobj, TPipeCommand*& pc  );  
  static DBaseInputPipe* GetDBaseInputPipe( const char* n, TVariable* v );
	inline virtual void Reset() { ; } 

};

//----------------------------------------------------------------------------------------
//						TAnimPipe
//----------------------------------------------------------------------------------------


class  TAnimPipe : public AnimPipe, public TPipe {
protected:
  TMap* fMap;
  ByteGrid* fRegion_map;
  int fAnimationIndex;
  int fAnimatorType;
  static 	TNamedObjectList  fGlobalViewers;
  
public:

  TAnimPipe( const char* name, TVariable* var );
	TAnimPipe( const char* name, ByteGrid* region_map );

  virtual int Config( TConfigData& cd );
  virtual int Execute();
  int DisplayVariable( Variable* dvar );
  virtual int Initialize();
	void GetMaps();
	inline ByteGrid* RegionMap() { return fRegion_map; }
	
	static TAnimPipe* GetGlobalViewer( ByteGrid* m, const CString& mname );
	inline virtual void Reset() { AnimPipe::Reset(); TPipe::Reset();  } 
};

//----------------------------------------------------------------------------------------
//						TDataDisplayPipe
//----------------------------------------------------------------------------------------


class  TDataDisplayPipe : public DataDisplayPipe, public TPipe {
protected:
	int fTimeBufferSize;
	int fStep_count;
	int fDataFormat;
	byte fMode;
	ByteGrid* fRegion_map;
	DataSet* fDataSet;
  static 	TNamedObjectList  fGlobalViewers;
  static DataSet* fParameterDataSet;
	  
public:

  TDataDisplayPipe( const char* name, TVariable* var );
	TDataDisplayPipe( const char* name, ByteGrid* region_map, TVariable* var );

  virtual int Config( TConfigData& cd );
	inline ByteGrid* RegionMap() { return fRegion_map; }
  virtual int Execute();
  inline byte Mode() { return fMode; }
  inline void setBrowseMode( byte mode ) { fMode = mode; }
  virtual int Initialize();
  inline void setVariable( CVariable* v ) { fConfigObject = v; } 
  static TDataDisplayPipe* GetGlobalViewer( CVariable& v, byte mode=0 );
  static int DisplayData( const char* display_name, float* fd, float fmax, float fmin, int s0, int s1, int s2 = 1   ); 

	inline virtual void Reset() { DataDisplayPipe::Reset(); TPipe::Reset(); fStep_count = 0;  } 
	
};

//----------------------------------------------------------------------------------------
//						TSocketPipe
//----------------------------------------------------------------------------------------


class  TSocketPipe : public SocketPipe, public TPipe {

 int SendBlockData(TMap*);
 
protected:
  TMap* fMap;
public:

  TSocketPipe( const char* name, TVariable* var );

  virtual int Config( TConfigData& cd );
  virtual int Execute();
  virtual int Initialize();
	inline virtual void Reset() { SocketPipe::Reset(); TPipe::Reset();  } 
};



//----------------------------------------------------------------------------------------
//						TPointPipe
//----------------------------------------------------------------------------------------


class  TPointPipe : public PointPipe, public TPipe {

public:

  TPointPipe::TPointPipe( const char* name, EType type,  CVariable* var, Point2& point ) : PointPipe(name,type,(Variable*)var,point) {;}
  TPointPipe::TPointPipe( const char* name, EType type,  CVariable* var ) : PointPipe(name,type,(Variable*)var)  {;} 

  virtual int Initialize();
	inline virtual void Reset() { PointPipe::Reset(); TPipe::Reset();  } 
};

//----------------------------------------------------------------------------------------
//						TGraphPipe
//----------------------------------------------------------------------------------------


class  TGraphPipe : public GraphPipe, public TPipe {
protected: 

	int fComponentIndex;
	static TAssoc_array fGraphs;
	float fDT;
public:

  TGraphPipe( const char* name, TVariable* var );

  virtual int Config( TConfigData& cd );
  virtual int Execute();
  virtual int Initialize();
  static int GraphData( CVariable* dvar, const char* graph_name, const char* timeseries_name, float* fd=NULL, 
																		int ds=0, Bool overwrite = False, int array_index = -1  ) ;
  inline virtual void Reset() { GraphPipe::Reset(); TPipe::Reset();  } 
};

//----------------------------------------------------------------------------------------
//						TSheetPipe
//----------------------------------------------------------------------------------------

class  TSheetPipe : public SheetPipe, public TPipe {
protected: 
#ifdef HAS_X 
  TSheet* fSheet;
#endif

public:

  TSheetPipe( const char* name, TVariable* var );

  virtual int Config( TConfigData& cd );
  virtual int Execute();
  virtual int Initialize();
	inline virtual void Reset() { SheetPipe::Reset(); TPipe::Reset();  } 
};

//----------------------------------------------------------------------------------------
//						TMapArchivePipe
//----------------------------------------------------------------------------------------

class  TMapArchivePipe : public MapArchivePipe, public TPipe {
protected:
  TMap fMap;
  DataSet* fDataSet;
  int fWriteIndex;

public:

  TMapArchivePipe( const char* name, TVariable* var );

  virtual int Config( TConfigData& cd );
  virtual int Execute();
  virtual int Initialize();
  virtual int Finalize();
  
  inline virtual void Reset() { MapArchivePipe::Reset(); TPipe::Reset();  } 
  FILE* open_output_file(const char* suffix);
};

/*
class  TWindowPipe : public WindowPipe, public TPipe {

protected:

  TMap fMap;
  CellPlex fWindowSet;

  void MakeWindowSet();

public:

  TWindowPipe( const char* name, EType type, TVariable* var );
  TWindowPipe( const char* name,  TVariable* var );

  virtual int Config( TConfigData& cd );
  virtual int Initialize();
  virtual int Execute();
  virtual int Finalize() { return 0;}
};
*/
//----------------------------------------------------------------------------------------
//						TPtSeriesPipe
//----------------------------------------------------------------------------------------

class  TPtSeriesPipe : public PtSeriesPipe, public TPipe {
protected:
  TLocalSeries fData;

public:

  TPtSeriesPipe( const char* name, TVariable* var );

  virtual int Config( TConfigData& cd );
  virtual int Initialize();
  virtual int Execute();
  virtual int Finalize();
  inline virtual void Reset() { Finalize(); PtSeriesPipe::Reset(); TPipe::Reset();  } 
};

//----------------------------------------------------------------------------------------
//						TCondensePipe
//----------------------------------------------------------------------------------------

class  TCondensePipe : public CondensePipe, public TPipe {
protected:
  TTemporalTimeSliceRPlex fTData;
  TDataSet fCData;
  CellPlex fWindowSet;
 
  inline float Condense();

  void MakeWindowSet();
  
public:

  TCondensePipe( const char* name, TVariable* var );

  virtual int Config( TConfigData& cd );
  virtual int Initialize();
  virtual int Execute();
  virtual int Finalize();
	inline virtual void Reset() { CondensePipe::Reset(); TPipe::Reset();  } 
};

//----------------------------------------------------------------------------------------
//						TimeSeriesInputPipe
//----------------------------------------------------------------------------------------

class TTimeSeriesInputPipe : public TimeSeriesInputPipe {

public:

  TTimeSeriesInputPipe( const char* name, TVariable* var );
   virtual int Execute();  
	inline virtual void Reset() { TimeSeriesInputPipe::Reset();  } 

};

//----------------------------------------------------------------------------------------
//						PtTimeSeriesInputPipe
//----------------------------------------------------------------------------------------

class TPtTimeSeriesInputPipe : public PtTimeSeriesInputPipe {
protected:

public:

  TPtTimeSeriesInputPipe( const char* name, TVariable* var ); 
  virtual int Execute();
	inline virtual void Reset() { PtTimeSeriesInputPipe::Reset();  } 
};

//----------------------------------------------------------------------------------------
//						DBaseInputPipe
//----------------------------------------------------------------------------------------

class TDBaseInputPipe : public DBaseInputPipe {
protected:
#ifdef POSTGRESS
	pgSQLRec* fSQLRec;
#endif
		
public:

  TDBaseInputPipe( const char* name, TVariable* var ) : DBaseInputPipe( name, (Variable*) var ) { 
#ifdef POSTGRESS
	fSQLRec=NULL;
#endif
  }
  virtual int Execute(); 
  int ReadCategories();
  virtual int Config( TConfigData& cd );
	inline virtual void Reset() { DBaseInputPipe::Reset();  } 

};

//----------------------------------------------------------------------------------------
//						MapPipe
//----------------------------------------------------------------------------------------

class TMapInputPipe : public MapInputPipe {
protected:

  TMap fMap;
  int _out_count;
  int _first_index;
  
  void createMapName( CString& mapName, int& out_count, CString& newName ); 

public:

  TMapInputPipe( const char* name, TVariable* var ) : MapInputPipe( name, (Variable*) var ) { _out_count=-1;}
  virtual int Execute();
  int ReadCategories(); 
  int Config( TConfigData& cd );
  inline virtual void Reset() { MapInputPipe::Reset(); _out_count=-1; } 
};



#endif
