#include "UserCode.h"
#include "SSModel.h"

#define iabs(x) (((x)>0) ? (x) : -(x))

/*********************************************************************************************/

float UserCode::fAlpha[10] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };
int UserCode::fNAlpha = 0;
float UserCode::fBeta[10] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };
int UserCode::fNBeta = 0;

/*********************************************************************************************/
			
int UserCode::Config(TConfigData& cd) {
  const CString& cmd = cd.Cmd();
  if(gDebug) { 
    sprintf(gMsgStr,"Reading UserCode Config: Nargs = %d, CMD = %s", cd.NArgs(), cmd.chars() );	
    gPrintLog();  
  }

	if ( cmd == "a" ) {
    if( cd.FloatArg(0,fAlpha[0],CD::kRequired ) > 0 ) { fNAlpha = 1;
			if( cd.FloatArg(1,fAlpha[1]) > 0 ) { fNAlpha = 2;
				if( cd.FloatArg(2,fAlpha[2]) > 0 ) { fNAlpha = 3;
					if( cd.FloatArg(3,fAlpha[3]) > 0 ) { fNAlpha = 4;
						if( cd.FloatArg(4,fAlpha[4]) > 0 ) { fNAlpha = 5; }
					}
				}
			}
		}
  } else if ( cmd == "b" ) {
    if( cd.FloatArg(0,fBeta[0],CD::kRequired ) > 0 ) { fNBeta = 1;
			if( cd.FloatArg(1,fBeta[1]) > 0 ) { fNBeta = 2;
				if( cd.FloatArg(2,fBeta[2]) > 0 ) { fNBeta = 3;
					if( cd.FloatArg(3,fBeta[3]) > 0 ) { fNBeta = 4;
						if( cd.FloatArg(4,fBeta[4]) > 0 ) { fNBeta = 5; }
					}
				}
			}
		}
  } else return 0;
  return 1;
}

/*********************************************************************************************/




