# when executed by SME -exec, runs a simulation for the number of timesteps
# specified in the env variable TSTEPS and writes all the variables in the
# files given in the list SAVEVARS, in the directory specified in SIMDIR. The
# env vars CUR_PARM_NAMES and CUR_PARM_VALS can be used to override certain
# parameter values.

global env TSTEPS SAVEVARS SIMDIR CUR_PARM_NAMES CUR_PARM_VALS

proc read_parmfile {file} {

    # read file and return contents
    # as a list of lines
    
    set retl {}
    set l 1
    set fp [open $file r]
    while {[gets $fp line] >= 0} {
	if {[llength $line] == 0} {
	    continue
	}
	lappend retl $line
	incr l
    }
    close $fp
    return $retl
}

set CUR_PARM_NAMES {}
set CUR_PARM_VALS  {}
set TSTEPS         1
set SIMDIR         .
set SAVEVARS       {}

set envv [array names env]


if {[lsearch -exact $envv SIMDIR] != -1} {
    set SIMDIR $env(SIMDIR)
}

set fp [open $SIMDIR/sme_run.log w]

if {[lsearch -exact $envv CUR_PARM_NAMES] != -1} {
    set CUR_PARM_NAMES $env(CUR_PARM_NAMES)
} elseif {[lsearch -exact $envv CUR_PARM_NAMES_FILE] != -1} {
    set CUR_PARM_NAMES [read_parmfile $env(CUR_PARM_NAMES_FILE)]
    puts $fp "setenv CUR_PARM_NAMES_FILE $env(CUR_PARM_NAMES_FILE)"
}

if {[lsearch -exact $envv CUR_PARM_VALS] != -1} {
    set CUR_PARM_VALS $env(CUR_PARM_VALS)
} elseif {[lsearch -exact $envv CUR_PARM_VALS_FILE] != -1} {
    set CUR_PARM_VALS [read_parmfile $env(CUR_PARM_VALS_FILE)]
    puts $fp "setenv CUR_PARM_VALS_FILE $env(CUR_PARM_VALS_FILE)"
}

if {[lsearch -exact $envv SAVEVARS] != -1} {
    set SAVEVARS $env(SAVEVARS)
} elseif {[lsearch -exact $envv SAVEVARS_FILE] != -1} {
    set SAVEVARS [read_parmfile $env(SAVEVARS_FILE)]
    puts $fp "setenv SAVEVARS_FILE $env(SAVEVARS_FILE)"
}

if {[lsearch -exact $envv TSTEPS] != -1} {
    set TSTEPS $env(TSTEPS)
    puts $fp "TSTEPS = $TSTEPS"
}

close $fp 
set fp [open $SIMDIR/sme_run.log a]

puts $fp "SME configure debugLevel 0"
SME configure debugLevel 0

puts $fp "SME configure schedule 1 0 $TSTEPS"
SME configure schedule 1 0 $TSTEPS

for {set i 0} {$i < [llength $CUR_PARM_NAMES]} {incr i} {

    puts $fp "[lindex $CUR_PARM_NAMES $i] configure parameter [lindex $CUR_PARM_VALS $i]"

    # reconfigure
    if [catch {[lindex $CUR_PARM_NAMES $i] configure parameter [lindex $CUR_PARM_VALS $i]} dio] {
	puts $fp $dio
    }
}

# launch
SME run $TSTEPS

# write data to files
foreach i $SAVEVARS {
    $i dump -txt $SIMDIR/[lindex [split $i .] 1]
    puts $fp "$i dump -txt $SIMDIR/[lindex [split $i .] 1]"
}

close $fp
exit 0







