//-*-Mode: C++;-*-
#ifndef _ControlSocket_h_
#define _ControlSocket_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

#ifdef JAVA

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

typedef const char* (*ExecuteCommandFn) (char* cmdList, int* cmd_code, int * repeat, void* interp );

#ifdef USE_MPI 
#include "mpi.h"
#endif

inline void reformat( char* msg ) {  // includes termination char
  if (msg == NULL) { return; }
  while (*msg != 0) { 
	if( iscntrl( *msg ) ) { *msg = ';'; }
	msg++;
  }
}

class JavaSocketReader {
	static char _host[256];
	static int _port;
	static int _debug; 
	static int _initialized; 
	static int _startup_control_panel;
	static int     _socket;
	static int     _stream_socket;
	static int     _rank;

#ifdef USE_MPI
	static MPI_Comm fComm;
#endif

	static FILE* inStream;
	static FILE* outStream;
	static inline void fatal(char* str) { printf(str); exit(0); }
	static void openStreams(int s);
	static int listen_for_connection();
	static int create_socket(); 
	static int create_socket1(); 
	static void sendTelnetMessage( int code, const char* message );
public:
	static void startupControlSocket();
	static int init( int argc, char *argv[] );
	static int initializeSocket(const char* host="localhost", int port = -1, int debug=0 );
	static int connect1();
	static inline void sendErrorMessage( char* message ) { 
	  if( _socket != -1 ) { if( _rank==0) { reformat(message); sendTelnetMessage( 590, message ); } } }
	static void closeConnection();
	static const char* processMessages(char* buf, int useSocket, void* interp, ExecuteCommandFn ecf );
	static inline FILE* IStream() { return inStream; }
	static inline FILE* OStream() { return outStream; }
};


#endif
#endif
