#ifdef JAVA

#include "datasocket.h"
#include <string.h>

extern "C" {
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <unistd.h>
}

FILE* DataSocket::_logStream = NULL;

DataSocket::DataSocket( char* host, int port ) {
	strncpy(_host,host,511);
	_port = port;
	_socket_desc = -1;
	_bufferPtr = 0;
	_buffer_size = 0;
	_buffer = NULL;
	_connected = 0;
	_byteFormat = 3;
	_procnum = myID(); 
}

int DataSocket::setupDataFormats() {
	jbyte bigendian = getByteOrdering();
	_byteFormat = bigendian;

	jbyte code = 100;
	writeBytes(&code,1,1);
	writeBytes(&bigendian,1,1);
/*
	if( bigendian ) {
		jbyte test_success;
		jint itest = -12345;
		jfloat ftest = -12345.0;
		_byteFormat = 2;                         // set to maximum compatibility mode
		writeInts(&itest,1,1);
		writeFloats(&ftest,1,1);
		flush();
		readBytes(&test_success,1);
		if( test_success == 0 ) {
			_byteFormat = 1;        //  Not java compatible, reduce compatibility mode;
		}
	} else { 	flush(); }
*/
	flush();
	return _byteFormat;
}
		
int DataSocket::connect1() {

  // create socket and connects to server 

  // tbi set options
  //  (*_sock[rep])->recvtimeout(_timeout);
  //  (*_sock[rep])->recvbufsz(_bufsize);
  // set sockaddr for connect()
	if( !_connected ) {
		sockaddr_in sin; 
		memset((char*)&sin, '\0', sizeof(sin));
		sin.sin_port = htons(_port);      
		if ((sin.sin_addr.s_addr = inet_addr((char*)(const char*)_host)) == -1)  {
			hostent* hp = gethostbyname((char*)(const char*)_host);
			if (hp != NULL)  {
				memcpy(&(sin.sin_addr), hp->h_addr, hp->h_length);
				sin.sin_family = hp->h_addrtype;
			}
		}
		else sin.sin_family = AF_INET;  
		_socket_desc = socket(sin.sin_family, SOCK_STREAM, 0);
		if (_socket_desc < 0) return 0;

		if (::connect(_socket_desc, (sockaddr*)&sin, sizeof(sin)) == 0) {
			_connected = 1;
		} else {
			_connected = 0;
		}
		if( _connected ) {
			print3( "Opened socket on host ", _host );
			print2( "port ",_port);
		}
	} 
	return _connected;
}

void DataSocket::disconnect( ) {
		if(  _connected ) {
			close(_socket_desc);
			_connected = 0;
		} 
}   

#endif
