#ifdef JAVA

#include "viewserver.h"
#include "datasocket.h"
#include "Environ.h"
#include "limits.h"
#include "ctype.h"
#include "stdlib.h"
#include <jni.h>

// #include "Environ.h"

DataSocket* ViewServer::_ds = NULL;
char ViewServer::_host[256];
int ViewServer::_port = 17726;
FILE* ViewServer::_logStream = NULL; 
int ViewServer::_debug = 0; 
int ViewServer::_initialized = 0; 
int ViewServer::_simulation_initialized = 0; 
int ViewServer::_buffer_size = 0;
unsigned short* ViewServer::_data_buffer = NULL;
int ViewServer::_startup_listener = 0;
int ViewServer::_timeout = 60;
int ViewServer::_dataset_index = 0;

char* ViewServer::_proj_name = NULL;
char* ViewServer::_model_name = NULL;
char* ViewServer::_proj_path = NULL; 

int ViewServer::SECONDS = 1;
int ViewServer::DAYS = 2;
int ViewServer::MONTHS = 3;
int ViewServer::YEARS = 4;

int ViewServer::BYTES = 1;
int ViewServer::SHORTS = 2;
int ViewServer::INTS = 3;
int ViewServer::FLOATS = 4;
int graph_indices[64] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

inline static int slen(const byte* t) // inline  strlen
{
  if (t == NULL) return 0;
  else {
    const byte* a = t;
    while (*a++ != 0);
    return a - 1 - t;
  }
}

inline int is_integer ( const char *target_str) {
  int i=-1,first_num=0;
  char ch;

  while( (ch=target_str[++i]) != '\0' ) { 
    if( isdigit(ch) ) first_num=1;
    if( (ch=='-' || ch=='+') && first_num ) return(0);  
    if( !( isspace(ch) || isdigit(ch) || ch=='-' || ch=='+') ) return(0);  
  }
  return(1);	  	
}

int ViewServer::init( int argc, char *argv[] ) {
	char* host = NULL;
	int port = -1;
	int debug = 0;

	for(int i=0; i<argc; i++) {

	  if( strcmp(argv[i],"-VSdebug") == 0 ) {
		if( (i+1) < argc && is_integer(argv[i+1]) )  { 
		  debug=atoi(argv[i+1]); 
		  DataSocket::print2("\nSetting ViewServer debug level to ", debug );
		} else { DataSocket::print3("Incorrect VS argument: ", argv[i+1] ); } 
	  }  else  if( strcmp(argv[i],"-VSport") == 0 ) {
		if( (i+1) < argc && is_integer(argv[i+1]) )  { 
		  port=atoi(argv[i+1]); 
		  DataSocket::print2("\nSetting port to ",port);
		} else { DataSocket::print3("Incorrect VS argument: ", argv[i+1] ); } 
	  }  else  if( strcmp(argv[i],"-VSstart") == 0 ) {
		  int vsstart = 0;
		  if( (i+1) < argc && is_integer(argv[i+1]) )  { 
			vsstart=atoi(argv[i+1]); 
		  } else { DataSocket::print3("Incorrect VS argument: ", argv[i+1] ); } 
		  if( vsstart ) {
			_startup_listener = vsstart;
			DataSocket::print("\nWill startup java ViewServer listener on localhost\n");
		  }
	  }   else  if( strcmp(argv[i],"-VStimeout") == 0 ) {
		if( (i+1) < argc && is_integer(argv[i+1]) )  { 
		  _timeout=atoi(argv[i+1]); 
		} else { DataSocket::print3("Incorrect VS argument: ", argv[i+1] ); } 
	  } 
	  else if ( strcmp(argv[i],"-VShost") == 0 ) {
		if ((i+1) < argc) { 
		  host = argv[++i]; 
		  if( host ) { DataSocket::print3("\nSetting host to ",host); }
		} else { DataSocket::print3("Incorrect VS argument: ", argv[i+1] ); } 
	  }
	  else if( argv[i] == "-VShelp" ) {
		DataSocket::print("JST generic command line Arguments:");
		DataSocket::print(" -VSdebug <debug>    Set debug level: (default 0)");
		DataSocket::print(" -VShost <host>      Set display host ( default: localhost )");
		DataSocket::print2(" -VSport <port>      Set port of java ViewServer listener on display host, default: ",_port);
		DataSocket::print(" -VSstart            Startup java ViewServer listener on localhost");
		DataSocket::print(" -VS3D               Use 3D Viewers");
		exit(0);
	  } 
	}
	
	if( host ) { sprintf(_host,host); }
	else { sprintf(_host,"localhost"); }
	if ( port > 0 ) { _port = port; }
	_debug = debug;
	_initialized = 1;
	return _timeout;
}

int ViewServer::config( const char* host, int port ) {
  if( port > 0 ) { _port = port; }
  if( host != NULL ) { strcpy(_host,host); }
  return 1;
}

int ViewServer::connect() {
	if( DataSocket::myID() != 0 ) return 0; 
	if( _ds == NULL ) {
		char java_cmd[2048];
		if( _initialized == 0 ) {
			DataSocket::print("ViewServer not initialized");
			return 0;
		}
				
		if( _startup_listener ) {
		  if( _debug == 1) {	
//			  sprintf(java_cmd,"%s/startup_viewserver -d -p %d", BIN_DIR, _port );
			  sprintf(java_cmd,"startup_viewserver -d -p %d  -scen %s xxx &", _port, Env::ScenarioName().chars()   );
		  } else {
//			  sprintf(java_cmd,"%s/startup_viewserver -p %d", BIN_DIR, _port );
			  sprintf(java_cmd,"startup_viewserver -p %d  -scen %s zzz &", _port, Env::ScenarioName().chars()  );
		  }
		  DataSocket::print3( " Executing java command-> ", java_cmd );  
		  if ( _debug < 2 ) { system(java_cmd); }   // fire up java listener.
		}
		
		_ds = new DataSocket(_host,_port);
		int cnt=0;
		sprintf( java_cmd, "  %s, port %d ",_host,_port); 
		while(1) {
			if( _ds->connect1() ) break;
			DataSocket::print3( "Attempting to connect to ViewServer ( you may need to start up Viewserver with startup_viewserver script ) on host ",java_cmd);
			if( cnt++ == _timeout ) { 
				DataSocket::print3( " Can't connect to server at " , java_cmd ); 
				_initialized = 0;
				_ds = NULL;
				return 0;
			}
			sleep(3);
		}
		
		do_init_simulation(); 
		_ds->setupDataFormats();
	}
	return 1;
}

byte ViewServer::create_2D_animator(int w, int h, byte type, byte* region_map, const byte* name ) {
	static jbyte index = 0; 
	if( connect() > 0 ) {
	  jbyte code = 2;
	  jint width = (jint) w;
	  jint height = (jint) h;
	  jbyte animator_type = (jbyte)type;
	  jbyte has_region_map = ( region_map != NULL );
	  jbyte namelen = (jbyte)slen(name);
	  _ds->writeBytes(&code,1,1);
	  _ds->writeInts(&width,1,1);
	  _ds->writeInts(&height,1,1);
	  _ds->writeBytes(&animator_type,1,1);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes(&index,1,1);
	  _ds->writeBytes(&has_region_map,1,1);
	  _ds->writeBytes((const jbyte*)name,namelen,1);
	  if( has_region_map ) { _ds->writeBytes((jbyte*)region_map,width*height,1); }
	  _ds->flush();
	}
	return index++;
}

void ViewServer::init_simulation( const char* proj_name, const char* model_name, const char* proj_path  ) {
  if( _simulation_initialized == 0 ) {
	jbyte namelen;
	namelen = (jbyte)slen((const byte*)proj_name);
	_proj_name = new char[namelen+1];
	strcpy(_proj_name,proj_name);
	namelen = (jbyte)slen((const byte*)model_name);
	_model_name = new char[namelen+1];
	strcpy(_model_name,model_name);
	namelen = (jbyte)slen((const byte*)proj_path);
	_proj_path = new char[namelen+1];
	strcpy(_proj_path,proj_path);
	_simulation_initialized = 1;	
	do_init_simulation();
  }
}

void ViewServer::do_init_simulation() {
	if( _ds != NULL && _simulation_initialized ) {
	  jbyte namelen, code = 13;
	  _ds->writeBytes(&code,1,1);
	  namelen = (jbyte)slen((const byte*)_proj_name);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes((const jbyte*)_proj_name,namelen,1);
	  namelen = (jbyte)slen((const byte*)_model_name);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes((const jbyte*)_model_name,namelen,1);
	  namelen = (jbyte)slen((const byte*)_proj_path);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes((const jbyte*)_proj_path,namelen,1);
	  _ds->flush();
	  _dataset_index = 0;
	} 
}

int ViewServer::create_dataset(int L0, int L1, int L2, byte dim, byte array_dim, byte* region_map, const byte* name, const char* categories, byte format, int mode ) {
	if( connect() > 0 ) {
	  jbyte code =  11 - mode;
	  jint l0 = (jint) L0;
	  jint l1 = (jint) L1;
	  jint l2 = (jint) L2;
	  jbyte data_dim = (jbyte)dim;
	  jbyte adim = (jbyte)array_dim;
	  jbyte data_format = (jbyte)format;
	  jbyte has_region_map = ( region_map != NULL );
	  jshort namelen = (jshort)slen(name);
	  jshort catslen = ( categories == NULL ) ?  0 : strlen(categories);
	  _ds->writeBytes(&code,1,1);
	  jshort index = (jshort)_dataset_index;
	  _ds->writeShorts(&index,1,1);
	  _ds->writeShorts(&namelen,1,1);
	  _ds->writeShorts(&catslen,1,1);
	  _ds->writeBytes(&data_dim,1,1);
	  _ds->writeBytes(&adim,1,1);
	  _ds->writeBytes(&data_format,1,1);
	  _ds->writeBytes(&has_region_map,1,1);	
	  _ds->writeInts(&l0,1,1);
	  _ds->writeInts(&l1,1,1);
	  _ds->writeInts(&l2,1,1);
	  _ds->writeBytes((const jbyte*)name,namelen,1);
	  if( categories != NULL ) { _ds->writeBytes((const jbyte*)categories,catslen,1); }
	  if( has_region_map ) { _ds->writeBytes((jbyte*)region_map,l0*l1,1); }
	  _ds->flush();
	  return _dataset_index++;
	}
	return 0;
}

byte ViewServer::create_3D_animator(int w, int h, int nimages, byte* region_map, const byte* name ) {
	if( connect() > 0 ) {
	  jbyte code = 7;
	  jint width = (jint) w;
	  jint height = (jint) h;
	  jint max_images = (jint) nimages;
	  jbyte has_region_map = ( region_map != NULL );
	  static jbyte index = 0; 
	  jbyte namelen = (jbyte)slen(name);
	  _ds->writeBytes(&code,1,1);
	  _ds->writeInts(&width,1,1);
	  _ds->writeInts(&height,1,1);
	  _ds->writeInts(&max_images,1,1);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes(&index,1,1);
	  _ds->writeBytes(&has_region_map,1,1);
	  _ds->writeBytes((const jbyte*)name,namelen,1);
	  if( has_region_map ) { _ds->writeBytes((jbyte*)region_map,width*height,1); }
	  _ds->flush();
	  return index++;
	}
	return 0;
}

byte ViewServer::create_3D_ContourViewer(int length0, int length1, int length2, int nimages, const byte* name ) {
	if( connect() > 0 ) {
	  jbyte code = 9;
	  jint l0 = (jint) length0;
	  jint l1 = (jint) length1;
	  jint l2 = (jint) length2;
	  jint max_images = (jint) nimages;
	  static jbyte index = 0; 
	  jbyte namelen = (jbyte)slen(name);
	  _ds->writeBytes(&code,1,1);
	  _ds->writeInts(&l0,1,1);
	  _ds->writeInts(&l1,1,1);
	  _ds->writeInts(&l2,1,1);
	  _ds->writeInts(&max_images,1,1);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes(&index,1,1);
	  _ds->writeBytes((const jbyte*)name,namelen,1);
	  _ds->flush();
	  return index++;
	}
	return 0;
}

void ViewServer::send_animation_frame( byte index, int size, int* data, float time, const byte* info  ) {
	  int ival, imax = INT_MIN, imin = INT_MAX;
	  int *data_ptr = data, *data_end = data + size;
	  do {
		  ival = *data_ptr;
		  imax = ( ival > imax ) ? ival : imax;
		  imin = ( ival < imin ) ? ival : imin;
	  } while( ++data_ptr < data_end );

	  send_animation_frame( index, size, data, imax, imin, time, info  );
}

void ViewServer::send_animation_frame( byte index, int size, int* data, int max_val, int min_val, float time, const byte* info   ) {
	  float scale[2] = { max_val, min_val };
	  if( sizeof(short) != 2 ) { DataSocket::print2("Sorry, this machines does not support 2-byte shorts: ", sizeof(short)); exit(0); }
	  if( size > _buffer_size ) {
		if( _data_buffer != NULL ) delete[] _data_buffer;
		_data_buffer = new unsigned short[ _buffer_size = size ];
	  }
	  float max_short = 65534;
	  float sfactor = max_short / ( max_val - min_val );
	  int ival;
	  int *data_ptr = data, *data_end = data + size; 
	  unsigned short *sdata = _data_buffer;
	  do {
		  ival = (int) sfactor *( *data_ptr - min_val );
		  ival = ( ival < 0 ) ? 0 : ival;
		  ival = (int) ( ( ival > max_short ) ? max_short : ival );
		  *sdata++ = (unsigned short) ival;
	  } while( ++data_ptr < data_end );

	  send_animation_frame( index, size, (jshort*)_data_buffer, scale, time, info  );
}

void ViewServer::send_animation_frame( byte index, int size, float* data, float time, const byte* info ) {
	float fval, fmax = -FLT_MAX, fmin = FLT_MAX;
	float *data_ptr = data, *data_end = data + size;
	do {
		fval = *data_ptr;
		fmax = ( fval > fmax ) ? fval : fmax;
		fmin = ( fval < fmin ) ? fval : fmin;
	} while( ++data_ptr < data_end );
		
	send_animation_frame( index, size, data, fmax, fmin, time, info  );
}

void ViewServer::send_animation_frame( byte index, int size, float* data, float max_val, float min_val, float time, const byte* info   ) {
	float scale[2] = { max_val, min_val };
	if( sizeof(short) != 2 ) { DataSocket::print2("Sorry, this machines does not support 2-byte shorts: ", sizeof(short)); exit(0); }
	if( size > _buffer_size ) {
	  if( _data_buffer != NULL ) delete[] _data_buffer;
	  _data_buffer = new unsigned short[ _buffer_size = size ];
	}
	float max_short = 65534;
	float sfactor = max_short / ( max_val - min_val );
	int ival;
	float *data_ptr = data, *data_end = data + size;
	unsigned short *sdata = _data_buffer;
	do {
		ival = (int) ( sfactor *( *data_ptr - min_val ) );
		ival = ( ival < 0 ) ? 0 : ival;
		ival = (int) ( ( ival > max_short ) ? max_short : ival );
		*sdata++ = (unsigned short) ival;
	} while( ++data_ptr < data_end );
	
	send_animation_frame( index, size, (jshort*)_data_buffer, scale, time, info  );
}

void ViewServer::send_animation_frame( byte ind, int s, short* data, float scale[2], float time, const byte* info  ) {
	if( connect() > 0 ) {
	  jbyte code = 3;
	  jint size = (jint) s;
	  jbyte series_index = 0;
	  jbyte index = (jbyte) ind;
	  jbyte infolen = (jbyte)slen(info);
	  _ds->writeBytes(&code,1,1);
	  _ds->writeBytes(&index,1,1);
	  _ds->writeBytes(&series_index,1,1);
	  _ds->writeInts(&size,1,1);
	  _ds->writeBytes(&infolen,1,1);
	  if( infolen > 0 ) { _ds->writeBytes((const jbyte*)info,infolen,1); }
	  _ds->writeFloats(scale,2,1);
	  _ds->writeFloats(&time,1,1);
	  _ds->writeShorts(data,size,1);
	  _ds->flush();
  //	fprintf(stderr,"\nSending Animation Frame, size = %d\n",size); 
	}
}

void ViewServer::add_data_entry( int dataset_index, short* data, int data_size, float max, float min, float time, float dt, const byte* info, byte format ) {
	if( connect() > 0 ) {
	  jbyte code = 12;
	  jbyte form = (jbyte)format;
	  jint size = (jint) data_size;
	  jshort index = (jshort) dataset_index;
	  jshort infolen = (jshort)slen(info);

	  _ds->writeBytes(&code,1,1);
	  _ds->writeBytes(&form,1,1);
	  _ds->writeShorts(&index,1,1);
	  _ds->writeShorts(&infolen,1,1);
	  _ds->writeInts(&size,1,1);
	  if( infolen > 0 ) { _ds->writeBytes((const jbyte*)info,infolen,1); }
	  _ds->writeFloats(&max,1,1);
	  _ds->writeFloats(&min,1,1);
	  _ds->writeFloats(&time,1,1);
	  _ds->writeFloats(&dt,1,1);
	  _ds->writeShorts(data,size,1);
	  _ds->flush();
//	  fprintf(stderr,"\n  debug:: Add data Entry, bounds(%f,%f), npoints = %d, data(%f) = ",max,min,data_size,time); 
//	  int dsize = ( data_size < 10 ) ? data_size : 10;
//	  for( int i=0; i<dsize; i++ ) { fprintf(stderr," %d ",(unsigned int)data[i]); }
//	  fflush(stderr);
	}
}

void ViewServer::send_3D_animation_frame( byte ind, int s, float* data, float time, const byte* info  ) {
	if( connect() > 0 ) {
	  jbyte code = 8;
	  jbyte infolen = (jbyte)slen(info);
	  jbyte index = (jbyte) ind;
	  jint size = (jint) s;
	  _ds->writeBytes(&code,1,1);
	  _ds->writeBytes(&index,1,1);
	  _ds->writeInts(&size,1,1);
	  _ds->writeBytes(&infolen,1,1);
	  if( infolen > 0 ) { _ds->writeBytes((const jbyte*)info,infolen,1); }
	  _ds->writeFloats(&time,1,1);
	  _ds->writeFloats(data,size,1);
	  _ds->flush();
  //	fprintf(stderr,"\nSending Animation Frame, size = %d\n",size);
  } 
}

void ViewServer::send_contour_image_frame( byte ind, int s, float* data, float time, const byte* info  ) {
	static float loc_scale[2] = { 1.0, 0.0 }; 
	connect();
	jbyte code = 10;
	jbyte infolen = (jbyte)slen(info);
	jbyte index = (jbyte) ind;
	jint size = (jint) s;
	_ds->writeBytes(&code,1,1);
	_ds->writeBytes(&index,1,1);
	_ds->writeInts(&size,1,1);
	_ds->writeBytes(&infolen,1,1);
	if( infolen > 0 ) { _ds->writeBytes((const jbyte*)info,infolen,1); }
	_ds->writeFloats(loc_scale,2,1);
	_ds->writeFloats(&time,1,1);
	_ds->writeFloats(data,size,1);
	_ds->flush();
//	fprintf(stderr,"\nSending Contour Animation Frame, size = %d\n",size); 
}

void ViewServer::send_contour_image_frame( byte ind, int s, float* data, float scale[2], float time, const byte* info  ) {
	if( connect() > 0 ) {
	  jbyte code = 10;
	  jbyte infolen = (jbyte)slen(info);
	  jbyte index = (jbyte) ind;
	  jint size = (jint) s;
	  _ds->writeBytes(&code,1,1);
	  _ds->writeBytes(&index,1,1);
	  _ds->writeInts(&size,1,1);
	  _ds->writeBytes(&infolen,1,1);
	  if( infolen > 0 ) { _ds->writeBytes((const jbyte*)info,infolen,1); }
	  _ds->writeFloats(scale,2,1);
	  _ds->writeFloats(&time,1,1);
	  _ds->writeFloats(data,size,1);
	  _ds->flush();
	}
  //	fprintf(stderr,"\nSending Contour Animation Frame, size = %d\n",size); 
}

byte ViewServer::create_new_graph( byte ind, int T0, int Tf, float dt, float ymin, float ymax, const byte* name, byte u, byte overwrite ) {
	if( connect() > 0 ) {
	  jbyte code = 4;
	  jbyte index = (jbyte) ind;
	  jbyte ow = (jbyte) overwrite;
	  jbyte units = (jbyte) u;
	  jint t0 = (jint) T0;
	  jint tf = (jint) Tf;
	  jbyte namelen = (jbyte)slen(name);
	  _ds->writeBytes(&code,1,1);
	  _ds->writeInts(&t0,1,1);
	  _ds->writeInts(&tf,1,1);
	  _ds->writeFloats(&dt,1,1);
	  _ds->writeFloats(&ymin,1,1);
	  _ds->writeFloats(&ymax,1,1);
	  _ds->writeBytes(&units,1,1);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes(&index,1,1);
	  _ds->writeBytes(&ow,1,1);
	  _ds->writeBytes((const jbyte*)name,namelen,1);
	  _ds->flush();
	  return index;
	} 
	return 0;
}

byte ViewServer::add_graph_component( const byte* name, const byte* color, byte gindex ) {
	if( connect() > 0 ) {
	  jbyte code = 5;
	  jbyte graph_index = (jbyte) gindex;
	  jbyte namelen = (jbyte)slen(name);
	  _ds->writeBytes(&code,1,1);
	  _ds->writeBytes(&namelen,1,1);
	  _ds->writeBytes((const jbyte*)color,5,1);
	  _ds->writeBytes(&graph_index,1,1);
	  jbyte gindex = (jbyte) graph_indices[graph_index];
	  _ds->writeBytes(&gindex,1,1);
	  _ds->writeBytes((const jbyte*)name,namelen,1);
	  _ds->flush();
  //	fprintf(stderr,"\nAdding Graph Component, name = %s\n",name); 
	  return (graph_indices[graph_index])++;
	} 
	return 0;
}

void ViewServer::send_graph_data(  byte gindex, byte cindex, int offs, int np, jfloat* data ) {
	if( connect() > 0 ) {
	  jbyte code = 6;
	  jbyte graph_index = (jbyte) gindex;
	  jbyte component_index = (jbyte) cindex;
	  jint offset = (jint) offs; 
	  jint npoints = (jint) np;
	  _ds->writeBytes(&code,1,1);
	  _ds->writeBytes(&graph_index,1,1);
	  _ds->writeBytes(&component_index,1,1);
	  _ds->writeInts(&offset,1,1);
	  _ds->writeInts(&npoints,1,1);
	  _ds->writeFloats(data,npoints,1);
	  _ds->flush();
//		fprintf(stderr,"\n  debug:: Sending Graph Data, npoints = %d, f[0] = %f\n",npoints,data[0]); 
	}
}

void ViewServer::disconnect( ) {
	if( _ds ) {
		jbyte code = -1;
		_ds->writeBytes(&code,1,1);
		_ds->disconnect();
		_ds = NULL;
	}
}

void ViewServer::setLogStream( FILE* f ) {  _logStream = f; DataSocket::setLogStream(f); }

#endif
