#!/bin/sh
#####################################################################
#
#     Makes Java Portal dist without rebuilding jar files.
#
#####################################################################

# edit the following two lines to reflect your site's configuration

INSTALL_DIR=${1}
JDK_DIR=${JAVA_HOME}       #  Directory of JDK v. 1.2 installation

# Do not edit below here.

LIB_BASE_DIR=${INSTALL_DIR}/lib/
LIB_DIR=${LIB_BASE_DIR}/SME
BIN_DIR=${INSTALL_DIR}/bin/

	if [ ! -d ${LIB_BASE_DIR} ] ; then \
	  mkdir ${LIB_BASE_DIR} ; \
	  chmod 755 ${LIB_BASE_DIR}; \
	else true; \
	fi;
	if [ ! -d ${LIB_DIR} ] ; then \
	  mkdir ${LIB_DIR} ; \
	  chmod 755 ${LIB_DIR}; \
	else true; \
	fi;
	if [ ! -d ${BIN_DIR} ] ; then \
	  mkdir ${BIN_DIR} ; \
	  chmod 755 ${BIN_DIR}; \
	else true; \
	fi;
	if [ ! -d ${LIB_DIR}/images ] ; then \
	  mkdir ${LIB_DIR}/images ; \
	  chmod 755 ${LIB_DIR}/images; \
	else true; \
	fi;
	if [ ! -d ${LIB_DIR}/docs ] ; then \
	  mkdir ${LIB_DIR}/docs ; \
	  chmod 755 ${LIB_DIR}/docs; \
	else true; \
	fi;
	if [ ! -d ${LIB_DIR}/sysdef/ ] ; then \
	   mkdir ${LIB_DIR}/sysdef/ ;\
	   mkdir ${LIB_DIR}/sysdef/colormaps/ ;\
	fi

	cp lib/defaults ${LIB_DIR}/sysdef/
	cp -r xml/dtd  ${LIB_DIR}/sysdef/
	cp xml/*.xml  ${LIB_DIR}/sysdef/
	cp xml/config/*.xml  ${LIB_DIR}/sysdef/
	cp -r xml/Projects  ${LIB_DIR}/sysdef/;

	if [ ! -d ${HOME}/.sme ] ; then \
	  echo "Install Java config files in ${HOME}/.sme"; \
	  mkdir ${HOME}/.sme; \
  	  cp xml/*.xml  xml/*.dtd  ${HOME}/.sme/; \
  	  cp xml/config/*.xml  ${HOME}/.sme/; \
  	  cp -r xml/Projects xml/dtd ${HOME}/.sme/; \
	fi

	cp lib/*.jar ${LIB_DIR}/;
	cp images/*.gif ${LIB_DIR}/images;
	cp -r help ${LIB_DIR}/docs/;
	chmod a+x bin/startup_viewserver
	cp bin/startup_viewserver ${BIN_DIR}
	chmod a+x bin/build_executable
	cp bin/build_executable ${BIN_DIR}
	chmod a+x bin/run_java_class
	cp bin/run_java_class ${BIN_DIR}
	chmod a+x bin/startup_client
	cp bin/startup_client ${BIN_DIR}
	chmod a+x bin/startup_help
	cp bin/startup_help ${BIN_DIR}
	chmod a+x bin/startup_wizard
	cp bin/startup_wizard ${BIN_DIR}
	chmod a+x bin/startup_sme
	cp bin/startup_sme ${BIN_DIR}
	chmod a+x bin/startup_mml
	cp bin/startup_mml ${BIN_DIR}
	chmod a+x bin/startup_wsm
	cp bin/startup_wsm ${BIN_DIR}
	chmod a+x bin/JST
	cp bin/JST ${BIN_DIR}
	echo Java installation complete












