import java.applet.Applet;
import java.awt.*;
import java.io.PrintStream;
import java.net.*;
import javax.swing.*;
import miiee.mml.ProjectHandler;
import miiee.servlet.*;
import miiee.util.SimIO;
import miiee.xml.XMLHandler;

public class  PortalApplet extends JApplet {

    String _workBenceName;
    String _LocalHost;
    boolean _debug;
    boolean _running;
    boolean _active;
    boolean _getProjectsFromServlet;
    ServletClient _sc;
    ProjectHandler _workBenceHandler;
    JPanel _appletPane;
    UserRegister _ur;

    public PortalApplet()
    {
        _debug= true; 
        _running= false; 
        _active= false; 
        _getProjectsFromServlet= false; 
    }

    public void destroy()
    {
        System.out.println("PortalApplet::destroy"); 
        if (_sc != null) 
        {
            _sc.destroy(); 
            _sc= null; 
        }
        SimIO.setApplet(((JApplet)null)); 
        _active= false; 
    }

    ServletClient getServletClient()
    {
        return _sc; 
    }

    public void init()
    {
        String servletName;
        String host;
        String protocol;
        int port;
        String url;
        System.out.println("PortalApplet::init"); 
        if (_running)
        {
            stop(); 
        }
        if (_active)
        {
            destroy(); 
        }
        SimIO.setApplet(((JApplet)this)); 

        _workBenceName= getParameter("WorkBence"); 
        _LocalHost= getParameter("LocalHost"); 
        servletName= getParameter("ServletName"); 
        if (_workBenceName == null) 
        {
            _workBenceName= "SME"; 
        }
        URL codebase= getCodeBase(); 
        host= codebase.getHost(); 
        protocol= codebase.getProtocol(); 
        port= codebase.getPort(); 
        url= protocol + "://" + host + ":" + port; 
        try
        {
            URL servletBase;
            if (servletName != null) 
            {
				 servletBase= new URL(protocol + "://" + host + ":" + port); 
				 SimIO.print(" Attaching to Servlet, base: " + servletBase + ", servlet name: " + servletName );
                _sc= ServletClient.getInstance(servletBase, servletName); 
                _sc.setWorkBench(_workBenceName, _LocalHost); 
            }
        }
        catch (java.net.MalformedURLException MalformedURLException0)
        {
            SimIO.show_error(((Component)getContentPane()), "Malformed URL: " + url); 
        }
        catch ( Exception err ) {
			SimIO.show_error(((Component)getContentPane()), err ); 
			err.printStackTrace();
       }
        _active= true; 
    }

    public void start()
    {
        System.out.println("PortalApplet::start"); 
        
        if (_running) { stop(); }
        
        if (_ur == null) try {
        
            _ur= new UserRegister(_workBenceName, _sc); 
            
        } catch( Exception err ) {
			SimIO.show_error(((Component)getContentPane()), err ); 
			err.printStackTrace();
        }
        
        if (_ur.showConnectionDialog(((String)null))) try {
            _workBenceHandler= ProjectHandler.create(_workBenceName, _LocalHost); 
            _workBenceHandler.setUserRegister(_ur); 
            _workBenceHandler.readXML(_workBenceName); 
            _workBenceHandler.blockUntilReadCompleted(); 
            System.out.println("adding AppletPane"); 
            Container top= getContentPane(); 
            _appletPane= _workBenceHandler.createContentPane(); 
            top.add(((Component)_appletPane)); 
            _appletPane.invalidate(); 
            top.invalidate(); 
            repaint(); 
            System.out.println(" AppletPane added and repainted "); 
        } catch( Exception err ) {
			SimIO.show_error(((Component)getContentPane()), err ); 
			err.printStackTrace();
        }
        _running= true; 
    }

    public void stop()
    {
        System.out.println("PortalApplet::stop"); 
        getContentPane().remove(((Component)_appletPane)); 
        _workBenceHandler.dispose(); 
        _workBenceHandler= null; 
        _appletPane= null; 
        _running= false; 
    }
}

